/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script;

import com.ats.crypto.Passwords;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.executor.channels.ChannelManager;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.ScriptValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.generator.variables.transform.DateTransformer;
import com.ats.generator.variables.transform.TimeTransformer;
import com.ats.generator.variables.transform.Transformer;
import com.ats.script.actions.Action;
import com.ats.tools.logger.ExecutionLogger;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;

public class Script {
    public static final Pattern OBJECT_PATTERN = Pattern.compile("(.*)\\[(.*)\\]", 2);
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String ATS_EXTENSION = "ats";
    public static final String ATS_FILE_EXTENSION = ".ats";
    public static final String ATS_VISUAL_EXTENSION = "atsv";
    public static final String ATS_VISUAL_FILE_EXTENSION = ".atsv";
    public static final String ATS_VISUAL_FOLDER = "visual";
    public static final String SCRIPT_LOG = "SCRIPT";
    public static final String COMMENT_LOG = "COMMENT";
    private ParameterList parameterList;
    private List<Variable> variables = new ArrayList<Variable>();
    private ArrayList<CalculatedValue> returns;
    protected List<ActionTestScript> scriptCallTree;
    protected String csvAbsoluteFilePath;
    protected int iteration = 0;
    protected ChannelManager channelManager;
    private Map<String, String> testExecutionVariables;
    protected ExecutionLogger logger = new ExecutionLogger();
    protected Passwords passwords;

    public Script() {
    }

    public Script(ExecutionLogger logger) {
        this.setLogger(logger);
    }

    public String getPassword(String name) {
        return this.passwords.getPassword(name);
    }

    public void sendLog(int code, String message) {
        this.logger.sendLog(code, message, "");
    }

    public void sendLog(int code, String message, String value) {
        this.logger.sendLog(code, message, value);
    }

    public void sendLog(int code, String message, Object value) {
        this.logger.sendLog(code, message, value);
    }

    public void sendInfoLog(String message, String value) {
        this.logger.sendInfo(message, value);
    }

    public void sendActionLog(Action action, String testName, int line) {
        this.logger.sendAction(action, testName, line);
    }

    public void sendWarningLog(String message, String value) {
        this.logger.sendWarning(message, value);
    }

    public void sendErrorLog(String message, String value) {
        this.logger.sendError(message, value);
    }

    public void sendCommentLog(String calculated) {
        this.logger.sendExecLog(COMMENT_LOG, calculated);
    }

    public void sendScriptInfo(String value) {
        this.logger.sendExecLog(SCRIPT_LOG, value);
    }

    public void sendScriptFail(String value) {
        if (value != null) {
            this.logger.sendExecLog("FAILED", value);
        }
    }

    public void setLogger(ExecutionLogger logger) {
        if (logger != null) {
            this.logger = logger;
        }
    }

    public void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void setTestExecutionVariables(Map<String, String> params) {
        this.testExecutionVariables = params;
    }

    protected Map<String, String> getTestExecutionVariables() {
        return this.testExecutionVariables;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> data) {
        this.variables = data;
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public void setParameterList(ParameterList data) {
        this.parameterList = data;
    }

    public CalculatedValue[] getReturns() {
        if (this.returns != null) {
            return this.returns.toArray(new CalculatedValue[this.returns.size()]);
        }
        return null;
    }

    public void setReturns(CalculatedValue[] data) {
        this.returns = new ArrayList<CalculatedValue>(Arrays.asList(data));
    }

    protected void addToScriptCallTree(ActionTestScript sc, String name) {
        if (this.scriptCallTree != null && !this.scriptCallTree.stream().filter(a -> a.getTestName().equals(name)).findFirst().isPresent()) {
            this.scriptCallTree.add(sc);
        }
    }

    public String getGlobalVariableValue(String varPath) {
        if (this.scriptCallTree != null) {
            int lastDot = varPath.lastIndexOf(".");
            if (lastDot > -1) {
                Variable scVar;
                String scriptPath = varPath.substring(0, lastDot);
                Optional<ActionTestScript> sc = this.scriptCallTree.stream().filter(a -> a.getTestName().equals(scriptPath)).findFirst();
                if (sc.isPresent() && (scVar = sc.get().getVariable(varPath.substring(lastDot + 1))) != null) {
                    return scVar.getCalculatedValue();
                }
            }
            this.sendWarningLog("Unable to find global variable", varPath);
        }
        return "";
    }

    public boolean checkVariableExists(String name) {
        for (Variable variable : this.getVariables()) {
            if (!variable.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Variable getVariable(String name, boolean noCalculation) {
        Variable foundVar = this.getVariable(name);
        if (foundVar == null) {
            foundVar = this.createVariable(name, new CalculatedValue(this, ""), null);
        }
        if (noCalculation) {
            foundVar.getValue().setData("");
            foundVar.setCalculation(false);
        }
        return foundVar;
    }

    public Variable getVariable(String name) {
        Optional<Variable> opt = this.variables.stream().filter(p -> p.getName().equals(name)).findFirst();
        if (opt != null && opt.isPresent()) {
            return opt.get();
        }
        return null;
    }

    public Variable addVariable(String name, CalculatedValue value, Transformer transformer) {
        Variable foundVar = this.getVariable(name);
        if (foundVar == null) {
            foundVar = this.createVariable(name, value, transformer);
        } else {
            foundVar.setValue(value);
            foundVar.setTransformation(transformer);
        }
        return foundVar;
    }

    public Variable createVariable(String name, CalculatedValue value, Transformer transformer) {
        Variable newVar = new Variable(name, value, transformer);
        this.variables.add(newVar);
        return newVar;
    }

    public String getVariableValue(String variableName) {
        return this.getVariable(variableName, false).getCalculatedValue();
    }

    public String[] getParameters() {
        if (this.parameterList == null) {
            return new String[0];
        }
        return this.parameterList.getParameters();
    }

    public ScriptValue getParameter(String name) {
        return new ScriptValue(this.getParameterValue(name, ""));
    }

    public ScriptValue getParameter(int index) {
        return new ScriptValue(this.getParameterValue(index, ""));
    }

    public String getParameterValue(String name) {
        return this.getParameterValue(name, "");
    }

    public String getParameterValue(String name, String defaultValue) {
        if (this.parameterList == null) {
            return defaultValue;
        }
        try {
            int index = Integer.parseInt(name);
            return this.getParameterValue(index, defaultValue);
        }
        catch (NumberFormatException numberFormatException) {
            return this.parameterList.getParameterValue(name, defaultValue);
        }
    }

    public String getParameterValue(int index) {
        return this.getParameterValue(index, "");
    }

    public String getParameterValue(int index, String defaultValue) {
        if (this.parameterList == null) {
            return defaultValue;
        }
        return this.parameterList.getParameterValue(index, defaultValue);
    }

    public String getSystemValue(String name) {
        Channel cnl;
        if (this.channelManager != null && (cnl = this.channelManager.getCurrentChannel()) != null) {
            return cnl.getSystemValue(name);
        }
        return "";
    }

    public String getEnvironmentValue(String name, String defaultValue) {
        String value = System.getProperty(name);
        if (value != null) {
            return value;
        }
        if (this.testExecutionVariables != null && (value = this.testExecutionVariables.get(name)) != null) {
            return value;
        }
        value = System.getenv(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getUuidValue() {
        return UUID.randomUUID().toString();
    }

    public String getTodayValue() {
        return DateTransformer.getTodayValue();
    }

    public String getNowValue() {
        return TimeTransformer.getNowValue();
    }

    public int getIteration() {
        return this.iteration;
    }

    public String getCsvFilePath() {
        return this.csvAbsoluteFilePath;
    }

    public File getCsvFile() {
        return new File(this.csvAbsoluteFilePath);
    }

    public File getAssetsFile(String relativePath) {
        if (!((String)relativePath).startsWith("/")) {
            relativePath = "/" + (String)relativePath;
        }
        relativePath = "assets" + (String)relativePath;
        URL url = this.getClass().getClassLoader().getResource((String)relativePath);
        if (url != null) {
            try {
                return Paths.get(url.toURI()).toFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getAssetsUrl(String relativePath) {
        URL url = this.getClass().getClassLoader().getResource(relativePath);
        if (url != null) {
            return "file://" + url.getPath();
        }
        return "";
    }
}

