/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script;

import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.SystemValues;
import com.ats.generator.ATS;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.mouse.Mouse;
import com.ats.generator.variables.ConditionalValue;
import com.ats.generator.variables.Variable;
import com.ats.script.Project;
import com.ats.script.actions.Action;
import com.ats.script.actions.neoload.ActionNeoload;
import com.ats.script.actions.performance.ActionPerformance;
import com.ats.script.actions.performance.octoperf.ActionOctoperfVirtualUser;
import com.ats.tools.Operators;
import com.ats.tools.Utils;
import java.io.File;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.openqa.selenium.Keys;
import org.testng.annotations.Test;

public class ScriptHeader {
    private Project project;
    private String path = "";
    private String projectPath = "";
    private String packageName = "";
    private String name = "";
    private String id = "";
    private String squashId = "";
    private String jiraId = "";
    private List<String> groups = List.of();
    private String description = "";
    private String author = "";
    private String prerequisite = "";
    private Date createdAt = new Date();
    private static final String javaCode = String.join((CharSequence)System.getProperty("line.separator"), "", "//---------------------------------------------------------------------------------------", "//\t    _  _____ ____     ____                           _             ", "//\t   / \\|_   _/ ___|   / ___| ___ _ __   ___ _ __ __ _| |_ ___  _ __ ", "//\t  / _ \\ | | \\___ \\  | |  _ / _ \\ '_ \\ / _ \\ '__/ _` | __/ _ \\| '__|", "//\t / ___ \\| |  ___) | | |_| |  __/ | | |  __/ | | (_| | || (_) | |   ", "//\t/_/   \\_\\_| |____/   \\____|\\___|_| |_|\\___|_|  \\__,_|\\__\\___/|_|   ", "//", "//---------------------------------------------------------------------------------------", "//\t/!\\ Warning /!\\", "//\tThis class was automatically generated by ATS Script Generator (ver. #ATS_VERSION#)", "//\tYou may loose modifications if you edit this file manually !", "//---------------------------------------------------------------------------------------", "", "import " + Test.class.getName() + ";", "import " + ScriptHeader.class.getPackageName() + ".*;", "import " + Action.class.getPackageName() + ".*;", "import " + ActionNeoload.class.getPackageName() + ".*;", "import " + ActionPerformance.class.getPackageName() + ".*;", "import " + ActionOctoperfVirtualUser.class.getPackageName() + ".*;", "import " + ActionTestScript.class.getName() + ";", "import " + Cartesian.class.getName() + ";", "import " + Mouse.class.getName() + ";", "import " + Variable.class.getName() + ";", "import " + ConditionalValue.class.getName() + ";", "import " + Operators.class.getName() + ";", "import " + Keys.class.getName() + ";", "", "public class #CLASS_NAME# extends " + ActionTestScript.class.getSimpleName() + "{", "", "\t/**", "\t* Test Name : <b>#TEST_NAME#</b>", "\t* Generated at : <b>" + DateFormat.getDateTimeInstance().format(new Date()) + "</b>", "\t*/", "", "\tpublic #CLASS_NAME#(){super();}", "\tpublic #CLASS_NAME#(" + ActionTestScript.class.getName() + " sc){super(sc);}", "", "\t@Override", "\tpublic final String gav(){return \"#PROJECT_GAV#\";}", "", "\t@Override", "\tprotected " + ScriptHeader.class.getSimpleName() + " getHeader(){", "\t\treturn new ScriptHeader(", "\t\t\t\"#SCRIPT_ID#\",", "\t\t\t\"#AUTHOR_NAME#\",", "\t\t\t\"#DESCRIPTION#\",", "\t\t\t\"#PREREQUISITES#\",", "\t\t\t\"#GROUP_DESCRIPTION#\");", "\t}", "", "\t@Test#GROUP_DATA#", "\tpublic void testMain(){");

    public ScriptHeader() {
    }

    public ScriptHeader(String id, String author, String description, String prerequisites, String groups) {
        this.id = id;
        this.author = author;
        this.description = description;
        this.prerequisite = prerequisites;
        this.groups = Arrays.asList(groups.split(","));
    }

    public ScriptHeader(Project prj, File file) {
        this.project = prj;
        this.setProjectPath(this.project.getFolderPath());
        this.setPath(file.getAbsolutePath());
        this.setName(Utils.removeExtension(file.getName()));
        try {
            Path relative = this.project.getAtsSourceFolder().relativize(file.getParentFile().toPath());
            this.setPackageName(relative.toString().replace(File.separator, "."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public File getTestReportFolder(Path path) {
        return this.project.getReportFolder().toFile();
    }

    public File getReportFolder() {
        return this.project.getReportFolder().toFile();
    }

    public File getJavaDestinationFolder() {
        return this.project.getJavaDestinationFolder().toFile();
    }

    public File getJavaFile() {
        return this.project.getJavaFile(this.getPackagePath() + this.name + ".java");
    }

    public String getPackagePath() {
        Object path = this.packageName.replace(".", File.separator);
        if (((String)path).length() > 0) {
            path = (String)path + File.separator;
        }
        return path;
    }

    public void parseGroups(String data) {
        this.groups = Arrays.stream(data.split(",")).map(String::trim).filter(s -> s.length() > 0).collect(Collectors.toList());
    }

    public String getDataGroups() {
        if (this.groups != null) {
            return String.join((CharSequence)",", this.groups);
        }
        return "";
    }

    public String getJoinedGroups() {
        if (this.groups != null) {
            StringJoiner joiner = new StringJoiner(", ");
            for (int i = 0; i < this.groups.size(); ++i) {
                if (this.groups.get(i).length() <= 0) continue;
                joiner.add("\"" + this.groups.get(i) + "\"");
            }
            return joiner.toString();
        }
        return "";
    }

    private String getGroupCode() {
        String code = this.getJoinedGroups();
        if (code.length() > 0) {
            return "(groups={" + code + "})";
        }
        return "";
    }

    public String getQualifiedName() {
        if (this.packageName.length() > 0) {
            return this.packageName + "." + this.name;
        }
        return this.name;
    }

    public String getJavaCode(Project project) {
        Object code = javaCode.replace("#CLASS_NAME#", this.name).replace("#TEST_NAME#", this.getQualifiedName()).replace("#SCRIPT_ID#", StringEscapeUtils.escapeJava((String)this.id)).replace("#DESCRIPTION#", StringEscapeUtils.escapeJava((String)this.description)).replace("#PREREQUISITES#", StringEscapeUtils.escapeJava((String)this.prerequisite)).replace("#AUTHOR_NAME#", StringEscapeUtils.escapeJava((String)this.author)).replace("#GROUP_DATA#", this.getGroupCode()).replace("#ATS_VERSION#", ATS.VERSION).replace("#GROUP_DESCRIPTION#", this.getDataGroups()).replace("#PROJECT_GAV#", StringEscapeUtils.escapeJava((String)project.getGav()));
        if (this.packageName.length() > 0) {
            code = "package " + this.packageName + ";\r\n" + (String)code;
        }
        return code;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> value) {
        this.groups = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String value) {
        this.author = value;
    }

    public String getPrerequisite() {
        return this.prerequisite;
    }

    public void setPrerequisite(String value) {
        this.prerequisite = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getJiraId() {
        return this.jiraId;
    }

    public void setJiraId(String value) {
        this.jiraId = value;
    }

    public String getSquashId() {
        return this.squashId;
    }

    public void setSquashId(String value) {
        this.squashId = value;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String value) {
        this.packageName = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String value) {
        this.projectPath = value;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setSystemProperties(String value) {
    }

    public String getSystemProperties() {
        return String.join((CharSequence)",", SystemValues.VALUES_NAME);
    }
}

