/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.element.TestElement;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.ConditionalValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.parameter.Parameter;
import com.ats.generator.variables.parameter.ParameterDataFile;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionReturnVariableArray;
import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsFailError;
import com.google.gson.JsonObject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.Assert;

public class ActionCallscript
extends ActionReturnVariableArray {
    public static final String SCRIPT_LABEL = "subscript";
    private static final int RND_INDEX_VALUE = -1;
    private static final int NO_INDEX_VALUE = -2;
    private static final String SCRIPT_LOOP = "loop";
    public static final Pattern LOOP_REGEXP = Pattern.compile("loop ?\\((\\d+)\\)", 2);
    public static final String ASSETS_PROTOCOLE = "assets:///";
    public static final String FILE_PROTOCOLE = "file:///";
    public static final String HTTP_PROTOCOLE = "http://";
    public static final String HTTPS_PROTOCOLE = "https://";
    private CalculatedValue name;
    private int type = -1;
    private SearchedElement searchElement;
    private ArrayList<Variable> scriptVariables;
    private ParameterList parameters;
    private int loop = 1;
    private int parameterFileIndex = -2;
    private CalculatedValue parameterFilePath;
    private ConditionalValue condition;

    public ActionCallscript() {
    }

    public ActionCallscript(ScriptLoader script, ArrayList<String> options, String name, String[] parameters, String[] returnValue, String csvFilePath, ArrayList<String> dataArray) {
        super(script);
        String firstParam;
        this.setName(new CalculatedValue(script, name));
        if (csvFilePath != null) {
            this.setParameterFilePath(new CalculatedValue(script, csvFilePath));
            if (dataArray != null && dataArray.size() > 0) {
                String l = dataArray.remove(0);
                this.parameterFileIndex = l.contains("rnd") || l.contains("random") ? -1 : Utils.string2Int(l, -2);
            }
        } else if (dataArray != null && dataArray.size() > 0) {
            this.searchElement = new SearchedElement(script, dataArray);
        } else if (parameters.length > 0 && !this.setParameterFilePathData(firstParam = parameters[0].trim())) {
            String[] paramsValues = new ArrayList();
            String[] stringArray = parameters;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String param = stringArray[i];
                Matcher match = LOOP_REGEXP.matcher(param = param.replaceAll("\n", ","));
                if (match.find()) {
                    this.loop = Utils.string2Int(match.group(1), 1);
                    continue;
                }
                paramsValues.add(new CalculatedValue(script, param.trim()));
            }
            this.setParameters((ArrayList<CalculatedValue>)paramsValues);
        }
        if (returnValue.length > 0 && this.loop == 1) {
            ArrayList<Variable> variableValues = new ArrayList<Variable>();
            for (String varName : returnValue) {
                variableValues.add(script.getVariable(varName.trim(), true));
            }
            this.setVariables(variableValues);
        }
        if (options.size() > 0) {
            String option = options.get(0);
            int operatorIndex = option.indexOf("=");
            if (operatorIndex > 1) {
                this.condition = new ConditionalValue(script, option.substring(0, operatorIndex).trim(), option.substring(operatorIndex + 1).trim());
            } else {
                operatorIndex = option.indexOf("<>");
                if (operatorIndex > 1) {
                    this.condition = new ConditionalValue(script, option.substring(0, operatorIndex).trim(), option.substring(operatorIndex + 2).trim(), "<>");
                }
            }
        }
    }

    public ActionCallscript(Script script, CalculatedValue name) {
        super(script);
        this.setName(name);
    }

    public ActionCallscript(Script script, CalculatedValue name, SearchedElement element) {
        this(script, name);
        this.setSearchElement(element);
    }

    public ActionCallscript(Script script, CalculatedValue name, CalculatedValue[] parameters) {
        this(script, name);
        this.setParameters(new ArrayList<CalculatedValue>(Arrays.asList(parameters)));
    }

    public ActionCallscript(Script script, CalculatedValue name, Variable ... variables) {
        this(script, name);
        this.setVariables(new ArrayList<Variable>(Arrays.asList(variables)));
    }

    public ActionCallscript(Script script, CalculatedValue name, CalculatedValue[] parameters, Variable ... variables) {
        this(script, name);
        this.setParameters(new ArrayList<CalculatedValue>(Arrays.asList(parameters)));
        this.setVariables(new ArrayList<Variable>(Arrays.asList(variables)));
    }

    public ActionCallscript(Script script, CalculatedValue name, CalculatedValue csvFilePath, int index) {
        this(script, name);
        this.setParameterFilePath(csvFilePath);
        this.setParameterFileIndex(index);
    }

    public ActionCallscript(Script script, CalculatedValue name, CalculatedValue[] parameters, int loop) {
        this(script, name, parameters);
        this.setLoop(loop);
    }

    public ActionCallscript(Script script, CalculatedValue name, int loop) {
        this(script, name);
        this.setLoop(loop);
    }

    public static String getScriptLog(String testName, int line, JsonObject log) {
        StringBuilder sb = new StringBuilder("Subscript init (").append(testName).append(":").append(line).append(") -> ").append(log.toString());
        return sb.toString();
    }

    public boolean isSubscriptCalled(String scriptName) {
        return this.name.getCalculated().equals(scriptName);
    }

    private boolean setParameterFilePathData(String value) {
        if (value != null && (value.startsWith(ASSETS_PROTOCOLE) || value.startsWith(FILE_PROTOCOLE) || value.startsWith(HTTP_PROTOCOLE) || value.startsWith(HTTPS_PROTOCOLE))) {
            this.setParameterFilePath(new CalculatedValue(this.script, value));
            return true;
        }
        return false;
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(this.name.getJavaCode());
        if (this.parameterFilePath != null) {
            codeBuilder.append(", ").append(this.parameterFilePath.getJavaCode()).append(", ").append(this.parameterFileIndex);
        } else if (this.searchElement != null) {
            codeBuilder.append(", ").append(this.searchElement.getJavaCode());
        } else {
            if (this.parameters != null) {
                this.parameters.getJavaCode(codeBuilder);
            }
            if (this.loop > 1) {
                codeBuilder.append(", ").append(this.loop);
            } else if (this.getVariables() != null) {
                StringJoiner joiner = new StringJoiner(", ");
                for (Variable variable : this.getVariables()) {
                    joiner.add(variable.getName());
                }
                codeBuilder.append(", ").append(joiner.toString());
            }
        }
        codeBuilder.append(")");
        if (this.condition != null) {
            return this.condition.getJavaCode(codeBuilder, this.getLine());
        }
        return codeBuilder;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.name.getData());
        if (this.parameterFilePath != null) {
            keywords.add(this.parameterFilePath.getKeywords());
        }
        if (this.searchElement != null) {
            keywords.addAll(this.searchElement.getKeywords());
        }
        return keywords;
    }

    private ActionTestScript getNewAtsInstance(Class<ActionTestScript> clazz, ActionTestScript topScript, String scriptName) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ActionTestScript ats = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ats.setTopScript(topScript, scriptName);
        return ats;
    }

    @Override
    public boolean execute(ActionTestScript ts, String testName, int line) {
        block25: {
            Channel currentChannel = ts.getCurrentChannel();
            this.setStatus(currentChannel.newActionStatus(testName, line));
            String scriptName = this.name.getCalculated();
            Class<ActionTestScript> clazz = currentChannel.loadTestScriptClass(scriptName);
            if (clazz == null) {
                this.status.setError(422, "ATS script not found : '" + scriptName + "' (maybe a letter case issue ?)\n");
            } else {
                ActionTestScript topScript = ts.getTopScript();
                try {
                    if (this.parameterFilePath != null) {
                        String csvPath = this.parameterFilePath.getCalculated();
                        URL csvUrl = null;
                        if (csvPath.startsWith(ASSETS_PROTOCOLE)) {
                            String csvFilePath = csvPath.replace(ASSETS_PROTOCOLE, "assets" + File.separator);
                            csvUrl = this.getClass().getClassLoader().getResource(csvFilePath);
                            if (csvUrl == null) {
                                csvUrl = this.getClass().getClassLoader().getResource(csvFilePath + ".csv");
                            }
                        } else {
                            try {
                                csvUrl = new URL(csvPath);
                            }
                            catch (MalformedURLException csvFilePath) {
                                // empty catch block
                            }
                        }
                        if (csvUrl == null) {
                            this.status.setError(-20, "CSV file not found : " + csvPath);
                            return true;
                        }
                        ParameterDataFile data = Utils.loadData(csvUrl);
                        if (data.noError() && data.getSize() > 0) {
                            String csvAbsoluteFilePath = null;
                            try {
                                csvAbsoluteFilePath = csvPath.startsWith(HTTP_PROTOCOLE) || csvPath.startsWith(HTTPS_PROTOCOLE) ? csvUrl.toString() : new File(csvUrl.toURI()).getAbsolutePath();
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                // empty catch block
                            }
                            Method testMain = clazz.getDeclaredMethod("testMain", new Class[0]);
                            int iterationMax = data.getSize();
                            int iteration = 0;
                            if (this.parameterFileIndex > -2) {
                                ParameterList row;
                                int selectedIndex = this.parameterFileIndex;
                                if (selectedIndex == -1) {
                                    selectedIndex = (int)(Math.random() * (double)iterationMax);
                                }
                                if ((row = data.getData(selectedIndex)) != null) {
                                    this.callScriptWithParametersFile(testMain, this.getNewAtsInstance(clazz, topScript, scriptName), ts, testName, line, row, 0, 1, scriptName, csvAbsoluteFilePath);
                                }
                            } else {
                                for (ParameterList row : data.getData()) {
                                    this.callScriptWithParametersFile(testMain, this.getNewAtsInstance(clazz, topScript, scriptName), ts, testName, line, row, iteration, iterationMax, scriptName, csvAbsoluteFilePath);
                                    ++iteration;
                                }
                            }
                            break block25;
                        }
                        this.status.setError(-18, "Data load file error : " + csvPath + " -> " + data.getError());
                        break block25;
                    }
                    ActionTestScript ats = this.getNewAtsInstance(clazz, topScript, scriptName);
                    Method testMain = clazz.getDeclaredMethod("testMain", new Class[0]);
                    if (this.searchElement != null) {
                        List<ParameterList> data = ActionCallscript.getElementTextData(ts.getCurrentChannel(), this.searchElement);
                        int iterationMax = data.size();
                        for (int iteration = 0; iteration < iterationMax; ++iteration) {
                            ats.initCalledScript(ts, testName, line, data.get(iteration), this.getVariables(), iteration, iterationMax, scriptName, SCRIPT_LOOP, null);
                            testMain.invoke((Object)ats, new Object[0]);
                        }
                    } else {
                        for (int iteration = 0; iteration < this.loop; ++iteration) {
                            ats.initCalledScript(ts, testName, line, this.parameters, this.getVariables(), iteration, this.loop, scriptName, SCRIPT_LOOP, null);
                            testMain.invoke((Object)ats, new Object[0]);
                        }
                    }
                    this.status.setData(ats.getReturnValues());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
                    Assert.fail((String)e.getMessage());
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof AtsFailError) {
                        AtsFailError target = (AtsFailError)((Object)e.getTargetException());
                        ts.getTopScript().addErrorStack(target.getInfo());
                        ts.getTopScript().addErrorStack(testName + ":" + line);
                        Assert.fail((String)target.getFullMessage());
                    }
                    ts.getTopScript().addErrorStack(testName + ":" + line);
                    Assert.fail((String)e.getTargetException().getMessage());
                }
            }
        }
        this.condition = null;
        this.status.endDuration();
        return true;
    }

    public static List<ParameterList> getElementTextData(Channel channel, SearchedElement element) {
        TestElement foundElement = new TestElement(channel, 10, p -> p > 0, element);
        for (int max = 10; max > 0 && foundElement.getCount() == 0; --max) {
            channel.sleep(500);
            foundElement = new TestElement(channel, 10, p -> p > 0, element);
        }
        if (foundElement.getCount() > 0) {
            return foundElement.getTextData();
        }
        return Collections.emptyList();
    }

    private void callScriptWithParametersFile(Method testMain, ActionTestScript ats, ActionTestScript atsCaller, String testName, int line, ParameterList row, int iteration, int iterationMax, String scriptName, String csvAbsoluteFilePath) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        row.updateCalculated(atsCaller);
        ats.initCalledScript(atsCaller, testName, line, row, null, iteration, iterationMax, scriptName, "dataFile", csvAbsoluteFilePath);
        testMain.invoke((Object)ats, new Object[0]);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("status", "terminated");
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public CalculatedValue getName() {
        return this.name;
    }

    public void setName(CalculatedValue name) {
        this.name = name;
    }

    @Override
    public void setVariables(ArrayList<Variable> value) {
        if (value != null && value.size() > 0) {
            super.setVariables(value);
            this.parameterFilePath = null;
            this.loop = 1;
        }
    }

    public ParameterList getParameters() {
        return this.parameters;
    }

    public void setParameters(ParameterList value) {
        if (value != null && value.getParametersSize() > 0) {
            this.parameters = value;
            this.parameterFilePath = null;
        }
    }

    public void setParameters(ArrayList<CalculatedValue> calcs) {
        this.parameters = new ParameterList(0);
        int i = 0;
        for (CalculatedValue calc : calcs) {
            this.parameters.addParameter(new Parameter(i, calc));
            ++i;
        }
    }

    public int getLoop() {
        return this.loop;
    }

    public void setLoop(int loop) {
        if (loop <= 0) {
            loop = 1;
        }
        if (loop > 1) {
            this.parameterFilePath = null;
            this.setVariables(null);
        }
        this.loop = loop;
    }

    public SearchedElement getSearchElement() {
        return this.searchElement;
    }

    public void setSearchElement(SearchedElement value) {
        this.searchElement = value;
    }

    public int getParameterFileIndex() {
        return this.parameterFileIndex;
    }

    public void setParameterFileIndex(int parameterFileIndex) {
        this.parameterFileIndex = parameterFileIndex;
    }

    public CalculatedValue getParameterFilePath() {
        return this.parameterFilePath;
    }

    public void setParameterFilePath(CalculatedValue value) {
        this.parameterFilePath = value;
        if (value != null) {
            this.parameters = null;
            this.setVariables(null);
            this.loop = 1;
        }
    }

    public ConditionalValue getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionalValue condition) {
        this.condition = condition;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public ArrayList<Variable> getScriptVariables() {
        return this.scriptVariables;
    }

    public void setScriptVariables(ArrayList<Variable> scriptVariable) {
        this.scriptVariables = scriptVariable;
    }
}

