/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionChannelExist;

public class ActionChannelClose
extends ActionChannelExist {
    public static final String SCRIPT_CLOSE_LABEL = "channel-close";
    public static final String NO_STOP_LABEL = "nostop";
    private boolean keepRunning = false;

    public ActionChannelClose() {
    }

    public ActionChannelClose(Script script, String name, boolean keepRunning) {
        super(script, name);
        this.keepRunning = keepRunning;
    }

    @Override
    public boolean execute(ActionTestScript ts, String testName, int testLine) {
        super.execute(ts, testName, testLine);
        if (this.channelEmpty) {
            ts.getTopScript().sendWarningLog("ActionChannelClose (" + testName + ":" + testLine + ")", "Cannot close Channel '" + this.getName() + "', this channel is not running !");
        } else {
            ts.getChannelManager().closeChannel(this.status, this.getName(), this.keepRunning);
        }
        return true;
    }

    public boolean isKeepRunning() {
        return this.keepRunning;
    }

    public void setKeepRunning(boolean keepRunning) {
        this.keepRunning = keepRunning;
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append("\"").append(this.getName()).append("\", ").append(this.keepRunning).append(")");
    }
}

