/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.Action;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class ActionComment
extends Action {
    public static final String SCRIPT_LABEL = "comment";
    private static final String STEP_TYPE = "step";
    private static final String LOG_TYPE = "log";
    private static final String SCRIPT_TYPE = "script";
    private static final String SUMMARY_TYPE = "summary";
    private CalculatedValue comment;
    private String type = "script";

    public ActionComment() {
    }

    public ActionComment(ScriptLoader script, String type, ArrayList<String> dataArray) {
        super(script);
        if (!SCRIPT_LABEL.equals(type)) {
            int minusPos = type.indexOf("-");
            if (minusPos > -1) {
                this.setType(type.substring(minusPos + 1));
            } else if (dataArray.size() > 0) {
                this.setType(dataArray.remove(0).trim());
            }
        }
        if (dataArray.size() > 0) {
            if (dataArray.size() > 1) {
                this.setType(dataArray.remove(0).trim());
            }
            this.setComment(new CalculatedValue(script, dataArray.remove(0).trim()));
        } else {
            this.setComment(new CalculatedValue(script));
        }
    }

    public ActionComment(ScriptLoader script, String data) {
        super(script);
        this.setType(SCRIPT_TYPE);
        this.setComment(new CalculatedValue(script, data));
    }

    public ActionComment(Script script, String type, CalculatedValue value) {
        super(script);
        this.setType(type);
        this.setComment(value);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("type", this.type);
        data.addProperty("value", this.comment.getCalculated());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append("\"").append(this.getType()).append("\", ").append(this.comment.getJavaCode()).append(")");
        return codeBuilder;
    }

    @Override
    public boolean isScriptComment() {
        return SCRIPT_TYPE.equals(this.type);
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.comment.getKeywords());
        return keywords;
    }

    @Override
    public boolean execute(ActionTestScript ts, String testName, int testLine) {
        if (STEP_TYPE.equals(this.type)) {
            super.execute(ts, testName, testLine);
            this.status.endDuration();
            ts.getRecorder().update(this.type, this.comment.getCalculated());
            return true;
        }
        this.status = ts.getCurrentChannel().newActionStatus(testName, testLine);
        this.status.endDuration();
        if (LOG_TYPE.equals(this.type)) {
            ts.getTopScript().sendCommentLog(this.comment.getCalculated());
        } else if (SUMMARY_TYPE.equals(this.type)) {
            ts.getRecorder().updateSummary(testName, testLine, this.comment.getCalculated());
        }
        return false;
    }

    public CalculatedValue getComment() {
        return this.comment;
    }

    public void setComment(CalculatedValue comment) {
        this.comment = comment;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = LOG_TYPE.equals(value) || STEP_TYPE.equals(value) || SUMMARY_TYPE.equals(value) ? value : SCRIPT_TYPE;
    }
}

