/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecuteElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ActionGesturePress
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL = "press";
    private ArrayList<String> paths;
    private int duration;

    public ActionGesturePress() {
    }

    public ActionGesturePress(Script script, int stopPolicy, ArrayList<String> options, ArrayList<String> paths, ArrayList<String> elements) {
        super(script, stopPolicy, options, elements);
        this.setPaths(paths);
        this.parseOptions(options);
    }

    public ActionGesturePress(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, int duration, String[] paths) {
        super(script, stopPolicy, maxTry, delay, element);
        this.setDuration(duration);
        this.setPaths(new ArrayList<String>(Arrays.asList(paths)));
    }

    private void parseOptions(ArrayList<String> options) {
        this.setDuration(2);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(", ").append(this.duration).append(", ").append("new String[]{");
        List myFinalList = this.getPaths().stream().map(path -> "\"" + path.trim() + "\"").collect(Collectors.toList());
        String test = String.join((CharSequence)",", myFinalList);
        codeBuilder.append(test);
        codeBuilder.append("}").append(")");
        return codeBuilder;
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            ts.getRecorder().updateScreen(true);
            this.getTestElement().press(this.getDuration(), this.getPaths());
            this.status.endAction();
            ts.getRecorder().updateScreen(0, this.status.getDuration());
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = Math.max(duration, 0);
    }

    public ArrayList<String> getPaths() {
        return this.paths;
    }

    public void setPaths(ArrayList<String> paths) {
        this.paths = paths;
    }
}

