/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.mouse.MouseSwipe;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionMouse;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;

public class ActionMouseSwipe
extends ActionMouse {
    public static final String SCRIPT_LABEL = "swipe";
    private MouseDirection direction;

    public ActionMouseSwipe() {
    }

    public ActionMouseSwipe(ScriptLoader script, String type, String direction, int stopPolicy, ArrayList<String> options, ArrayList<String> objectArray) {
        super(script, type, stopPolicy, options, objectArray);
        this.setDirection(new MouseDirection(script, new ArrayList<String>(Arrays.asList(direction.split(","))), false));
    }

    public ActionMouseSwipe(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, MouseSwipe mouse) {
        super(script, stopPolicy, maxTry, delay, element, mouse);
        this.setDirection(mouse.getDirection());
    }

    @Override
    public StringBuilder getJavaCode() {
        this.setSpareCode(this.direction.getDirectionJavaCode());
        return super.getJavaCode();
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            this.getTestElement().swipe(this.status, this.getPosition(), this.direction);
            this.status.endDuration();
            ts.getRecorder().updateScreen(0, this.status.getDuration());
        }
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public MouseDirection getDirection() {
        return this.direction;
    }

    public void setDirection(MouseDirection value) {
        this.direction = value;
    }
}

