/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionExecuteElement;
import com.ats.tools.Utils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ActionText
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL = "keyboard";
    public static final Pattern INSERT_PATTERN = Pattern.compile("insert\\((\\d+)\\)", 2);
    private CalculatedValue text;
    private int insert = -1;

    public ActionText() {
    }

    public ActionText(ScriptLoader script, int stopPolicy, ArrayList<String> options, String text, ArrayList<String> objectArray) {
        super((Script)script, stopPolicy, options, objectArray);
        this.setText(new CalculatedValue(script, text));
        Iterator<String> itr = options.iterator();
        while (itr.hasNext()) {
            Matcher matcher = INSERT_PATTERN.matcher(itr.next().toLowerCase());
            if (!matcher.find()) continue;
            this.setInsert(Utils.string2Int(matcher.group(1), -1));
            break;
        }
    }

    public ActionText(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedValue text) {
        super(script, stopPolicy, maxTry, delay, element);
        this.setText(text);
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append(", ").append(this.text.getJavaCode()).append(")");
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.text.getKeywords());
        return keywords;
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            ts.getRecorder().updateScreen(true);
            String enteredText = this.getTestElement().enterText(this.status, this.text, ts);
            this.status.endAction();
            ts.getRecorder().updateTextScreen(0, this.status.getDuration(), enteredText, this.status.getMessage());
        }
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("text", this.text.getCalculated().replaceAll("\"", "\\\""));
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public CalculatedValue getText() {
        return this.text;
    }

    public void setText(CalculatedValue text) {
        this.text = text;
    }

    public int getInsert() {
        return this.insert;
    }

    public void setInsert(int insert) {
        this.insert = insert;
    }
}

