/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions.neoload;

import com.ats.executor.channels.Channel;
import com.ats.script.Script;
import com.ats.script.actions.neoload.ActionNeoload;

public class ActionNeoloadRecord
extends ActionNeoload {
    public static final String SCRIPT_LABEL = "neoload-record";
    public static final String PAUSE = "pause";
    public static final String RESUME = "resume";
    public static final String SCREENSHOT = "screenshot";
    private String type = "pause";
    private static final String API_SERVICE_RESUME = "ResumeRecording";
    private static final String API_SERVICE_PAUSE = "PauseRecording";

    public ActionNeoloadRecord() {
    }

    public ActionNeoloadRecord(Script script, String type) {
        super(script);
        this.setType(type);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(this.getRecordType()).append(")");
        return codeBuilder;
    }

    private String getRecordType() {
        if (RESUME.equals(this.type) || SCREENSHOT.equals(this.type)) {
            return this.getClass().getSimpleName() + "." + this.type.toUpperCase();
        }
        return this.getClass().getSimpleName() + "." + PAUSE.toUpperCase();
    }

    @Override
    public void executeRequest(Channel channel, String designApiUrl) {
        super.executeRequest(channel, designApiUrl + this.getServiceName());
        this.postData("{\"d\": {}}");
    }

    private String getServiceName() {
        if (RESUME.equals(this.type)) {
            return API_SERVICE_RESUME;
        }
        return API_SERVICE_PAUSE;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = RESUME.equals(type) || SCREENSHOT.equals(type) ? type : PAUSE;
    }
}

