/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions.performance;

import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.script.Script;
import com.ats.script.actions.performance.ActionPerformance;

public class ActionPerformanceRecord
extends ActionPerformance {
    public static final String SCRIPT_LABEL = "perf-record";
    public static final String PAUSE = "pause";
    public static final String RESUME = "resume";
    private String type = "pause";

    public ActionPerformanceRecord() {
    }

    public ActionPerformanceRecord(Script script, String type) {
        super(script);
        this.setType(type);
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append("\"").append(this.type).append("\"").append(")");
    }

    @Override
    public boolean execute(ActionTestScript ts, String testName, int testLine) {
        Channel channel = ts.getCurrentChannel();
        this.setStatus(channel.newActionStatus(testName, testLine));
        if (PAUSE.equals(this.type)) {
            channel.pauseHarRecord();
        } else {
            channel.resumeHarRecord();
        }
        this.status.endDuration();
        return true;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = RESUME.equals(type) ? type : PAUSE;
    }
}

