/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.tools.report.SuitesReportItem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SuitesReport {
    public String projectId;
    public String projectDescription;
    public SuitesReportItem[] suites;

    public SuitesReport(String id, SuitesReportItem suite) {
        this.projectId = id;
        this.suites = new SuitesReportItem[]{suite};
        Path projectProperties = Paths.get(".atsProjectProperties", new String[0]);
        if (Files.exists(projectProperties, new LinkOption[0])) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(projectProperties.toFile());
                Element root = doc.getDocumentElement();
                NodeList desc = root.getElementsByTagName("description");
                if (desc != null && desc.getLength() > 0) {
                    this.projectDescription = desc.item(0).getTextContent();
                }
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
    }

    public void add(SuitesReportItem suite) {
        this.suites = (SuitesReportItem[])Stream.concat(Arrays.stream(this.suites), Arrays.stream(new SuitesReportItem[]{suite})).toArray(SuitesReportItem[]::new);
    }
}

