/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.flamingo.flex.amf.process;

import com.exadel.flamingo.flex.amf.AMF0Body;
import com.exadel.flamingo.flex.amf.AMF0Message;
import com.exadel.flamingo.flex.amf.AMF3Object;
import com.exadel.flamingo.flex.amf.process.IAMF3MessageProcessor;
import com.exadel.flamingo.flex.messaging.util.UUIDUtil;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.util.Iterator;
import java.util.List;

public class AMF0MessageProcessor {
    private IAMF3MessageProcessor amf3MessageProcessor;

    public AMF0MessageProcessor(IAMF3MessageProcessor amf3MessageProcessor) {
        this.amf3MessageProcessor = amf3MessageProcessor;
    }

    public AMF0Message process(AMF0Message amf0RequestMessage) {
        return this.process(amf0RequestMessage, false, null);
    }

    public AMF0Message process(AMF0Message amf0RequestMessage, boolean needSessionTimeoutException, Throwable sessionException) {
        AMF0Message amf0ResponseMessage = new AMF0Message();
        amf0ResponseMessage.setVersion(amf0RequestMessage.getVersion());
        ErrorMessage loginError = null;
        String dsId = null;
        Iterator<AMF0Body> bodies = amf0RequestMessage.getBodies();
        while (bodies.hasNext()) {
            AMF0Body requestBody = bodies.next();
            Message amf3RequestMessage = (Message)((List)requestBody.getValue()).get(0);
            Message amf3ResponseMessage = null;
            if (needSessionTimeoutException) {
                ErrorMessage sessionExceptionMessage = new ErrorMessage(sessionException);
                amf3ResponseMessage = sessionExceptionMessage.copy(amf3RequestMessage);
            } else if (loginError == null) {
                amf3ResponseMessage = this.amf3MessageProcessor.process(amf3RequestMessage);
                if (amf3ResponseMessage instanceof ErrorMessage && ((ErrorMessage)amf3ResponseMessage).loginError()) {
                    loginError = (ErrorMessage)amf3ResponseMessage;
                }
                if ("nil".equals(amf3ResponseMessage.getHeader("DSId"))) {
                    amf3ResponseMessage.getHeaders().put("DSId", dsId == null ? UUIDUtil.randomUUID() : dsId);
                }
            } else {
                amf3ResponseMessage = loginError.copy(amf3RequestMessage);
            }
            AMF3Object data = new AMF3Object(amf3ResponseMessage);
            AMF0Body responseBody = new AMF0Body(AMF0MessageProcessor.getResponseTarget(requestBody, amf3ResponseMessage), "", data, 17);
            amf0ResponseMessage.addBody(responseBody);
        }
        return amf0ResponseMessage;
    }

    private static String getResponseTarget(AMF0Body requestBody, Message responseMessage) {
        if (responseMessage instanceof ErrorMessage) {
            return requestBody.getResponse() + "/onStatus";
        }
        return requestBody.getResponse() + "/onResult";
    }
}

