/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.flamingo.flex.messaging.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ClassUtil {
    public static Object newInstance(String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ClassUtil.forName(type).newInstance();
    }

    public static <T> T newInstance(String type, Class<T> cast) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ClassUtil.forName(type, cast).newInstance();
    }

    public static Object newInstance(String type, Class<?>[] argsClass, Object[] argsValues) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ClassUtil.newInstance(ClassUtil.forName(type), argsClass, argsValues);
    }

    public static <T> T newInstance(Class<T> type, Class<?>[] argsClass, Object[] argsValues) throws InstantiationException, IllegalAccessException {
        T instance = null;
        try {
            Constructor<T> constructorDef = type.getConstructor(argsClass);
            instance = constructorDef.newInstance(argsValues);
        }
        catch (SecurityException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException(e.getMessage());
        }
        return instance;
    }

    public static Class<?> forName(String type) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(type);
    }

    public static <T> Class<T> forName(String type, Class<T> cast) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(type);
    }

    public static Constructor<?> getConstructor(String type, Class<?>[] paramTypes) throws ClassNotFoundException, NoSuchMethodException {
        return ClassUtil.getConstructor(ClassUtil.forName(type), paramTypes);
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?>[] paramTypes) throws NoSuchMethodException {
        return type.getConstructor(paramTypes);
    }

    public static <T> List<T> emptyList(Class<T> type) {
        return Collections.EMPTY_LIST;
    }

    public static <T> Set<T> emptySet(Class<T> type) {
        return Collections.EMPTY_SET;
    }

    public static <T, U> Map<T, U> emptyMap(Class<T> keyType, Class<U> valueType) {
        return Collections.EMPTY_MAP;
    }

    public static Class<?> classOfType(Type type) {
        Type[] ubs;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof WildcardType && (ubs = ((WildcardType)type).getUpperBounds()).length > 0) {
            return ClassUtil.classOfType(ubs[0]);
        }
        if (type instanceof GenericArrayType) {
            Class<?> ct = ClassUtil.classOfType(((GenericArrayType)type).getGenericComponentType());
            return ct != null ? Array.newInstance(ct, 0).getClass() : Object[].class;
        }
        if (type instanceof TypeVariable && (ubs = ((TypeVariable)type).getBounds()).length > 0) {
            return ClassUtil.classOfType(ubs[0]);
        }
        return Object.class;
    }
}

