/*
 * Decompiled with CFR 0.152.
 */
package com.naturalnessanalysis;

import com.naturalness.Event;
import com.naturalness.NaturalnessModel;
import com.naturalness.Sequence;
import com.naturalness.SequenceSuite;
import com.naturalnessanalysis.GlobalAnalysisResult;
import com.naturalnessanalysis.RankAnalysisResult;
import com.naturalnessanalysis.SequenceAnalysis;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Analyzer {
    private Map<Sequence<String>, String> testSequenceMap;
    private int depth;
    private double probaOfUnknown;
    final DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();

    public Analyzer(int depth, double probaOfUnknown) {
        this.testSequenceMap = new HashMap<Sequence<String>, String>();
    }

    public void recordSequenceFromLogFile(File logFile) throws ParserConfigurationException, SAXException, IOException {
        Document doc = this.dbFactory.newDocumentBuilder().parse(logFile);
        Sequence sequence = new Sequence(new Event[0]);
        String ACTION_TAG_NAME = "action";
        NodeList actionElementList = doc.getElementsByTagName("action");
        for (int i = 0; i < actionElementList.getLength(); ++i) {
            Node actionNode = actionElementList.item(i);
            if (actionNode.getNodeType() != 1) continue;
            Element actionElement = (Element)actionNode;
            String hash = this.hashActionElement(actionElement);
            sequence.append(new Event((Object)hash));
        }
        String name = logFile.getParentFile().getName().replaceAll("\\_xml$", "");
        this.testSequenceMap.put((Sequence<String>)sequence, name);
    }

    public String getSequenceName(Sequence<String> sequence) {
        return this.testSequenceMap.get(sequence);
    }

    public RankAnalysisResult rankAnalysis() {
        SequenceSuite sequenceList = new SequenceSuite(new ArrayList<Sequence<String>>(this.testSequenceMap.keySet()));
        return new RankAnalysisResult(sequenceList.rank(), this.testSequenceMap);
    }

    public SequenceAnalysis sequenceAnalysis() {
        HashMap<Sequence<String>, NaturalnessModel<String>> modelMap = new HashMap<Sequence<String>, NaturalnessModel<String>>();
        for (Sequence<String> sequence : this.testSequenceMap.keySet()) {
            NaturalnessModel model = new NaturalnessModel(this.depth, this.probaOfUnknown);
            model.learn(sequence);
            modelMap.put(sequence, (NaturalnessModel<String>)model);
        }
        return new SequenceAnalysis(modelMap, this.testSequenceMap);
    }

    public GlobalAnalysisResult globalAnalysis() {
        NaturalnessModel model = new NaturalnessModel(this.depth, this.probaOfUnknown);
        for (Sequence<String> sequence : this.testSequenceMap.keySet()) {
            model.learn(sequence);
        }
        return new GlobalAnalysisResult((NaturalnessModel<String>)model);
    }

    private String hashActionElement(Element actionElement) {
        String TYPE_ATTRIBUTE = "type";
        String type = actionElement.getAttribute("type");
        String VALUE_TAG_NAME = "value";
        String value = "";
        NodeList valueNodeList = actionElement.getElementsByTagName("value");
        if (valueNodeList.getLength() > 0) {
            Node firstValue = valueNodeList.item(0);
            value = firstValue.getTextContent();
        }
        String CHANNEL_TAG_NAME = "channel";
        String channel = "";
        NodeList channelNodeList = actionElement.getElementsByTagName("channel");
        if (channelNodeList.getLength() > 0) {
            Node firstChannel = channelNodeList.item(0);
            String CHANNEL_NAME_ATTRIBUTE = "name";
            channel = ((Element)firstChannel).getAttribute("name");
        }
        String ELEMENT_TAG_NAME = "element";
        String element = "";
        NodeList elementNodeList = actionElement.getElementsByTagName("element");
        if (elementNodeList.getLength() > 0) {
            Node firstElement = elementNodeList.item(0);
            String ELEMENT_TAG_ATTRIBUTE = "tag";
            element = ((Element)firstElement).getAttribute("tag");
        }
        String CRITERIAS_TAG_NAME = "criterias";
        String criterias = "";
        NodeList criteriasNodeList = actionElement.getElementsByTagName("criterias");
        if (criteriasNodeList.getLength() > 0) {
            Node firstCriterias = valueNodeList.item(0);
            criterias = firstCriterias.getTextContent();
        }
        return type + value + channel + element + criterias;
    }
}

