/*
 * Decompiled with CFR 0.152.
 */
package com.naturalnessanalysis;

import com.naturalness.Ranking;
import com.naturalness.Sequence;
import com.naturalnessanalysis.AnalysisResult;
import java.util.List;
import java.util.Map;

public class RankAnalysisResult
extends AnalysisResult {
    private List<Ranking> rankingList;
    private Map<Sequence<String>, String> testSequenceMap;

    public RankAnalysisResult(List<Ranking> rankingList, Map<Sequence<String>, String> testSequenceMap) {
        super("RankAnalysis");
        this.rankingList = rankingList;
        this.testSequenceMap = testSequenceMap;
    }

    @Override
    public String toCSV() {
        Object csv = "Analysis \n";
        csv = (String)csv + "Analysis Name , " + this.analysisName + "\n\n";
        csv = (String)csv + "Ranking\n";
        csv = (String)csv + "Test Name, Cross Entropy \n";
        for (Ranking rank : this.rankingList) {
            String name = this.testSequenceMap.get(rank.getSequence());
            double crossEntropy = rank.getCrossEntropy();
            csv = (String)csv + name + " , " + crossEntropy + "\n";
        }
        return csv;
    }
}

