/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element;

import com.ats.element.AtsBaseElement;
import com.ats.element.FoundElement;
import com.ats.generator.variables.CalculatedProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AtsMobileElement
extends AtsBaseElement {
    private static final String INNER_TEXT = "innerText";
    private static final String TEXT = "text";
    private static final String EMPTY_TAG = "Element";
    private static final String ROOT = "root";
    private boolean clickable = false;
    private AtsMobileElement parent;
    private AtsMobileElement[] children;
    private String positionInDom;
    private Rectangle rect;

    public Rectangle getRect() {
        if (this.rect == null) {
            this.rect = new Rectangle(this.getX().intValue(), this.getY().intValue(), this.getWidth().intValue(), this.getHeight().intValue());
        }
        return this.rect;
    }

    public AtsMobileElement() {
    }

    public AtsMobileElement(String id, String tag, Double width, Double height, Double x, Double y, Boolean clickable, Map<String, String> attributes) {
        this.setId(id);
        this.setTag(tag);
        this.setWidth(width);
        this.setHeight(height);
        this.setX(x);
        this.setY(y);
        this.setAttributes(attributes);
        this.clickable = clickable;
    }

    @Override
    public void setTag(String value) {
        if (value == null || value.isEmpty()) {
            super.setTag(EMPTY_TAG);
        } else {
            super.setTag(value);
        }
    }

    public void setPositionInDom(String value) {
        this.positionInDom = value;
    }

    public String getPositionInDom() {
        return this.positionInDom;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    private String getText() {
        String result = this.getAttribute(TEXT);
        if (result == null) {
            return "";
        }
        return result;
    }

    private String getInnerText() {
        Object result = this.getText();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                result = (String)result + " " + this.children[i].getInnerText();
            }
        }
        return ((String)result).trim();
    }

    public CalculatedProperty[] getMobileAttributes() {
        List<CalculatedProperty> properties = this.getProperties();
        properties.add(new CalculatedProperty(INNER_TEXT, this.getInnerText()));
        return properties.toArray(new CalculatedProperty[properties.size()]);
    }

    @Override
    public String getAttribute(String key) {
        if (INNER_TEXT.equals(key)) {
            return this.getInnerText();
        }
        return super.getAttribute(key);
    }

    public boolean isRoot() {
        return ROOT.equals(this.getTag());
    }

    public boolean checkTag(String value) {
        return "*".equals(value) || this.getTag().toLowerCase().equals(value.toLowerCase());
    }

    public FoundElement getFoundElement() {
        return new FoundElement(this);
    }

    public AtsMobileElement getParent() {
        return this.parent;
    }

    public void setParent(AtsMobileElement parent) {
        this.parent = parent;
    }

    public AtsMobileElement[] getChildren() {
        if (this.children == null) {
            return new AtsMobileElement[0];
        }
        return this.children;
    }

    public void setChildren(AtsMobileElement[] children) {
        this.children = children;
    }

    public void addChildren(AtsMobileElement element) {
        ArrayList<Object> tmpChild = new ArrayList<AtsMobileElement>();
        if (this.children != null) {
            tmpChild = new ArrayList<AtsMobileElement>(Arrays.asList(this.children));
        }
        tmpChild.add(element);
        this.children = tmpChild.toArray(new AtsMobileElement[tmpChild.size()]);
    }
}

