/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element;

import com.ats.element.FoundElement;
import com.ats.element.SearchedElement;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.engines.SapDriverEngine;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import java.util.ArrayList;
import java.util.Base64;

public class TestElementRoot
extends TestElement {
    private static final String SOURCE = "source";
    private static final String VERSION = "version";
    private static final String RECTANGLE = "rectangle";
    private static final String TITLE = "title";
    private static final String URL = "url";
    private static final String PROCESS_ID = "process-id";
    private static final String SCREEN_SHOT = "screenshot";
    private static final String WINDOWS = "windows";

    public TestElementRoot() {
    }

    public TestElementRoot(Channel channel) {
        super(channel, 1, 0);
        this.setCriterias("root");
    }

    @Override
    protected void startSearch(boolean sysComp, SearchedElement searchedElement) {
    }

    @Override
    public String enterText(ActionStatus status, CalculatedValue text, ActionTestScript script, int waitChar) {
        if (this.engine instanceof SapDriverEngine) {
            this.engine.sendTextData(status, this, text.getCalculatedText(script, false), waitChar);
            return "";
        }
        return this.channel.rootKeys(status, text);
    }

    @Override
    public Object executeScript(ActionStatus status, String script, boolean returnValue) {
        return this.engine.executeJavaScript(status, script, returnValue);
    }

    @Override
    public void mouseWheel(int delta) {
        this.engine.scroll(delta);
    }

    @Override
    public void over(ActionStatus status, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
        this.channel.setWindowToFront();
        this.channel.refreshLocation();
        super.over(status, position, desktopDragDrop, offsetX, offsetY);
    }

    @Override
    public String getAttribute(ActionStatus status, String name) {
        switch (name.toLowerCase()) {
            case "source": {
                return this.engine.getSource();
            }
            case "rectangle": {
                return this.channel.getBoundDimension();
            }
            case "clientWidth": {
                return this.channel.getDimension().getWidth().toString();
            }
            case "clientHeight": {
                return this.channel.getDimension().getHeight().toString();
            }
            case "screenshot": {
                return Base64.getEncoder().encodeToString(this.channel.getScreenShot());
            }
            case "version": {
                return this.channel.getApplicationVersion();
            }
            case "process-id": {
                return String.valueOf(this.channel.getProcessId());
            }
            case "title": {
                return this.engine.getTitle();
            }
            case "url": {
                return this.engine.getUrl();
            }
            case "windows": {
                return String.valueOf(this.engine.getNumWindows());
            }
        }
        this.reloadFoundElements();
        return this.engine.getAttribute(status, this.getFoundElement(), name, 5);
    }

    @Override
    public CalculatedProperty[] getAttributes(boolean reload) {
        ArrayList<CalculatedProperty> attributes = new ArrayList<CalculatedProperty>();
        attributes.add(new CalculatedProperty(SOURCE, "[...]"));
        attributes.add(new CalculatedProperty(VERSION, this.channel.getApplicationVersion()));
        attributes.add(new CalculatedProperty(RECTANGLE, this.channel.getBoundDimension()));
        attributes.add(new CalculatedProperty(PROCESS_ID, String.valueOf(this.channel.getProcessId())));
        attributes.add(new CalculatedProperty(TITLE, this.engine.getTitle()));
        attributes.add(new CalculatedProperty(URL, this.engine.getUrl()));
        attributes.add(new CalculatedProperty(WINDOWS, String.valueOf(this.engine.getNumWindows())));
        return attributes.toArray(new CalculatedProperty[attributes.size()]);
    }

    @Override
    public CalculatedProperty[] getCssAttributes() {
        this.reloadFoundElements();
        return super.getCssAttributes();
    }

    @Override
    public FoundElement getFoundElement() {
        return new FoundElement(this.channel);
    }
}

