/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers;

import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsManager;
import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.executor.channels.MobileChannel;
import com.ats.executor.drivers.DriverProcess;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.engines.ApiDriverEngine;
import com.ats.executor.drivers.engines.DesktopDriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.MobileDriverEngine;
import com.ats.executor.drivers.engines.SapDriverEngine;
import com.ats.executor.drivers.engines.browsers.ChromeDriverEngine;
import com.ats.executor.drivers.engines.browsers.ChromiumDriverEngine;
import com.ats.executor.drivers.engines.browsers.EdgeDriverEngine;
import com.ats.executor.drivers.engines.browsers.FirefoxDriverEngine;
import com.ats.executor.drivers.engines.browsers.IEDriverEngine;
import com.ats.executor.drivers.engines.browsers.JxDriverEngine;
import com.ats.executor.drivers.engines.browsers.MsEdgeDriverEngine;
import com.ats.executor.drivers.engines.browsers.OperaDriverEngine;
import com.ats.executor.drivers.engines.desktop.ExplorerDriverEngine;
import java.util.ArrayList;

public class DriverManager {
    public static final String CHROME_BROWSER = "chrome";
    public static final String CHROMIUM_BROWSER = "chromium";
    public static final String JX_BROWSER = "jx";
    public static final String FIREFOX_BROWSER = "firefox";
    public static final String IE_BROWSER = "ie";
    public static final String EDGE_BROWSER = "edge";
    public static final String MSEDGE_BROWSER = "msedge";
    public static final String OPERA_BROWSER = "opera";
    public static final String SAFARI_BROWSER = "safari";
    public static final String DESKTOP_DRIVER_FILE_NAME = "windowsdriver";
    public static final String CHROME_DRIVER_FILE_NAME = "chromedriver";
    public static final String CHROMIUM_DRIVER_FILE_NAME = "chromiumdriver";
    public static final String IE_DRIVER_FILE_NAME = "IEDriverServer";
    public static final String MSEDGE_DRIVER_FILE_NAME = "msedgedriver";
    public static final String OPERA_DRIVER_FILE_NAME = "operadriver";
    public static final String FIREFOX_DRIVER_FILE_NAME = "geckodriver";
    public static final String SAP_DRIVER_FILE_NAME = "sapdriver";
    private ArrayList<DriverProcess> driversProcess = new ArrayList();
    private ArrayList<MobileDriverEngine> mobileDrivers = new ArrayList();
    private DriverProcess desktopDriver;
    private DriverProcess sapDriver;

    public static void killAllDrivers() {
    }

    public DriverProcess getDesktopDriver(ActionStatus status) {
        if (this.desktopDriver == null) {
            this.desktopDriver = this.getDriverProcess(status, "desktop", null, DESKTOP_DRIVER_FILE_NAME, null, true);
        }
        return this.desktopDriver;
    }

    public void processTerminated(DriverProcess dp) {
        this.driversProcess.remove(dp);
    }

    public IDriverEngine getDriverEngine(Channel channel, ActionStatus status, DesktopDriver desktopDriver) {
        String application = channel.getApplication();
        ApplicationProperties props = AtsManager.getInstance().getApplicationProperties(application);
        String appName = props.getName().toLowerCase();
        String driverName = props.getDriver();
        DriverProcess driverProcess = null;
        if (CHROME_BROWSER.equals(appName)) {
            driverProcess = this.getDriverProcess(status, appName, driverName, CHROME_DRIVER_FILE_NAME, null, false);
            if (status.isPassed()) {
                return new ChromeDriverEngine(channel, status, driverProcess, desktopDriver, props);
            }
            return null;
        }
        if (MSEDGE_BROWSER.equals(appName)) {
            driverProcess = this.getDriverProcess(status, appName, driverName, MSEDGE_DRIVER_FILE_NAME, null, false);
            if (status.isPassed()) {
                return new MsEdgeDriverEngine(channel, status, driverProcess, desktopDriver, props);
            }
            return null;
        }
        if (EDGE_BROWSER.equals(appName)) {
            driverProcess = this.getDriverProcess(status, appName, driverName, props.getDriver(), null, false);
            if (status.isPassed()) {
                return new EdgeDriverEngine(channel, status, driverProcess, desktopDriver, props);
            }
            return null;
        }
        if (OPERA_BROWSER.equals(appName)) {
            driverProcess = this.getDriverProcess(status, appName, driverName, OPERA_DRIVER_FILE_NAME, null, false);
            if (status.isPassed()) {
                return new OperaDriverEngine(channel, status, driverProcess, desktopDriver, props);
            }
            return null;
        }
        if (FIREFOX_BROWSER.equals(appName)) {
            driverProcess = this.getDriverProcess(status, appName, driverName, FIREFOX_DRIVER_FILE_NAME, new String[]{"--marionette-port", "2828"}, false);
            if (status.isPassed()) {
                return new FirefoxDriverEngine(channel, status, driverProcess, desktopDriver, props);
            }
            return null;
        }
        if (IE_BROWSER.equals(appName)) {
            driverProcess = this.getDriverProcess(status, appName, driverName, IE_DRIVER_FILE_NAME, null, false);
            if (status.isPassed()) {
                return new IEDriverEngine(channel, status, driverProcess, desktopDriver, props);
            }
            return null;
        }
        if (CHROMIUM_BROWSER.equals(appName)) {
            if (driverName != null && props.getUri() != null) {
                driverProcess = this.getDriverProcess(status, appName, driverName, null, null, false);
                if (status.isPassed()) {
                    return new ChromiumDriverEngine(channel, status, props.getName(), driverProcess, desktopDriver, props);
                }
                return null;
            }
            status.setError(-19, "missing Chromium properties ('path' and 'driver') in .atsProperties file");
            return null;
        }
        if (JX_BROWSER.equals(appName) || "jxbrowser".equals(appName)) {
            if (driverName != null && props.getUri() != null) {
                JxDriverEngine jxEngine = new JxDriverEngine(this, AtsManager.getInstance().getDriversFolderPath(), driverName, channel, status, desktopDriver, props);
                if (status.isPassed()) {
                    return jxEngine;
                }
                jxEngine.close(false);
            } else {
                status.setError(-19, "missing JxBrowser properties ('path' and 'driver') in .atsProperties file");
            }
            return null;
        }
        if (channel instanceof MobileChannel) {
            String token = this.getChannelToken(application);
            MobileDriverEngine mobileDriverEngine = new MobileDriverEngine((MobileChannel)channel, status, application, desktopDriver, props, token);
            if (status.isPassed()) {
                this.mobileDrivers.add(mobileDriverEngine);
            }
            return mobileDriverEngine;
        }
        if (props.isApi() || application.startsWith("http://") || application.startsWith("https://")) {
            return new ApiDriverEngine(channel, status, application, desktopDriver, props);
        }
        if ("explorer".equals(appName)) {
            return new ExplorerDriverEngine(channel, status, desktopDriver, props);
        }
        if (application.toLowerCase().startsWith("sap://")) {
            if (this.sapDriver == null) {
                this.sapDriver = this.getDriverProcess(status, appName, driverName, SAP_DRIVER_FILE_NAME, new String[0], false);
            }
            if (status.isPassed()) {
                return new SapDriverEngine(channel, status, application.substring("sap".length() + 3), this.sapDriver, desktopDriver, props);
            }
            return null;
        }
        return new DesktopDriverEngine(channel, status, application, desktopDriver, props);
    }

    private String getChannelToken(String applicationPath) {
        int start = applicationPath.indexOf("://");
        if (start > -1) {
            applicationPath = applicationPath.substring(start + 3);
        }
        String[] appData = applicationPath.split("/");
        String endPoint = appData[0];
        for (MobileDriverEngine engine : this.mobileDrivers) {
            if (!engine.getEndPoint().equals(endPoint)) continue;
            this.mobileDrivers.remove(engine);
            return engine.getToken();
        }
        return null;
    }

    private String getDriverName(String driverName, String defaultName) {
        if (driverName == null) {
            driverName = defaultName;
        }
        return driverName + ".exe";
    }

    public DriverProcess getDriverProcess(ActionStatus status, String name, String driverName, String defaultDriverName, String[] args, boolean isDesktopDriver) {
        driverName = this.getDriverName(driverName, defaultDriverName);
        for (DriverProcess proc : this.driversProcess) {
            if (!proc.getName().equals(name)) continue;
            return proc;
        }
        DriverProcess proc = new DriverProcess(status, name, this, AtsManager.getInstance().getDriversFolderPath(), driverName, args, isDesktopDriver);
        if (status.isPassed()) {
            this.driversProcess.add(proc);
            return proc;
        }
        return null;
    }

    public void tearDown() {
        if (this.sapDriver != null) {
            this.sapDriver.terminate();
            this.sapDriver = null;
        }
        if (this.desktopDriver != null) {
            this.desktopDriver.close(false);
            this.desktopDriver = null;
        }
        while (this.mobileDrivers.size() > 0) {
            this.mobileDrivers.remove(0).tearDown();
        }
    }
}

