/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers;

import com.ats.executor.ActionStatus;
import com.ats.executor.StreamGobbler;
import com.ats.executor.drivers.DriverManager;
import com.ats.tools.Utils;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class DriverProcess {
    private static final int START_PORT = 9000;
    private static final int END_PORT = 20000;
    private static final String SHUTDOWN = "shutdown";
    private String name;
    private int port = 4444;
    private Process process;
    private DriverManager manager;
    private boolean keepRunning = false;
    private Pattern portPattern = Pattern.compile(".*on port (\\d+)");

    public DriverProcess(ActionStatus status, String name, DriverManager manager, Path driverFolderPath, String driverName, String[] args, boolean isDesktopDriver) {
        this.name = name;
        this.manager = manager;
        File driverFile = driverFolderPath.resolve(driverName).toFile();
        if (driverFile.exists()) {
            Object portData = "--port=";
            if (isDesktopDriver) {
                this.port = -1;
                portData = (String)portData + "auto";
            } else {
                this.port = DriverProcess.findFreePort(9000);
                if (this.port == -1) {
                    status.setError(-19, "unable to get free port in range [9000-20000]");
                    return;
                }
                portData = (String)portData + this.port;
            }
            String[] arguments = new String[]{driverFile.getAbsolutePath(), portData};
            if (args != null) {
                arguments = (String[])Stream.of(arguments, args).flatMap(Stream::of).toArray(String[]::new);
            }
            ProcessBuilder builder = new ProcessBuilder(arguments);
            builder.redirectErrorStream(true);
            builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            try {
                this.process = builder.start();
                StreamGobbler errorGobbler = new StreamGobbler(this.process.getErrorStream(), "ERROR", this);
                StreamGobbler outputGobbler = new StreamGobbler(this.process.getInputStream(), "OUTPUT", this);
                errorGobbler.start();
                outputGobbler.start();
            }
            catch (IOException e1) {
                status.setError(-19, e1.getMessage());
                return;
            }
        } else {
            status.setError(-19, "unable to launch driver process, driver file is missing : " + driverFile.getAbsolutePath());
            return;
        }
        int maxTry = 20;
        while (this.port < 0 && maxTry > 0) {
            --maxTry;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.port < 0) {
            status.setError(-19, "unable to get valid port for this driver (" + name + ")");
            return;
        }
        Runtime.getRuntime().addShutdownHook(new CloseProcess(this));
        status.setNoError();
    }

    public void output(String line) {
        Matcher m;
        if (this.port < 0 && (m = this.portPattern.matcher(line)).find()) {
            this.port = Utils.string2Int(m.group(1), -1);
        }
    }

    public void quit() {
        if (this.process != null && this.process.isAlive()) {
            if (!this.keepRunning) {
                this.process.descendants().forEach(p -> p.destroy());
                this.process.destroy();
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.process = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public URL getDriverServerUrl() {
        try {
            return new URL("http://localhost:" + this.port);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URL getDriverLoopback() {
        try {
            return new URL("http://127.0.0.1:" + this.port);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static Integer findFreePort(int port) {
        Integer n;
        if (port > 20000) {
            return -1;
        }
        ServerSocket socket = new ServerSocket(port, 1, InetAddress.getLoopbackAddress());
        try {
            n = port;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e1) {
                return DriverProcess.findFreePort(port + 1);
            }
        }
        socket.close();
        return n;
    }

    public void close(boolean keepRunning) {
        this.quit();
        this.manager.processTerminated(this);
    }

    public void terminate() {
        OkHttpClient client = new OkHttpClient.Builder().cache(null).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(40L, TimeUnit.SECONDS).build();
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(this.getDriverServerUrl() + "/shutdown");
        Request request = requestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF8").get().build();
        try {
            client.newCall(request).execute();
        }
        catch (JsonSyntaxException | IOException throwable) {
            // empty catch block
        }
    }

    static class CloseProcess
    extends Thread {
        private DriverProcess driver;

        public CloseProcess(DriverProcess driver) {
            this.driver = driver;
        }

        @Override
        public void run() {
            this.driver.quit();
        }
    }
}

