/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.data.Dimension;
import com.ats.data.Point;
import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsRemoteWebDriver;
import com.ats.element.FoundElement;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.generator.objects.BoundData;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.graphic.ImageTemplateMatchingSimple;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class DriverEngine {
    protected Channel channel;
    protected AtsRemoteWebDriver driver;
    protected DesktopDriver desktopDriver;
    protected String applicationPath;
    protected int currentWindow = 0;
    private int actionWait = -1;
    private int propertyWait = -1;

    public DriverEngine(Channel channel) {
        this.channel = channel;
    }

    public DriverEngine(Channel channel, DesktopDriver desktopDriver, ApplicationProperties props) {
        this(channel);
        this.desktopDriver = desktopDriver;
    }

    public DriverEngine(Channel channel, DesktopDriver desktopDriver, ApplicationProperties props, int defaultWait, int defaultCheck) {
        this(channel);
        this.desktopDriver = desktopDriver;
        this.actionWait = props.getWait();
        this.propertyWait = props.getCheck();
        this.applicationPath = props.getUri();
        if (this.actionWait == -1) {
            this.actionWait = defaultWait;
        }
        if (this.propertyWait == -1) {
            this.propertyWait = defaultCheck;
        }
    }

    public void started(ActionStatus status) {
    }

    public void updateScreenshot(TestBound dimension, boolean isRef) {
        this.getDesktopDriver().updateVisualImage(dimension, isRef);
    }

    public void createVisualAction(Channel channel, boolean stop, String actionType, int scriptLine, String scriptName, long timeline, boolean sync) {
        this.getDesktopDriver().createVisualAction(channel, stop, actionType, scriptLine, scriptName, timeline, sync);
    }

    public TestElement getTestElementRoot() {
        return new TestElement(this.channel);
    }

    public DesktopDriver getDesktopDriver() {
        return this.desktopDriver;
    }

    public int getCurrentWindow() {
        return this.currentWindow;
    }

    public void setDriver(AtsRemoteWebDriver driver) {
        this.driver = driver;
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public void actionWait() {
        this.channel.sleep(this.actionWait);
    }

    public int getActionWait() {
        return this.actionWait;
    }

    public int getPropertyWait() {
        return this.propertyWait;
    }

    protected int getCartesianOffset(int value, MouseDirectionData direction, Cartesian cart1, Cartesian cart2, Cartesian cart3) {
        if (direction != null) {
            if (cart1.equals(direction.getName())) {
                return direction.getIntValue() + 1;
            }
            if (cart3.equals(direction.getName())) {
                return value - direction.getIntValue() - 2;
            }
            return direction.getIntValue() + value / 2;
        }
        return value / 2;
    }

    public int getOffsetX(Rectangle rect, MouseDirection position) {
        return this.getCartesianOffset(rect.width, position.getHorizontalPos(), Cartesian.LEFT, Cartesian.CENTER, Cartesian.RIGHT);
    }

    public int getOffsetY(Rectangle rect, MouseDirection position) {
        return this.getCartesianOffset(rect.height, position.getVerticalPos(), Cartesian.TOP, Cartesian.MIDDLE, Cartesian.BOTTOM);
    }

    public String setWindowBound(BoundData x, BoundData y, BoundData w, BoundData h) {
        int newX = 0;
        int newY = 0;
        int newWidth = 0;
        int newHeight = 0;
        if (w != null || h != null) {
            newWidth = w != null ? w.getValue() : this.channel.getDimension().getWidth().intValue();
            newHeight = h != null ? h.getValue() : this.channel.getDimension().getHeight().intValue();
            this.setSize(new Dimension(newWidth, newHeight));
        }
        if (x != null || y != null) {
            newX = x != null ? x.getValue() : this.channel.getDimension().getX().intValue();
            newY = y != null ? y.getValue() : this.channel.getDimension().getY().intValue();
            this.setPosition(new Point(newX, newY));
        }
        return newX + "," + newY + "," + newWidth + "," + newHeight;
    }

    protected boolean desktopMoveToElement(FoundElement foundElement, MouseDirection position, int offsetX, int offsetY) {
        Rectangle rect = foundElement.getRectangle();
        this.getDesktopDriver().mouseMove(this.getOffsetX(rect, position) + foundElement.getScreenX().intValue() + offsetX, this.getOffsetY(rect, position) + foundElement.getScreenY().intValue() + offsetY);
        return true;
    }

    protected abstract void setPosition(Point var1);

    protected abstract void setSize(Dimension var1);

    public List<FoundElement> findElements(TestElement parent, ImageTemplateMatchingSimple template) {
        this.channel.setWindowToFront();
        this.channel.refreshLocation();
        TestBound outterBound = null;
        outterBound = parent != null ? parent.getFoundElement().getTestScreenBound() : this.channel.getDimension();
        return template.findOccurrences(this.getDesktopDriver().getScreenshotByte(outterBound.getX(), outterBound.getY(), outterBound.getWidth(), outterBound.getHeight())).parallelStream().map(r -> new FoundElement(this.channel, parent, (Rectangle)r)).collect(Collectors.toCollection(ArrayList::new));
    }

    public byte[] getScreenshot(Double x, Double y, Double width, Double height) {
        return this.getDesktopDriver().getScreenshotByte(x, y, width, height);
    }

    public CalculatedProperty[] getCssAttributes(FoundElement element) {
        return new CalculatedProperty[0];
    }
}

