/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.mobiles;

import com.ats.element.AtsMobileElement;
import com.ats.element.FoundElement;
import com.ats.element.MobileTestElement;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.drivers.engines.MobileDriverEngine;
import com.ats.executor.drivers.engines.mobiles.RootElement;
import com.ats.generator.objects.MouseDirection;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Rectangle;
import java.util.ArrayList;

public class AndroidRootElement
extends RootElement {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public AndroidRootElement(MobileDriverEngine driver) {
        super(driver);
    }

    @Override
    public void refresh(JsonNode node) {
        try {
            this.value = (AtsMobileElement)this.objectMapper.treeToValue((TreeNode)node, AtsMobileElement.class);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    @Override
    public void tap(ActionStatus status, FoundElement element, MouseDirection position) {
        Rectangle rect = element.getRectangle();
        int centerY = this.driver.getOffsetY(rect, position);
        int centerX = this.driver.getOffsetX(rect, position);
        if (element.getTag().equals("@IMAGE")) {
            centerY = (int)((double)centerY + element.getY());
            centerX = (int)((double)centerX + element.getX());
        }
        if (this.driver.deadZone != null) {
            if ((double)rect.y >= this.driver.deadZone.y) {
                status.setError(-3, "Element not interactable on this device");
                return;
            }
            if ((double)(rect.y + centerY) >= this.driver.deadZone.y) {
                centerY = (int)(this.driver.deadZone.y - (double)rect.y - 1.0);
            }
        }
        this.driver.executeRequest("element", element.getId(), "tap", "" + centerX, "" + centerY);
    }

    @Override
    public void tap(FoundElement element, int count) {
        this.driver.executeRequest("element", element.getId(), "tap", String.valueOf(count));
    }

    @Override
    public void press(FoundElement element, ArrayList<String> paths, int duration) {
        this.driver.executeRequest("element", element.getId(), "press", String.join((CharSequence)":", paths));
    }

    @Override
    public void swipe(MobileTestElement testElement, int hDirection, int vDirection) {
        this.driver.executeRequest("element", testElement.getId(), "swipe", "" + testElement.getOffsetX(), "" + testElement.getOffsetY(), "" + hDirection, "" + vDirection);
    }

    @Override
    public void textInput(TestElement element, ArrayList<SendKeyData> textActionList) {
        for (SendKeyData sequence : textActionList) {
            this.driver.executeRequest("element", element.getFoundElement().getId(), "input", sequence.getSequenceMobile());
        }
    }

    @Override
    public void clearInput(TestElement element) {
        this.driver.executeRequest("element", element.getFoundElement().getId(), "input", "&empty;");
    }

    @Override
    public Object scripting(String script, FoundElement element) {
        return this.driver.executeRequest("element", element.getId(), "scripting", script);
    }

    @Override
    public Object scripting(String script) {
        return this.scripting(script, this.getValue().getFoundElement());
    }

    @Override
    public MobileTestElement getCurrentElement(FoundElement element, MouseDirection position) {
        Rectangle rect = element.getRectangle();
        return new MobileTestElement(element.getId(), this.driver.getOffsetX(rect, position), this.driver.getOffsetY(rect, position));
    }
}

