/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator;

import com.ats.generator.Generator;
import com.ats.generator.GeneratorReport;
import com.ats.script.Project;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GeneratorAnt
extends Task {
    String destinationFolder;
    String sourceFolder;
    String reportFolder;

    public void setDestinationFolder(String dest) {
        this.destinationFolder = dest;
    }

    public void setSourceFolder(String src) {
        this.sourceFolder = src;
    }

    public void setReportFolder(String report) {
        this.reportFolder = report;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (this.destinationFolder == null || this.sourceFolder == null) throw new BuildException("'destinationFolder' and 'sourceFolder' cannot be null or empty !");
        File destination = new File(this.destinationFolder);
        File source = new File(this.sourceFolder);
        File report = null;
        if (this.reportFolder != null) {
            report = new File(this.reportFolder);
        }
        if (!source.exists()) throw new BuildException("Source folder [" + this.sourceFolder + "] does not exists !");
        this.log("Start Script Generator");
        this.log(" - Source folder -> " + this.sourceFolder);
        this.log(" - Destination folder -> " + destination);
        Project projectData = Project.getProjectData(source, destination, report);
        if (!projectData.isValidated()) {
            throw new BuildException("Source folder [" + this.sourceFolder + "] does not exists !");
        }
        Generator generator = new Generator(projectData);
        GeneratorReport generatorReport = generator.launch();
        this.log("Script Generator executed in " + generatorReport.getGenerationEllapsedTime() + " ms");
        this.log(" - Main scripts -> " + generatorReport.getGeneratedScriptsCount());
    }
}

