/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.parsers;

import com.ats.generator.parsers.Lexer;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.transform.Transformer;
import com.ats.script.ScriptHeader;
import com.ats.script.ScriptLoader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;

public class ScriptParser {
    public static final String ATS_SEPARATOR = "->";
    public static final int ATS_SEPARATOR_SIZE = "->".length();
    public static final String ATS_ASSIGN_SEPARATOR = "=>";
    public static final String ATS_PROPERTIES_FILE = ".atsProjectProperties";
    public static final String SCRIPT_ID = "id";
    public static final String SCRIPT_GROUPS_LABEL = "groups";
    public static final String SCRIPT_DESCRIPTION_LABEL = "description";
    public static final String SCRIPT_DATE_CREATED_LABEL = "created";
    public static final String SCRIPT_RETURN_LABEL = "return";
    public static final String SCRIPT_AUTHOR_LABEL = "author";
    public static final String SCRIPT_PREREQUISITE_LABEL = "prerequisite";
    public static final String SCRIPT_ID_JIRA = "jira";
    public static final int SCRIPT_ID_JIRA_LENGTH = "jira".length();
    public static final String SCRIPT_ID_SQUASH = "squash";
    public static final int SCRIPT_ID_SQUASH_LENGTH = "squash".length();
    public static final int SCRIPT_ID_LENGTH = "id".length();
    public static final int SCRIPT_GROUPS_LABEL_LENGTH = "groups".length();
    public static final int SCRIPT_DESCRIPTION_LABEL_LENGTH = "description".length();
    public static final int SCRIPT_DATE_CREATED_LABEL_LENGTH = "created".length();
    public static final int SCRIPT_RETURN_LABEL_LENGTH = "return".length();
    public static final int SCRIPT_AUTHOR_LABEL_LENGTH = "author".length();
    public static final int SCRIPT_PREREQUISITE_LABEL_LENGTH = "prerequisite".length();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss");
    private Lexer lexer;

    public ScriptParser(Lexer lexer) {
        this.lexer = lexer;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public boolean isGenerator() {
        return this.lexer.isGenerator();
    }

    public void addScript() {
        this.lexer.addScript();
    }

    private String getDataGroup(Matcher m, int index) {
        if (m.groupCount() > index - 1 && m.group(index) != null) {
            return m.group(index).trim();
        }
        return "";
    }

    private String getHeaderData(String data) {
        return data.substring(data.indexOf(ATS_SEPARATOR) + ATS_SEPARATOR_SIZE).trim();
    }

    public void parse(ScriptLoader script, ScriptHeader header, String data) {
        if (data.regionMatches(true, 0, SCRIPT_GROUPS_LABEL, 0, SCRIPT_GROUPS_LABEL_LENGTH)) {
            header.parseGroups(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, SCRIPT_DESCRIPTION_LABEL, 0, SCRIPT_DESCRIPTION_LABEL_LENGTH)) {
            header.setDescription(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, SCRIPT_ID, 0, SCRIPT_ID_LENGTH)) {
            header.setId(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, SCRIPT_ID_SQUASH, 0, SCRIPT_ID_SQUASH_LENGTH)) {
            header.setSquashId(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, SCRIPT_ID_JIRA, 0, SCRIPT_ID_JIRA_LENGTH)) {
            header.setJiraId(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, SCRIPT_DATE_CREATED_LABEL, 0, SCRIPT_DATE_CREATED_LABEL_LENGTH)) {
            String dateString = this.getHeaderData(data);
            try {
                header.setCreatedAt(dateFormat.parse(dateString));
            }
            catch (Exception exception) {}
        } else if (data.regionMatches(true, 0, SCRIPT_AUTHOR_LABEL, 0, SCRIPT_AUTHOR_LABEL_LENGTH)) {
            header.setAuthor(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, SCRIPT_PREREQUISITE_LABEL, 0, SCRIPT_PREREQUISITE_LABEL_LENGTH)) {
            header.setPrerequisite(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, "var", 0, Variable.SCRIPT_LABEL_LENGTH)) {
            ArrayList<String> dataArray = new ArrayList<String>(Arrays.asList(this.getHeaderData(data).split(ATS_SEPARATOR)));
            if (dataArray.size() > 0) {
                String name = dataArray.remove(0).trim();
                String value = "";
                Transformer transformer = null;
                if (dataArray.size() > 0) {
                    String nextData = dataArray.remove(0).trim();
                    Matcher m = Transformer.TRANSFORM_PATTERN.matcher(nextData);
                    if (m != null && m.find()) {
                        transformer = Transformer.createTransformer(this.getDataGroup(m, 1), this.getDataGroup(m, 2));
                        if (dataArray.size() > 0) {
                            value = dataArray.remove(0).trim();
                        }
                    } else {
                        value = nextData;
                    }
                }
                script.addVariable(name, new CalculatedValue(script, value), transformer);
            }
        } else if (data.regionMatches(true, 0, SCRIPT_RETURN_LABEL, 0, SCRIPT_RETURN_LABEL.length())) {
            String[] returnsData = this.getHeaderData(data).split(ATS_SEPARATOR);
            CalculatedValue[] returns = new CalculatedValue[returnsData.length];
            for (int i = 0; i < returnsData.length; ++i) {
                returns[i] = new CalculatedValue(script, returnsData[i].trim());
            }
            script.setReturns(returns);
        } else {
            boolean actionDisabled = false;
            if (data.startsWith("//")) {
                data = data.substring(2);
                actionDisabled = true;
            }
            this.lexer.createAction(script, data, actionDisabled);
        }
    }
}

