/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import com.ats.crypto.Password;
import com.ats.executor.ActionTestScript;
import com.ats.executor.SendKeyData;
import com.ats.generator.variables.BaseValue;
import com.ats.generator.variables.EnvironmentValue;
import com.ats.generator.variables.ParameterValue;
import com.ats.generator.variables.RandomStringValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.transform.DateTransformer;
import com.ats.generator.variables.transform.TimeTransformer;
import com.ats.script.Project;
import com.ats.script.Script;
import com.ats.tools.Utils;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public class CalculatedValue {
    private static final Pattern TODAY_PATTERN = Pattern.compile("\\$today", 2);
    private static final Pattern NOW_PATTERN = Pattern.compile("\\$now", 2);
    private static final Pattern UUID_PATTERN = Pattern.compile("\\$uuid", 2);
    private static final Pattern PGAV_PATTERN = Pattern.compile("\\$pgav", 2);
    private static final Pattern ITERATION_PATTERN = Pattern.compile("\\$iteration", 2);
    public static final Pattern KEY_REGEXP = Pattern.compile("\\$key\\s?\\((\\w+)\\-?([^\\)]*)?\\)");
    public static final Pattern ASSET_PATTERN = Pattern.compile("\\$asset\\s*?\\(([^\\)]*)\\)", 2);
    public static final Pattern IMAGE_PATTERN = Pattern.compile("\\$image\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern PASSWORD_DATA = Pattern.compile("\\$pass\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern SYS_PATTERN = Pattern.compile("\\$sys\\s*?\\(([^\\)]*)\\)", 2);
    public static final Pattern PARAMETER_PATTERN = Pattern.compile("\\$param\\s*?\\((\\w+),?(\\s*?[^\\)]*)?\\)", 2);
    public static final Pattern ENV_PATTERN = Pattern.compile("\\$env\\s*?\\(([\\w.]+),?(\\s*?[^\\)]*)?\\)", 2);
    private static final Pattern RND_PATTERN = Pattern.compile("\\$rnd(?:string)?\\s*?\\((\\d+),?(\\w{0,3}?[^\\)]*)?\\)", 2);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$var\\s*?\\(([^\\)\\.]*)\\)", 2);
    private static final Pattern GLOBAL_VARIABLE_PATTERN = Pattern.compile("\\$var\\s*?\\(([^\\)]*)\\)", 2);
    private static final Pattern unnecessaryStartQuotes = Pattern.compile("^\"\", ?");
    private static final Pattern unnecessaryMiddleQuotes = Pattern.compile(" \"\",");
    private static final Pattern unnecessaryEndQuotes = Pattern.compile(", \"\"$");
    private Script script;
    private String data = "";
    private String calculated;
    private String rawJavaCode = "";
    private Object[] dataList;
    private boolean crypted = false;

    public CalculatedValue() {
    }

    public CalculatedValue(String value) {
        this.setData(value);
    }

    public CalculatedValue(int value) {
        this(String.valueOf(value));
    }

    public CalculatedValue(ActionTestScript actionTestScript, Object[] data) {
        this.dataList = data;
    }

    public CalculatedValue(Script script) {
        this.setScript(script);
        this.setCalculated("");
    }

    public CalculatedValue(Script script, String dataValue) {
        this.setScript(script);
        if (dataValue.length() > 0) {
            dataValue = Utils.unescapeAts(dataValue);
            this.setData(dataValue);
            this.setCalculated(this.initCalculated(dataValue));
        }
    }

    private String initCalculated(String dataValue) {
        String variableName;
        String replace;
        BaseValue sp;
        this.rawJavaCode = StringEscapeUtils.escapeJava((String)dataValue);
        Matcher mv = PGAV_PATTERN.matcher(dataValue);
        while (mv.find()) {
            this.rawJavaCode = this.rawJavaCode.replace(mv.group(0), "\", gav(), \"");
        }
        mv = ITERATION_PATTERN.matcher(dataValue);
        while (mv.find()) {
            this.rawJavaCode = this.rawJavaCode.replace(mv.group(0), "\", itr(), \"");
        }
        mv = PARAMETER_PATTERN.matcher(dataValue);
        while (mv.find()) {
            sp = new ParameterValue(mv);
            dataValue = dataValue.replace(sp.getReplace(), this.script.getParameterValue(((ParameterValue)sp).getValue(), sp.getDefaultValue()));
            this.rawJavaCode = this.rawJavaCode.replace(sp.getReplace(), "\", prm" + sp.getCode() + ", \"");
        }
        mv = IMAGE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            this.rawJavaCode = this.rawJavaCode.replace(mv.group(0), Project.getAssetsImageJavaCode(mv.group(1)));
        }
        mv = ASSET_PATTERN.matcher(dataValue);
        while (mv.find()) {
            this.rawJavaCode = this.rawJavaCode.replace(mv.group(0), Project.getAssetsJavaCode(mv.group(1)));
        }
        mv = PASSWORD_DATA.matcher(dataValue);
        while (mv.find()) {
            this.crypted = true;
            this.rawJavaCode = this.rawJavaCode.replace(mv.group(0), "\", new " + Password.class.getCanonicalName() + "(this, \"" + mv.group(1) + "\"), \"");
        }
        mv = VARIABLE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            variableName = mv.group(1);
            dataValue = dataValue.replace(replace, this.script.getVariableValue(variableName));
            this.rawJavaCode = this.rawJavaCode.replace(replace, "\", " + variableName + ", \"");
        }
        mv = GLOBAL_VARIABLE_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            variableName = mv.group(1);
            dataValue = dataValue.replace(replace, this.script.getGlobalVariableValue(variableName));
            this.rawJavaCode = this.rawJavaCode.replace(replace, "\", gvar(\"" + variableName + "\"), \"");
        }
        mv = SYS_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            String value = StringEscapeUtils.escapeJava((String)mv.group(1).trim());
            dataValue = dataValue.replace(replace, this.script.getSystemValue(value));
            this.rawJavaCode = this.rawJavaCode.replace(replace, "\",sys(\"" + value + "\"), \"");
        }
        mv = ENV_PATTERN.matcher(dataValue);
        while (mv.find()) {
            sp = new EnvironmentValue(mv);
            dataValue = dataValue.replace(sp.getReplace(), this.script.getEnvironmentValue(((EnvironmentValue)sp).getValue(), sp.getDefaultValue()));
            this.rawJavaCode = this.rawJavaCode.replace(sp.getReplace(), "\", env" + sp.getCode() + ", \"");
        }
        mv = TODAY_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            dataValue = dataValue.replace(replace, DateTransformer.getTodayValue());
            this.rawJavaCode = this.rawJavaCode.replace(replace, "\", td(), \"");
        }
        mv = NOW_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            dataValue = dataValue.replace(replace, TimeTransformer.getNowValue());
            this.rawJavaCode = this.rawJavaCode.replace(replace, "\", nw(), \"");
        }
        mv = UUID_PATTERN.matcher(dataValue);
        while (mv.find()) {
            replace = mv.group(0);
            dataValue = dataValue.replace(replace, UUID.randomUUID().toString());
            this.rawJavaCode = this.rawJavaCode.replace(replace, "\", uid(), \"");
        }
        mv = RND_PATTERN.matcher(dataValue);
        while (mv.find()) {
            RandomStringValue rds = new RandomStringValue(mv);
            dataValue = dataValue.replace(rds.getReplace(), rds.exec());
            this.rawJavaCode = this.rawJavaCode.replace(rds.getReplace(), "\", rds" + rds.getCode() + ", \"");
        }
        return dataValue;
    }

    public boolean isCrypted() {
        return this.crypted;
    }

    public void setCrypted() {
        this.crypted = true;
    }

    public void dispose() {
        this.script = null;
        this.dataList = null;
    }

    public String getJavaCode() {
        Object value = "\"" + this.rawJavaCode + "\"";
        value = unnecessaryStartQuotes.matcher((CharSequence)value).replaceFirst("");
        value = unnecessaryEndQuotes.matcher((CharSequence)value).replaceFirst("");
        value = unnecessaryMiddleQuotes.matcher((CharSequence)value).replaceAll("");
        return "clv(" + (String)value + ")";
    }

    public void uncrypt(Script script) {
        Matcher mv = PASSWORD_DATA.matcher(this.calculated);
        while (mv.find()) {
            this.setCrypted();
            this.calculated = this.calculated.replace(mv.group(0), script.getPassword(mv.group(1)));
        }
    }

    public String uncrypt(ActionTestScript script, String value) {
        Matcher mv = PASSWORD_DATA.matcher(value);
        while (mv.find()) {
            this.setCrypted();
            value = value.replace(mv.group(0), script.getPassword(mv.group(1)));
        }
        return value;
    }

    private void addTextChain(boolean oneChar, ActionTestScript script, ArrayList<SendKeyData> list, String value) {
        String unCrypted = this.uncrypt(script, value);
        if (oneChar) {
            for (int i = 0; i < unCrypted.length(); ++i) {
                list.add(new SendKeyData(String.valueOf(unCrypted.charAt(i))));
            }
        } else {
            list.add(new SendKeyData(unCrypted));
        }
    }

    public ArrayList<SendKeyData> getCalculatedText(ActionTestScript script, boolean oneChar) {
        ArrayList<SendKeyData> chainKeys = new ArrayList<SendKeyData>();
        String calc = this.getCalculated();
        int start = 0;
        Matcher match = KEY_REGEXP.matcher(calc);
        while (match.find()) {
            int end = match.start();
            if (end > 0) {
                this.addTextChain(oneChar, script, chainKeys, calc.substring(start, end));
            }
            start = match.end();
            chainKeys.add(new SendKeyData(match.group(1), match.group(2).replace("-", "")));
        }
        if (start == 0) {
            this.addTextChain(oneChar, script, chainKeys, calc);
        } else if (start != calc.length()) {
            this.addTextChain(oneChar, script, chainKeys, calc.substring(start));
        }
        return chainKeys;
    }

    public String getDataListItem() {
        if (this.dataList != null && this.dataList.length > 0) {
            return this.dataList[0].toString();
        }
        return this.calculated;
    }

    public String getKeywords() {
        return this.data;
    }

    public String getCalculated() {
        if (this.calculated == null) {
            if (this.dataList != null) {
                StringBuilder builder = new StringBuilder("");
                for (Object obj : this.dataList) {
                    if (obj instanceof Variable) {
                        builder.append(((Variable)obj).getCalculatedValue());
                        continue;
                    }
                    builder.append(obj);
                }
                return builder.toString();
            }
            return this.data;
        }
        return this.calculated;
    }

    public void setCalculated(String value) {
        this.calculated = value;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String value) {
        if (value == null) {
            value = "";
        }
        this.data = value;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }
}

