/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script;

import com.ats.generator.GeneratorReport;
import com.ats.generator.parsers.Lexer;
import com.ats.script.Script;
import com.ats.script.ScriptInfo;
import com.ats.script.ScriptLoader;
import com.ats.tools.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Project {
    private static final DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    public static final String TARGET_FOLDER = "target";
    public static final String LOGS_FOLDER = "logs";
    private static final String TARGET_FOLDER_REPORT = "report";
    public static final String TARGET_FOLDER_GENERATED = "generated";
    public static final String TARGET_FOLDER_CLASSES = "classes";
    public static final String SRC_FOLDER = "src";
    public static final String ASSETS_FOLDER = "assets";
    public static final String CERTS_FOLDER = "certs";
    public static final String RESOURCES_FOLDER = "resources";
    public static final String IMAGES_FOLDER = "images";
    private static final String SRC_FOLDER_MAIN = "main";
    private static final String SRC_FOLDER_ATS = "ats";
    private static final String SRC_FOLDER_SUBSCRIPTS = "subscripts";
    private static final String SRC_FOLDER_JAVA = "java";
    private static final Pattern GROUP_PATTERN = Pattern.compile("groups.*->(.*)", 2);
    private String name = "";
    private String domain = "";
    private String description = "";
    private String version = "";
    private String folderPath = "";
    private boolean useProjectDomain = false;
    private File folder;
    private Path javaDestinationFolderPath;
    private Path reportDestinationFolderPath;

    public static Project getProjectData(File sourceFolder, File destinationFolder, File reportFolder) {
        File xmlDataFile = Project.checkAtsProjectFolder(sourceFolder);
        if (xmlDataFile != null) {
            return new Project(xmlDataFile, destinationFolder, reportFolder);
        }
        return new Project(sourceFolder);
    }

    public static String getAssetsJavaCode(String path) {
        StringBuilder pathBuilder = new StringBuilder("\", ");
        pathBuilder.append("emb").append("(\"").append(ASSETS_FOLDER).append("/").append(path).append("\"), \"");
        return pathBuilder.toString();
    }

    public static String getAssetsImageJavaCode(String path) {
        StringBuilder pathBuilder = new StringBuilder(RESOURCES_FOLDER);
        pathBuilder.append("/").append(IMAGES_FOLDER).append("/").append(path);
        return Project.getAssetsJavaCode(pathBuilder.toString());
    }

    private static File checkAtsProjectFolder(File f) {
        if (f != null) {
            File xmlPropertiesFile = f.toPath().resolve(".atsProjectProperties").toFile();
            if (xmlPropertiesFile.exists()) {
                return xmlPropertiesFile;
            }
            return Project.checkAtsProjectFolder(f.getParentFile());
        }
        return null;
    }

    public Project() {
    }

    public Project(File f) {
        if (f.exists()) {
            if (f.isDirectory()) {
                this.folder = f;
            } else if (f.isFile()) {
                this.folder = f.getParentFile();
            }
            this.folderPath = this.folder.getPath();
            this.setJavaDestinationFolderPath(this.getTargetFolderPath().resolve(TARGET_FOLDER_GENERATED));
            this.setReportDestinationFolderPath(this.getTargetFolderPath().resolve(TARGET_FOLDER_REPORT));
        }
    }

    public Project(File xmlPropertiesFile, File generatedJavaFolder, File reportFolder) {
        this.folder = xmlPropertiesFile.getParentFile();
        this.folderPath = xmlPropertiesFile.getParent();
        this.parseXmlFile(xmlPropertiesFile);
        if (generatedJavaFolder != null) {
            this.setJavaDestinationFolderPath(generatedJavaFolder.toPath());
        } else {
            this.setJavaDestinationFolderPath(this.getTargetFolderPath().resolve(TARGET_FOLDER_GENERATED));
        }
        if (reportFolder != null) {
            this.setReportDestinationFolderPath(reportFolder.toPath());
        } else {
            this.setReportDestinationFolderPath(this.getTargetFolderPath().resolve(TARGET_FOLDER_REPORT));
        }
    }

    public boolean isValidated() {
        return this.folder != null;
    }

    private void setJavaDestinationFolderPath(Path p) {
        this.javaDestinationFolderPath = p;
        this.javaDestinationFolderPath.toFile().mkdirs();
    }

    public String getDomainPath() {
        if (this.useProjectDomain) {
            return this.getDomainPackage().replace(".", "/");
        }
        return "";
    }

    public String getDomainPackage() {
        if (this.useProjectDomain) {
            return this.domain + "." + this.name;
        }
        return this.name;
    }

    private void setReportDestinationFolderPath(Path p) {
        this.reportDestinationFolderPath = p;
        this.reportDestinationFolderPath.toFile().mkdirs();
    }

    public void synchronize() {
        this.folder = new File(this.folderPath);
        Path targetFolderPath = this.getTargetFolderPath();
        this.setJavaDestinationFolderPath(targetFolderPath.resolve(TARGET_FOLDER_GENERATED));
        this.setReportDestinationFolderPath(targetFolderPath.resolve(TARGET_FOLDER_REPORT));
    }

    public void initFolders() {
        File javaFolder = this.javaDestinationFolderPath.toFile();
        try {
            Utils.deleteRecursiveJavaFiles(javaFolder);
            javaFolder.mkdirs();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void parseXmlFile(File xmlPropertiesFile) {
        try {
            DocumentBuilder dBuilder = docFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlPropertiesFile);
            Node xmlNode = doc.getElementsByTagName("domain").item(0);
            if (xmlNode != null) {
                this.setDomain(xmlNode.getTextContent());
            }
            if ((xmlNode = doc.getElementsByTagName("name").item(0)) != null) {
                this.setName(xmlNode.getTextContent());
            }
            if ((xmlNode = doc.getElementsByTagName("description").item(0)) != null) {
                this.setDescription(xmlNode.getTextContent());
            }
            if ((xmlNode = doc.getElementsByTagName("version").item(0)) != null) {
                this.setVersion(xmlNode.getTextContent());
            }
            if ((xmlNode = doc.getElementsByTagName("useProjectDomain").item(0)) != null) {
                this.setUseProjectDomain("true".equalsIgnoreCase(xmlNode.getTextContent()));
            }
        }
        catch (ParserConfigurationException e) {
            System.err.println(e.getMessage());
        }
        catch (SAXException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public Path getTargetFolderPath() {
        return this.folder.toPath().resolve(TARGET_FOLDER);
    }

    public Path getAssetsFolderPath() {
        return this.getSourceFolderPath().resolve(ASSETS_FOLDER);
    }

    private Path getSourceFolderPath() {
        return this.folder.toPath().resolve(SRC_FOLDER);
    }

    private Path getSourceMainFolderPath() {
        return this.getSourceFolderPath().resolve(SRC_FOLDER_MAIN);
    }

    public Path getAtsSourceFolder() {
        return this.getSourceMainFolderPath().resolve(SRC_FOLDER_ATS);
    }

    public Path getJavaSourceFolder() {
        return this.getSourceMainFolderPath().resolve(SRC_FOLDER_JAVA);
    }

    public Path getJavaDestinationFolder() {
        return this.javaDestinationFolderPath;
    }

    public Path getReportFolder() {
        return this.reportDestinationFolderPath;
    }

    public File getJavaFile(String qualifiedPath) {
        return this.getJavaDestinationFolder().resolve(qualifiedPath).toFile();
    }

    public String getGav() {
        return this.domain + "." + this.name + "(" + this.version + ")";
    }

    public ArrayList<File> getAtsScripts() {
        return this.getAtsScripts(this.getAtsSourceFolder().toFile());
    }

    public List<ScriptLoader> getAtsScripts(Lexer lexer) {
        ArrayList<ScriptLoader> scripts = new ArrayList<ScriptLoader>();
        this.getAtsScripts().parallelStream().forEach(f -> scripts.add(lexer.loadScript((File)f)));
        return scripts;
    }

    public List<ScriptInfo> getAtsScriptsByGroup(String groupName) {
        ArrayList<ScriptInfo> scripts = new ArrayList<ScriptInfo>();
        this.getAtsScripts().stream().forEach(f -> this.checkGroups((File)f, groupName, scripts));
        return scripts;
    }

    private void checkGroups(File f, String groupName, ArrayList<ScriptInfo> scripts) {
        block3: {
            try {
                String content = Files.readString(f.toPath(), StandardCharsets.UTF_8);
                Matcher m = GROUP_PATTERN.matcher(content);
                if (!m.find() || m.groupCount() <= 0) break block3;
                String[] groups = m.group(1).split(",");
                for (int i = 0; i < groups.length; ++i) {
                    if (!groups[i].contains(groupName)) continue;
                    scripts.add(new ScriptInfo(this, f));
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ArrayList<File> getAtsScripts(File startFolder) {
        FileFilter atsFilefilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".ats") || file.isDirectory();
            }
        };
        ArrayList<File> result = new ArrayList<File>();
        this.walk(result, startFolder, atsFilefilter);
        return result;
    }

    public List<ScriptInfo> loadScriptsHeader() {
        ArrayList<File> files = this.getAtsScriptsWithoutSubscripts();
        Lexer lexer = new Lexer(this, new GeneratorReport(), Script.DEFAULT_CHARSET);
        Stream stream = files.parallelStream();
        List<ScriptInfo> result = stream.map(s -> new ScriptInfo(lexer, (File)s)).collect(Collectors.toList());
        stream.close();
        return result;
    }

    public List<ScriptInfo> loadScriptsHeader(File atsFolder) {
        ArrayList<File> files = this.getAtsScripts(atsFolder);
        Lexer lexer = new Lexer(this, new GeneratorReport(), Script.DEFAULT_CHARSET);
        Stream stream = files.parallelStream();
        List<ScriptInfo> result = stream.map(s -> new ScriptInfo(lexer, (File)s)).collect(Collectors.toList());
        stream.close();
        return result;
    }

    private ArrayList<File> getAtsScriptsWithoutSubscripts() {
        final File subscriptsFolder = this.getAtsSourceFolder().resolve(SRC_FOLDER_SUBSCRIPTS).toFile();
        FileFilter atsFilefilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() ? subscriptsFolder.compareTo(file) != 0 : file.getName().toLowerCase().endsWith(".ats");
            }
        };
        ArrayList<File> result = new ArrayList<File>();
        this.sortedWalk(result, this.getAtsSourceFolder().toFile(), atsFilefilter);
        return result;
    }

    private void walk(ArrayList<File> list, File dir, FileFilter filter) {
        File[] files;
        for (File f : files = dir.listFiles(filter)) {
            if (f.isDirectory()) {
                this.walk(list, f, filter);
                continue;
            }
            list.add(f);
        }
    }

    private void sortedWalk(ArrayList<File> list, File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        Arrays.sort(files, new DirectoryBeforeFileComparator());
        for (File f : files) {
            if (f.isDirectory()) {
                this.walk(list, f, filter);
                continue;
            }
            list.add(f);
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String value) {
        this.domain = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String value) {
        this.folderPath = value;
    }

    public boolean isUseProjectDomain() {
        return this.useProjectDomain;
    }

    public void setUseProjectDomain(boolean useProjectDomain) {
        this.useProjectDomain = useProjectDomain;
    }

    public static final class DirectoryBeforeFileComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            if (o1.isDirectory() && !o2.isDirectory()) {
                return 1;
            }
            if (!o1.isDirectory() && o2.isDirectory()) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }
}

