/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecute;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class ActionGotoUrl
extends ActionExecute {
    public static final String SCRIPT_LABEL = "goto-url";
    public static final String SCRIPT_LABEL_SIMPLE = "goto";
    public static final String SCRIPT_LABEL_OPEN = "open-url";
    public static final String NEXT = "next";
    public static final String REFRESH = "refresh";
    public static final String BACK = "back";
    private CalculatedValue url;

    public ActionGotoUrl() {
    }

    public ActionGotoUrl(Script script, int stopPolicy, CalculatedValue url) {
        super(script, stopPolicy);
        this.setUrl(url);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(this.url.getJavaCode()).append(")");
        return codeBuilder;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.url.getKeywords());
        return keywords;
    }

    @Override
    public boolean execute(ActionTestScript ts, String testName, int testLine) {
        super.execute(ts, testName, testLine);
        if (this.status.isPassed()) {
            String urlString = this.url.getCalculated();
            if (ts.getCurrentChannel() != null) {
                ts.getCurrentChannel().navigate(this.status, urlString);
            }
            this.status.endAction();
            ts.getRecorder().updateScreen(this.status, urlString);
        }
        return true;
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("url", this.url.getCalculated());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public CalculatedValue getUrl() {
        return this.url;
    }

    public void setUrl(CalculatedValue url) {
        this.url = url;
    }
}

