/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions.neoload;

import com.ats.executor.channels.Channel;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.neoload.ActionNeoloadRun;
import java.util.StringJoiner;

public class ActionNeoloadStop
extends ActionNeoloadRun {
    public static final String SCRIPT_LABEL = "neoload-stop";
    private static final String FRAMEWORK_PARAM = "framework";
    private static final String GENERIC_PARAM = "generic";
    private static final String SHARED_CONTAINER = "sharedcont";
    private static final String INCLUDE_VARIABLE = "includevar";
    private static final String DELETE_RECORD = "deleterec";
    private static final String API_SERVICE_NAME = "StopRecording";
    private int threshold = 60;
    private boolean updateSharedContainer = false;
    private boolean includeVariable = false;
    private boolean deleteRecording = false;
    private boolean searchFrameworkParameter = false;
    private boolean searchGenericParameter = false;

    public ActionNeoloadStop() {
    }

    public ActionNeoloadStop(ScriptLoader script, String options, String userData, String userOptions) {
        super((Script)script, options, userData);
        this.checkOptions(options, userOptions);
    }

    public ActionNeoloadStop(Script script, String options, CalculatedValue user, String userOptions) {
        super(script, options, user);
        this.checkOptions(options, userOptions);
    }

    private void checkOptions(String options, String userOptions) {
        this.searchFrameworkParameter = options.contains(FRAMEWORK_PARAM);
        this.searchGenericParameter = options.contains(GENERIC_PARAM);
        for (String opt : userOptions.split(",")) {
            try {
                this.threshold = Integer.parseInt(opt);
            }
            catch (NumberFormatException e) {
                opt = opt.trim().toLowerCase();
                if (SHARED_CONTAINER.equals(opt)) {
                    this.updateSharedContainer = true;
                    continue;
                }
                if (INCLUDE_VARIABLE.equals(opt)) {
                    this.includeVariable = true;
                    continue;
                }
                if (!DELETE_RECORD.equals(opt)) continue;
                this.deleteRecording = true;
            }
        }
    }

    @Override
    public StringBuilder getJavaCode() {
        StringJoiner joiner = new StringJoiner(", ");
        if (this.searchFrameworkParameter) {
            joiner.add(FRAMEWORK_PARAM);
        }
        if (this.searchGenericParameter) {
            joiner.add(GENERIC_PARAM);
        }
        this.setOptions(joiner.toString());
        StringBuilder codeBuilder = super.getJavaCode();
        joiner = new StringJoiner(", ");
        if (this.threshold != 60) {
            joiner.add("" + this.threshold);
        }
        if (this.updateSharedContainer) {
            joiner.add(SHARED_CONTAINER);
        }
        if (this.deleteRecording) {
            joiner.add(DELETE_RECORD);
        }
        if (this.includeVariable) {
            joiner.add(INCLUDE_VARIABLE);
        }
        codeBuilder.append(", \"").append(joiner.toString()).append("\")");
        return codeBuilder;
    }

    @Override
    public void executeRequest(Channel channel, String designApiUrl) {
        super.executeRequest(channel, designApiUrl + API_SERVICE_NAME);
        this.postDesignData(new StopUser(this));
        channel.setStopNeoloadRecord(null);
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean isUpdateSharedContainer() {
        return this.updateSharedContainer;
    }

    public void setUpdateSharedContainer(boolean updateSharedContainer) {
        this.updateSharedContainer = updateSharedContainer;
    }

    public boolean isIncludeVariable() {
        return this.includeVariable;
    }

    public void setIncludeVariable(boolean includeVariable) {
        this.includeVariable = includeVariable;
    }

    public boolean isDeleteRecording() {
        return this.deleteRecording;
    }

    public void setDeleteRecording(boolean deleteRecording) {
        this.deleteRecording = deleteRecording;
    }

    public boolean isSearchFrameworkParameter() {
        return this.searchFrameworkParameter;
    }

    public void setSearchFrameworkParameter(boolean searchFrameworkParameter) {
        this.searchFrameworkParameter = searchFrameworkParameter;
    }

    public boolean isSearchGenericParameter() {
        return this.searchGenericParameter;
    }

    public void setSearchGenericParameter(boolean searchGenericParameter) {
        this.searchGenericParameter = searchGenericParameter;
    }

    private class StopUser {
        public boolean FrameworkParameterSearch = false;
        public boolean GenericParameterSearch = false;
        public String Name = null;
        public int MatchingThreshold = 60;
        public boolean UpdateSharedContainers = false;
        public boolean IncludeVariables = false;
        public boolean DeleteRecording = false;

        public StopUser(ActionNeoloadStop action) {
            this.FrameworkParameterSearch = action.isSearchFrameworkParameter();
            this.GenericParameterSearch = action.isSearchGenericParameter();
            if (action.getUser() != null) {
                this.Name = action.getUser().getCalculated();
                this.MatchingThreshold = action.getThreshold();
                this.UpdateSharedContainers = action.isUpdateSharedContainer();
                this.IncludeVariables = action.isIncludeVariable();
                this.DeleteRecording = action.isDeleteRecording();
            }
        }
    }
}

