/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.tools.report.CampaignReportGenerator;
import java.io.File;
import java.nio.file.Paths;
import java.util.Map;
import org.testng.TestRunner;

public class SuitesReportItem {
    public String name;
    public String description;
    public Map<String, String> parameters;
    public String[] tests;
    public String logLevel = "";
    private transient String ouputDir;
    private transient String projectId;

    public SuitesReportItem(String projectId, TestRunner runner) {
        this(runner);
        this.projectId = projectId;
        this.name = runner.getSuite().getName();
        this.tests = (String[])runner.getTest().getClasses().stream().map(c -> c.getName()).toArray(String[]::new);
        this.ouputDir = runner.getOutputDirectory();
    }

    public SuitesReportItem(TestRunner runner) {
        this.parameters = runner.getTest().getAllParameters();
        if (this.parameters != null) {
            this.setLogLevel(this.parameters.remove("ats.log.level"));
            this.setDescription(this.parameters.remove("ats.suite.description"));
        }
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getStartLog() {
        return "Start suite -> " + this.name + "(" + this.tests.length + " test(s))";
    }

    public File getSuitesFile() {
        return Paths.get(this.ouputDir, new String[0]).getParent().resolve(CampaignReportGenerator.ATS_JSON_SUITES).toFile();
    }

    private void setLogLevel(String value) {
        if (value != null) {
            this.logLevel = value;
        }
    }

    private void setDescription(String value) {
        if (value != null) {
            this.description = value;
        }
    }
}

