/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class ImportCert {
    public static void main(String[] args) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null);
        ImportCert.importCert(trustStore, "D:\\GitLab\\AgilitestEditorGui\\embed\\files\\certs\\gandi.pem");
        ImportCert.importCert(trustStore, "D:\\GitLab\\AgilitestEditorGui\\embed\\files\\certs\\caipture.com.pem");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(trustStore, "".toCharArray());
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(kmf.getKeyManagers(), null, null);
    }

    private static void importCert(KeyStore trustStore, String certPath) throws CertificateException, KeyStoreException, IOException {
        FileInputStream fis = new FileInputStream(certPath);
        BufferedInputStream bis = new BufferedInputStream(fis);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        while (bis.available() > 0) {
            Certificate cert = cf.generateCertificate(bis);
            trustStore.setCertificateEntry("fiddler" + bis.available(), cert);
        }
    }
}

