/*
 * Decompiled with CFR 0.152.
 */
package com.ats.data;

public class Rectangle {
    private double x;
    private double y;
    private double width;
    private double height;
    private double xMax;
    private double yMax;

    public Rectangle(double x, double y, double w, double h) {
        this.setX(x);
        this.setY(y);
        this.setWidth(w);
        this.setHeight(h);
    }

    private void recalculateX() {
        this.xMax = this.x + this.width;
    }

    private void recalculateY() {
        this.yMax = this.y + this.height;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
        this.recalculateX();
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
        this.recalculateY();
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
        this.recalculateX();
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
        this.recalculateY();
    }

    public boolean equals(Rectangle rect) {
        if (rect != null) {
            return rect.getX() == this.x && rect.getY() == this.y && rect.getWidth() == this.width && rect.getHeight() == this.height;
        }
        System.out.println("[WARN] : rectangle input element is null");
        return false;
    }

    public boolean contains(double _x, double _y) {
        return this.contains(_x, _y, 0.0, 0.0);
    }

    public boolean contains(Rectangle rec) {
        return this.contains(rec.getX(), rec.getY(), rec.getWidth(), rec.getHeight());
    }

    public boolean contains(double _x, double _y, double _w, double _h) {
        if (this.width < 0.0 || this.height < 0.0 || _w < 0.0 || _h < 0.0) {
            return false;
        }
        if (_x < this.x || _y < this.y) {
            return false;
        }
        if (_x + _w > this.xMax) {
            return false;
        }
        return !(_y + _h > this.yMax);
    }
}

