/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element;

import com.ats.element.JsonUtils;
import com.ats.generator.variables.CalculatedProperty;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AtsBaseElement {
    private String id;
    private String tag;
    private Double width = 0.0;
    private Double height = 0.0;
    private Double x = 0.0;
    private Double y = 0.0;
    private Map<String, String> attributes;

    public AtsBaseElement() {
    }

    public AtsBaseElement(JsonNode node) {
        this.jsonDeserialize(node);
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="tag")
    public String getTag() {
        return this.tag;
    }

    @JsonSetter(value="tag")
    public void setTag(String tag) {
        this.tag = tag;
    }

    @JsonGetter(value="x")
    public Double getX() {
        return this.x;
    }

    @JsonSetter(value="x")
    public void setX(Double x) {
        this.x = x;
    }

    @JsonGetter(value="y")
    public Double getY() {
        return this.y;
    }

    @JsonSetter(value="y")
    public void setY(Double y) {
        this.y = y;
    }

    @JsonGetter(value="width")
    public Double getWidth() {
        return this.width;
    }

    @JsonSetter(value="width")
    public void setWidth(Double width) {
        this.width = width;
    }

    @JsonGetter(value="height")
    public Double getHeight() {
        return this.height;
    }

    @JsonSetter(value="height")
    public void setHeight(Double height) {
        this.height = height;
    }

    public void setAttributes(Map<String, String> value) {
        this.attributes = value;
    }

    protected List<CalculatedProperty> getProperties() {
        return ((Stream)this.attributes.entrySet().stream().parallel()).map(e -> new CalculatedProperty((String)e.getKey(), (String)e.getValue())).collect(Collectors.toCollection(ArrayList::new));
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Map<String, String> getAttributesMap() {
        return this.attributes;
    }

    public void jsonDeserialize(JsonNode node) {
        AtsBaseElement defaultValue = new AtsBaseElement();
        if (node instanceof NullNode || node.get("error") != null) {
            return;
        }
        this.setId(JsonUtils.getJsonValue(node, "id", defaultValue.id, String.class));
        this.setTag(JsonUtils.getJsonValue(node, "tag", defaultValue.tag, String.class));
        this.setWidth(JsonUtils.getJsonValue(node, "width", defaultValue.width, Double.class));
        this.setHeight(JsonUtils.getJsonValue(node, "height", defaultValue.height, Double.class));
        this.setX(JsonUtils.getJsonValue(node, "x", defaultValue.x, Double.class));
        this.setY(JsonUtils.getJsonValue(node, "y", defaultValue.y, Double.class));
        JsonNode attributesNode = node.get("attributes");
        if (attributesNode != null) {
            this.attributes = new HashMap<String, String>();
            for (JsonNode attr : attributesNode) {
                String dataValue;
                String[] dataValueArray;
                JsonNode dataNode = attr.get("data");
                if (dataNode == null || (dataValueArray = (dataValue = dataNode.asText()).split("\n", 2)).length != 2) continue;
                this.attributes.put(dataValueArray[0], dataValueArray[1]);
            }
        }
    }
}

