/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor;

import com.ats.AtsSingleton;
import com.ats.crypto.Passwords;
import com.ats.element.SearchedElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ExecutionListener;
import com.ats.executor.ScriptStatus;
import com.ats.executor.StopExecutionThread;
import com.ats.executor.TestListener;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.objects.mouse.Mouse;
import com.ats.generator.objects.mouse.MouseKey;
import com.ats.generator.objects.mouse.MouseScroll;
import com.ats.generator.objects.mouse.MouseSwipe;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.ConditionalValue;
import com.ats.generator.variables.RandomStringValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.parameter.Parameter;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.generator.variables.transform.DateTransformer;
import com.ats.generator.variables.transform.NumericTransformer;
import com.ats.generator.variables.transform.RegexpTransformer;
import com.ats.generator.variables.transform.TimeTransformer;
import com.ats.generator.variables.transform.Transformer;
import com.ats.recorder.IVisualRecorder;
import com.ats.recorder.VisualRecorder;
import com.ats.recorder.VisualRecorderNull;
import com.ats.script.Project;
import com.ats.script.Script;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionCallscript;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.ActionComment;
import com.ats.script.actions.ActionExecute;
import com.ats.tools.Utils;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.logger.levels.AtsFailError;
import com.ats.tools.report.AtsReporterListener;
import com.ats.tools.report.CampaignReportGenerator;
import com.ats.tools.report.SuitesReportItem;
import com.ats.tools.report.htmlPlayerReport;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.TestListenerAdapter;
import org.testng.TestRunner;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Listeners;

@Listeners(value={ExecutionListener.class, TestListener.class, AtsReporterListener.class})
public class ActionTestScript
extends Script {
    public static final String MAIN_TEST_FUNCTION = "testMain";
    public static final String TEST_STOPPABLE = "com.ats.test.stoppable";
    public static final String SUITE_PARAMETERS = "parameters.txt";
    private static final String COLUMN_TEST_ID = "$ats_test_id";
    private static final String COLUMN_TEST_DESCRIPTION = "$ats_test_description";
    private static final String COLUMN_TEST_PREREQUISITE = "$ats_test_prerequisite";
    private static final String COLUMN_TEST_EXTERNAL = "$ats_test_external_id";
    private int verbosity = 0;
    private Map<String, String> testParameters;
    private Path suiteOutputPath;
    private ActionTestScript topScript;
    private String dateOrder = "";
    private String[] returnValues;
    private Project projectData;
    private static final List<String> trueList = Arrays.asList("on", "true", "1", "yes", "y");
    private static final List<String> falseList = Arrays.asList("off", "false", "0", "no", "n");
    private ScriptStatus status = new ScriptStatus();
    private TestListenerAdapter testListener;
    private List<String> channels = new ArrayList<String>();
    public static final String JAVA_VAR_FUNCTION_NAME = "var";
    public static final String JAVA_GLOBAL_VAR_FUNCTION_NAME = "gvar";
    public static final String JAVA_VALUE_FUNCTION_NAME = "clv";
    public static final String JAVA_PARAM_FUNCTION_NAME = "prm";
    public static final String JAVA_RETURNS_FUNCTION_NAME = "rtn";
    public static final String JAVA_RNDSTRING_FUNCTION_NAME = "rds";
    public static final String JAVA_ENV_FUNCTION_NAME = "env";
    public static final String JAVA_SYSTEM_FUNCTION_NAME = "sys";
    public static final String JAVA_PROPERTY_FUNCTION_NAME = "prp";
    public static final String JAVA_UUID_FUNCTION_NAME = "uid";
    public static final String JAVA_TODAY_FUNCTION_NAME = "td";
    public static final String JAVA_NOW_FUNCTION_NAME = "nw";
    public static final String JAVA_ITERATION_FUNCTION_NAME = "itr";
    public static final String JAVA_ITERATION_COUNT_FUNCTION_NAME = "itc";
    public static final String JAVA_ELEMENT_FUNCTION_NAME = "el";
    public static final String JAVA_REGEX_FUNCTION_NAME = "rx";
    public static final String JAVA_DATE_FUNCTION_NAME = "dt";
    public static final String JAVA_TIME_FUNCTION_NAME = "tm";
    public static final String JAVA_NUMERIC_FUNCTION_NAME = "nm";
    public static final String JAVA_POS_FUNCTION_NAME = "ps";
    public static final String JAVA_MOUSE_FUNCTION_NAME = "ms";
    public static final String JAVA_EMBEDED_FUNCTION_NAME = "emb";
    public static final String JAVA_ATS_FUNCTION_NAME = "ats";
    public static final String JAVA_CONDITION_FUNCTION = "condition";
    private ConditionalValue condition;
    public static final String JAVA_EXECUTE_FUNCTION_NAME = "exec";
    private boolean dragWithDesktop = false;
    private IVisualRecorder recorder = new VisualRecorderNull();

    protected ScriptHeader getScriptHeader() {
        return this.scriptHeader;
    }

    public ActionTestScript() {
        super(null);
        this.init(new Passwords(this.getAssetsFile("")));
    }

    public ActionTestScript(File assetsFolder) {
        super(null);
        this.init(new Passwords(assetsFolder.toPath()));
        this.initShadowScript();
    }

    public ActionTestScript(ExecutionLogger logger) {
        super(logger);
        this.init(null);
    }

    public ActionTestScript(ActionTestScript topScript) {
        this.setTopScript(topScript);
    }

    public void setTopScript(ActionTestScript topScript, String scriptName) {
        this.setTopScript(topScript);
        this.setTestName(scriptName);
        this.setTopLogger(topScript.getLogger());
        this.setOutputPath(topScript.getSuiteOutputPath());
        this.initShadowScript(topScript.getShadowScript());
        AtsSingleton.getInstance().addCalledScript(this, this.getCanonicalName());
    }

    public void setTopScript(ActionTestScript topScript) {
        this.init(topScript, topScript.getPasswords());
    }

    private void init(Passwords passwords) {
        this.init(this, passwords);
    }

    private void init(ActionTestScript topScript, Passwords passwords) {
        this.topScript = topScript;
        this.scriptHeader = topScript.getScriptHeader();
        this.passwords = passwords;
        Logger.getLogger("org.openqa.selenium").setLevel(Level.OFF);
        Logger.getLogger(Actions.class.getName()).setLevel(Level.OFF);
        Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);
    }

    public String[] getReturnValues() {
        return this.returnValues;
    }

    public Passwords getPasswords() {
        return this.passwords;
    }

    public void updateTestName(String name) {
        this.setTestName(name);
    }

    public void scriptFail(String message) {
        Assert.fail((String)message);
    }

    public ScriptStatus getStatus() {
        return this.status;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public Map<String, String> getTestParameters() {
        return this.testParameters;
    }

    public Path getSuiteOutputPath() {
        return this.suiteOutputPath;
    }

    public void setOutputPath(Path value) {
        this.suiteOutputPath = value;
    }

    public ScriptHeader getHeader() {
        return this.getScriptHeader();
    }

    @BeforeSuite(alwaysRun=true)
    public void beforeSuite() {
        ITestResult itr = Reporter.getCurrentTestResult();
        SuitesReportItem currentsuite = new SuitesReportItem(this.scriptHeader.getProjectUuid(), this.scriptHeader.getProjectId(), (TestRunner)itr.getTestContext());
        this.setTopLogger(new ExecutionLogger(System.out, AtsSingleton.getInstance().getLogLevel(), this.scriptHeader.getLogsType()));
        this.getLogger().sendScriptSuite(currentsuite.getStartLog());
        ExecutionListener.startSuite(currentsuite);
    }

    @AfterSuite(alwaysRun=true)
    public void afterSuite() {
        ITestResult itr = Reporter.getCurrentTestResult();
        ITestContext ctx = itr.getTestContext();
        if (this.testListener != null) {
            this.getLogger().sendScriptInfo("Callscript as a suite teminated -> " + ctx.getSuite().getName());
            TestRunner runner = (TestRunner)ctx;
            for (ITestResult tr : this.testListener.getFailedTests()) {
                runner.addFailedTest(tr.getMethod(), tr);
            }
            for (ITestResult tr : this.testListener.getPassedTests()) {
                runner.addPassedTest(tr.getMethod(), tr);
            }
            for (ITestResult tr : this.testListener.getSkippedTests()) {
                runner.addSkippedTest(tr.getMethod(), tr);
            }
        } else {
            this.getLogger().sendScriptSuite("Suite terminated -> " + ctx.getSuite().getName());
        }
    }

    public void setTestList(List<ITestListener> value) {
        if (value.size() > 0) {
            this.testListener = (TestListenerAdapter)value.get(0);
        }
    }

    @BeforeClass(alwaysRun=true)
    public void beforeClass(ITestContext ctx) {
        int reportNum;
        TestRunner runner = (TestRunner)ctx;
        String suiteName = ctx.getSuite().getName();
        this.verbosity = ctx.getSuite().getXmlSuite().getVerbose();
        SuitesReportItem currentSuite = new SuitesReportItem((TestRunner)ctx);
        this.setTopLogger(new ExecutionLogger(System.out, AtsSingleton.getInstance().getLogLevel(), this.scriptHeader.getLogsType()));
        this.setDateOrder(currentSuite.getDateOrder());
        if (currentSuite.isSubScriptIteration()) {
            this.setTestName(this.getClass().getName() + "-" + ctx.getName());
            this.testParameters = runner.getTest().getLocalParameters();
        } else {
            this.testParameters = ctx.getSuite().getXmlSuite().getParameters();
            this.setTestName(this.getClass().getName());
        }
        this.suiteOutputPath = Paths.get(runner.getOutputDirectory(), new String[0]);
        AtsSingleton.getInstance().addCalledScript(this, this.getCanonicalName());
        if (AtsSingleton.getInstance().getAtsError() != null) {
            this.getLogger().sendInfo("ActionTestScript properties file found, but an error occured !", AtsSingleton.getInstance().getAtsError());
        }
        this.status = new ScriptStatus(this.getTestName(), suiteName);
        if ("true".equalsIgnoreCase(runner.getTest().getParameter("check.mode"))) {
            throw new SkipException("check mode : " + this.getTestName());
        }
        Map params = runner.getTest().getAllParameters();
        this.setTestExecutionVariables(params);
        boolean htmlPlayer = falseList.indexOf(this.getEnvironmentValue(htmlPlayerReport.htmlPlayerParam, "").toLowerCase()) <= -1;
        String atsReportEnv = this.getEnvironmentValue("ATS_REPORT", "").toLowerCase(Locale.ROOT);
        String cmdATSReport = this.getEnvironmentValue("ats-report", "").toLowerCase(Locale.ROOT);
        int devReport = 0;
        if (!atsReportEnv.isEmpty()) {
            try {
                reportNum = Integer.parseInt(atsReportEnv);
                if (reportNum > 0 && reportNum < 4) {
                    devReport = Utils.string2Int(atsReportEnv, 0);
                }
            }
            catch (NumberFormatException e) {
                this.getLogger().sendError("parameter can not be interpreted as number", "-1");
            }
        }
        if (!cmdATSReport.isEmpty()) {
            try {
                reportNum = Integer.parseInt(cmdATSReport);
                if (reportNum > 0 && reportNum < 4) {
                    devReport = Utils.string2Int(cmdATSReport, 0);
                }
            }
            catch (NumberFormatException e) {
                this.getLogger().sendError("parameter can not be interpreted as number", "-1");
            }
        }
        System.setProperty("ats-report", Integer.toString(devReport));
        int mgtReport = trueList.indexOf(this.getEnvironmentValue("mgt-report", "").toLowerCase(Locale.ROOT)) > -1 ? 1 : 0;
        System.setProperty("mgt-report", Integer.toString(mgtReport));
        int validReport = trueList.indexOf(this.getEnvironmentValue("validation-report", "").toLowerCase(Locale.ROOT)) > -1 ? 1 : 0;
        System.setProperty("validation-report", Integer.toString(validReport));
        boolean xml = trueList.indexOf(this.getEnvironmentValue("xml.report", "").toLowerCase(Locale.ROOT)) > -1;
        int visualQuality = currentSuite.getVisualQuality();
        if (devReport + mgtReport + validReport != 0 || currentSuite.isReporting()) {
            if (visualQuality == 0) {
                visualQuality = 3;
            }
            xml = true;
        }
        JsonObject logs = new JsonObject();
        logs.addProperty("suite", suiteName);
        logs.addProperty("xmlReport", Boolean.valueOf(xml));
        logs.addProperty("visualQuality", (Number)visualQuality);
        ScriptHeader header = null;
        if (currentSuite.isSubScriptIteration()) {
            params.remove("ats-callscript-iteration");
            params.remove("ats-callscript-parameters");
            String iteration = (String)params.remove("ats-iteration");
            ParameterList parameterList = new ParameterList(Utils.string2Int(iteration));
            header = this.getScriptHeader();
            int i = 0;
            boolean numParamExist = true;
            while (numParamExist) {
                if (params.containsKey("#" + i)) {
                    parameterList.addParameter(new Parameter(i, new CalculatedValue((String)params.get("#" + i))));
                    params.remove("#" + i);
                    ++i;
                    continue;
                }
                numParamExist = false;
            }
            for (Map.Entry param : params.entrySet()) {
                parameterList.addParameter(new Parameter(i, (String)param.getKey(), (String)param.getValue()));
                if (COLUMN_TEST_ID.equals(param.getKey())) {
                    header.setId((String)param.getValue());
                } else if (COLUMN_TEST_DESCRIPTION.equals(param.getKey())) {
                    header.setDescription((String)param.getValue());
                } else if (COLUMN_TEST_EXTERNAL.equals(param.getKey())) {
                    header.setExternalId((String)param.getValue());
                } else if (COLUMN_TEST_PREREQUISITE.equals(param.getKey())) {
                    header.setPrerequisite((String)param.getValue());
                }
                ++i;
            }
            this.setParameterList(parameterList);
            StringBuilder sb = new StringBuilder("Starting script");
            sb.append(" iteration (").append(this.getTestName()).append(") -> iteration ").append(iteration);
            this.getLogger().sendScriptInfo(sb.toString());
        } else {
            Properties parametersProperties = new Properties();
            JsonArray parametersArray = new JsonArray();
            for (Map.Entry param : params.entrySet()) {
                String k = (String)param.getKey();
                String v = this.getEnvironmentValue(k, (String)param.getValue());
                parametersProperties.put(k, v);
                JsonObject elem = new JsonObject();
                elem.addProperty(k, v);
                parametersArray.add((JsonElement)elem);
            }
            logs.add("parameters", (JsonElement)parametersArray);
            try {
                parametersProperties.store(new FileOutputStream(Paths.get(runner.getOutputDirectory(), SUITE_PARAMETERS).toFile()), null);
            }
            catch (IOException i) {
                // empty catch block
            }
            StringBuilder sb = new StringBuilder("Starting script");
            sb.append(" (").append(this.getTestName()).append(") -> ").append(logs.toString());
            this.getLogger().sendScriptInfo(sb.toString());
        }
        if (visualQuality > 0 || xml) {
            if (header == null) {
                header = this.getScriptHeader();
            }
            header.setName(this.getTestName());
            File output = new File(runner.getOutputDirectory());
            if (!output.exists()) {
                output.mkdirs();
            }
            this.setRecorder(new VisualRecorder(this, output, header, xml, visualQuality, htmlPlayer, this.logger, devReport == CampaignReportGenerator.DETAILS_AND_SCREEN));
        }
        this.initShadowScript(header, suiteName);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ActionTestScript.this.tearDown();
            }
        });
        if ("true".equals(System.getProperty(TEST_STOPPABLE))) {
            this.getLogger().sendScriptInfo("This script can be stopped if 'q' is sent to 'System.in' stream");
            new StopExecutionThread(this, System.in).start();
        }
    }

    @AfterClass(alwaysRun=true)
    public void afterClass(ITestContext ctx) {
        TestRunner runner = (TestRunner)ctx;
        this.status.endLogs(this, runner);
    }

    @AfterMethod(alwaysRun=true)
    public void cleanup() {
        AtsSingleton.getInstance().closeChannels(new ActionStatus(), this.getChannels());
        if (this.status.getCallscriptStack() != null) {
            this.getLogger().sendScriptError("Callscripts error", this.status.getCallscriptStack());
        }
        this.stopRecorder();
        this.tearDown();
    }

    public void startChannel(String name) {
        this.topScript.channels.add(name);
    }

    public List<String> getChannels() {
        return this.topScript.channels;
    }

    public ActionTestScript getTopScript() {
        return this.topScript;
    }

    public String getCanonicalName() {
        return this.getClass().getCanonicalName();
    }

    public void initCalledScript(ActionTestScript atsCaller, String testName, int line, ParameterList parameters, List<Variable> variables, int iteration, int iterationsCount, String scriptName, String type, String filePath) {
        this.iteration = iteration;
        this.iterationsCount = iterationsCount;
        this.csvAbsoluteFilePath = filePath;
        this.setTestName(this.getClass().getName());
        JsonObject log = atsCaller.getConditionLogs();
        log.addProperty("called", scriptName);
        log.addProperty("iteration", iteration + "/" + iterationsCount);
        log.addProperty("type", type);
        if (filePath != null) {
            log.addProperty("url", filePath);
        }
        if (parameters != null) {
            this.setParameterList(parameters);
            if (parameters.getList().size() > 0) {
                JsonArray parametersArray = new JsonArray();
                for (Parameter p : parameters.getList()) {
                    JsonObject jso = new JsonObject();
                    jso.addProperty(p.getName(), p.getCalculated());
                    parametersArray.add((JsonElement)jso);
                }
                log.add("parameters", (JsonElement)parametersArray);
            }
        }
        if (variables != null) {
            this.setVariables(variables);
        }
        this.setTestExecutionVariables(this.topScript.getTestExecutionVariables());
        this.topScript.getLogger().sendScriptInfo(ActionCallscript.getScriptLog(testName, line, log));
    }

    public void setDateOrder(String value) {
        this.topScript.dateOrder = value;
    }

    public String getDateOrder() {
        return this.topScript.dateOrder;
    }

    public void setProjectData(Project value) {
        this.projectData = value;
        this.projectData.synchronize();
        this.passwords = new Passwords(this.projectData.getAssetsFolderPath().toFile());
    }

    public void tearDown() {
        this.getLogger().sendInfo("Drivers", "closing ...");
        AtsSingleton.getInstance().closeChannels(new ActionStatus(), this.getChannels());
        AtsSingleton.getInstance().tearDown();
    }

    public Variable var(String name, CalculatedValue value) {
        return this.createVariable(name, value, null);
    }

    public Variable var(String name) {
        return this.createVariable(name, new CalculatedValue(""), null);
    }

    public Variable var(String name, Transformer transformer) {
        return this.createVariable(name, new CalculatedValue(""), transformer);
    }

    public Variable var(String name, CalculatedValue value, Transformer transformer) {
        return this.createVariable(name, value, transformer);
    }

    public String gvar(String varPath) {
        return this.topScript.getGlobalVariableValue(varPath);
    }

    public void addSummary(ActionComment action) {
        this.getTopScript().summaryStack(action.getComment().getCalculated());
    }

    public CalculatedValue clv(Object ... data) {
        return new CalculatedValue(this, data);
    }

    public String prm(String name) {
        return this.getParameterValue(name);
    }

    public String prm(String name, String defaultValue) {
        return this.getParameterValue(name, defaultValue);
    }

    public String prm(int index) {
        return this.getParameterValue(index);
    }

    public String prm(int index, String defaultValue) {
        return this.getParameterValue(index, defaultValue);
    }

    public CalculatedValue[] prm(CalculatedValue ... values) {
        return values;
    }

    public void rtn(CalculatedValue ... values) {
        int i = 0;
        this.returnValues = new String[values.length];
        for (CalculatedValue calc : values) {
            this.returnValues[i] = calc.getCalculated();
            ++i;
        }
        this.updateVariables();
    }

    public void rtn(String ... values) {
        int i = 0;
        this.returnValues = new String[values.length];
        String[] stringArray = values;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String value;
            this.returnValues[i] = value = stringArray[j];
            ++i;
        }
        this.updateVariables();
    }

    private void updateVariables() {
        List<Variable> variables = this.getVariables();
        int index = 0;
        for (String value : this.returnValues) {
            if (variables.size() < index + 1) break;
            variables.get(index).setData(value);
            ++index;
        }
    }

    public void returnValues(String ... values) {
        this.returnValues = values;
        this.updateVariables();
    }

    public void returnValues(Object ... values) {
        this.returnValues = (String[])Arrays.stream(values).map(Object::toString).toArray(String[]::new);
        this.updateVariables();
    }

    public String rds(int len) {
        return new RandomStringValue(len, null).exec();
    }

    public String rds(int len, String type) {
        return new RandomStringValue(len, type).exec();
    }

    public String env(String name) {
        return this.getEnvironmentValue(name, "");
    }

    public String env(String name, String defaultValue) {
        return this.getEnvironmentValue(name, defaultValue);
    }

    public String sys(String name) {
        return AtsSingleton.getInstance().getSystemValue(name);
    }

    public CalculatedProperty prp(String type, String name, CalculatedValue value) {
        return new CalculatedProperty(type, name, value);
    }

    public String uid() {
        return this.getUuidValue();
    }

    public String td() {
        return this.getTodayValue();
    }

    public String nw() {
        return this.getNowValue();
    }

    public int itr() {
        return this.getIteration();
    }

    public int itc() {
        return this.getIterationsCount();
    }

    public SearchedElement el(SearchedElement parent, int index, boolean shadow, String tagName, CalculatedProperty ... properties) {
        return new SearchedElement(parent, index, shadow, tagName, properties);
    }

    public SearchedElement el(int index, boolean shadow, String tagName, CalculatedProperty ... properties) {
        return new SearchedElement(null, index, shadow, tagName, properties);
    }

    public SearchedElement el(SearchedElement parent, int index, boolean shadow, String tagName) {
        return new SearchedElement(parent, index, shadow, tagName);
    }

    public SearchedElement el(int index, boolean shadow, String tagName) {
        return new SearchedElement(null, index, shadow, tagName);
    }

    public RegexpTransformer rx(String patt, int[] group) {
        return new RegexpTransformer(patt, group);
    }

    public DateTransformer dt(String ... data) {
        DateTransformer dtr = new DateTransformer(data);
        dtr.setDateOrder(this.getDateOrder());
        return dtr;
    }

    public TimeTransformer tm(String ... data) {
        return new TimeTransformer(data);
    }

    public NumericTransformer nm(int dp, boolean comma) {
        return new NumericTransformer(dp, comma);
    }

    public MouseDirectionData ps(Cartesian cart, CalculatedValue value) {
        return new MouseDirectionData(cart, value);
    }

    public Mouse ms(String type) {
        return new Mouse(type);
    }

    public Mouse ms(String type, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new Mouse(type, hpos, vpos);
    }

    public MouseKey ms(String type, Keys key, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new MouseKey(type, key, hpos, vpos);
    }

    public MouseKey ms(String type, Keys key) {
        return new MouseKey(type, key);
    }

    public MouseScroll ms(int scroll, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new MouseScroll(scroll, hpos, vpos);
    }

    public MouseScroll ms(int scroll) {
        return new MouseScroll(scroll);
    }

    public MouseSwipe ms(MouseDirectionData hdir, MouseDirectionData vdir, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new MouseSwipe(hdir, vdir, hpos, vpos);
    }

    public MouseSwipe ms(MouseDirectionData hdir, MouseDirectionData vdir) {
        return new MouseSwipe(hdir, vdir);
    }

    public String emb(String relativePath) {
        return this.getAssetsUrl(relativePath);
    }

    public String ats(String key) {
        return this.getTopScript().getSpecialValue(key);
    }

    public boolean condition(String type, int line, Variable variable, CalculatedValue calculatedValue) {
        this.condition = new ConditionalValue(type, variable, calculatedValue);
        if (this.condition.isExec()) {
            return true;
        }
        this.getTopScript().getLogger().sendScriptInfo(ActionCallscript.getScriptLog(this.getTestName(), line, this.condition.getLog()));
        this.condition = null;
        return false;
    }

    public JsonObject getConditionLogs() {
        JsonObject result = new JsonObject();
        if (this.condition != null) {
            result = this.condition.getLog(result);
            this.condition = null;
        }
        return result;
    }

    public void exec(int line, Action action) {
        try {
            action.execute(this, this.getTestName(), line, 0);
        }
        catch (UnreachableBrowserException e) {
            action.failed(-17, "Browser driver not reachable, maybe channel have been closed !");
        }
        this.getTopScript().actionFinished(this.getTestName(), line, action);
    }

    public void exec(int line, ActionComment action) {
        action.execute(this, this.getTestName(), line, 0);
        if (action.isPassed()) {
            this.getTopScript().actionFinished(this.getTestName(), line, action);
        }
    }

    public void exec(int line, ActionCallscript action) {
        action.execute(this, this.getTestName(), line, 0);
        if (action.isPassed()) {
            this.getTopScript().actionFinished(this.getTestName(), line, action);
        } else {
            this.actionFinishedFail(action.getStatus(), action, line, this.getTestName());
            this.getTopScript().getRecorder().updateSummaryFail(this.getTestName(), line, "subString", action.getStatus().getFailMessage());
        }
    }

    public void exec(int line, ActionExecute action) {
        try {
            action.execute(this, this.getTestName(), line, 0);
        }
        catch (UnreachableBrowserException e) {
            action.failed(-17, "Browser driver not reachable, maybe channel have been closed !");
        }
        this.getTopScript().actionFinished(this.getTestName(), line, action, action.getStopPolicy());
    }

    public void startChannelFailed(String testName, int testLine, String appName, String failMessage) {
        this.failedAt(ActionChannelStart.class.getSimpleName(), testName, testLine, appName, -19, failMessage);
        this.getRecorder().updateSummaryFail(testName, testLine, appName, failMessage);
    }

    public void callScriptFailed(String testName, int testLine, int errorNum, String failMessage) {
        this.failedAt(ActionCallscript.class.getSimpleName(), testName, testLine, "", errorNum, failMessage);
        this.getRecorder().updateSummaryFail(testName, testLine, "", failMessage);
        this.status.addErrorStack(failMessage);
        StringBuilder sb = new StringBuilder(testName).append(":").append(testLine);
        this.status.addErrorStack(sb.toString());
        this.getTopScript().getRecorder().update(errorNum, 0L);
        this.getLogger().sendScriptError(failMessage, testName + ":" + testLine);
        this.scriptFail(failMessage);
    }

    public void failedAt(String action, String testName, int line, String app, int errorCode, String errorMessage) {
        this.status.failedAt(action, testName, line, app, errorCode, errorMessage);
        this.getLogger().sendScriptFail(action, testName, line, app, errorMessage);
    }

    public void actionFinished(String testName, int line, Action action) {
        this.actionFinished(testName, line, action, 0);
    }

    public void actionFinished(String testName, int line, Action action, int stopPolicy) {
        ActionStatus actionStatus;
        if (!(action instanceof ActionCallscript) && !(action instanceof ActionComment)) {
            this.status.addAction();
        }
        if ((actionStatus = action.getStatus()).isPassed()) {
            this.getLogger().sendAction(action, testName, line);
        } else if (stopPolicy == 0) {
            if (this.actionFinishedFail(actionStatus, action, line, testName)) {
                AtsSingleton.getInstance().getCurrentChannel().addShadowActionError(action, line);
                throw new AtsFailError(action, testName, line, this.status.getErrorScript(), this.status.getErrorInfo(), this.getLogger());
            }
        } else {
            this.getLogger().sendAction(action, testName, line);
            if (stopPolicy == 2) {
                this.actionFinishedFail(actionStatus, action, line, testName);
            }
        }
    }

    private boolean actionFinishedFail(ActionStatus actionStatus, Action action, int line, String testName) {
        if (this.status.isSuiteExecution()) {
            String app = actionStatus.getChannelApplication();
            String errorMessage = actionStatus.getFailMessage();
            this.getTopScript().failedAt(action.getClass().getSimpleName(), testName, line, app, actionStatus.getCode(), errorMessage);
            this.getRecorder().updateSummaryFail(testName, line, app, errorMessage);
            return true;
        }
        return false;
    }

    public void la(String message) {
        Assert.fail((String)message);
    }

    public Channel getCurrentChannel() {
        return AtsSingleton.getInstance().getCurrentChannel(this);
    }

    public void startDrag() {
        this.topScript.dragWithDesktop = AtsSingleton.getInstance().isDesktopChannel();
    }

    public boolean isDesktopDragDrop() {
        return this.topScript.dragWithDesktop;
    }

    public void endDrag() {
        this.topScript.dragWithDesktop = false;
    }

    public IVisualRecorder getRecorder() {
        return this.topScript.recorder;
    }

    public void setRecorder(IVisualRecorder value) {
        if (value instanceof VisualRecorderNull && this.recorder instanceof VisualRecorder || value instanceof VisualRecorder && this.recorder instanceof VisualRecorderNull) {
            this.topScript.recorder.terminate();
            this.topScript.recorder = value;
        }
    }

    public void startRecorder(ScriptHeader info, int quality, boolean xml, boolean htmlPlayer) {
        this.topScript.setRecorder(new VisualRecorder(this.topScript, info, this.projectData, xml, quality, htmlPlayer, true));
    }

    public void startRecorder(Channel channel, SystemDriver systemDriver) {
        systemDriver.startVisualRecord(channel, this.getScriptHeader(), 10, 0L);
    }

    public void stopRecorder() {
        this.topScript.setRecorder(new VisualRecorderNull());
    }
}

