/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor;

import com.ats.executor.ActionTestScript;
import com.google.gson.JsonObject;
import io.netty.util.CharsetUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.testng.TestRunner;

public class ScriptStatus {
    public static final String STARTING_SCRIPT = "Starting script";
    public static final String TERMINATED_SCRIPT = "Script terminated";
    private long start;
    private int actions = 0;
    private boolean passed = true;
    private String testName = "";
    private String suiteName = "";
    private String errorScript = "";
    private String errorInfo = "";
    private ArrayList<String> errorStack = new ArrayList();

    public ScriptStatus() {
        this.start = System.currentTimeMillis();
    }

    public ScriptStatus(String script, String suite) {
        this();
        this.testName = script;
        this.suiteName = suite;
    }

    public void addCallscriptStack(String value) {
        this.errorStack.add(value);
    }

    public void addAction() {
        ++this.actions;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public int getActions() {
        return this.actions;
    }

    public String getErrorScript() {
        return this.errorScript;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public void endLogs(ActionTestScript ts, TestRunner runner) {
        JsonObject logs = new JsonObject();
        long duration = System.currentTimeMillis() - this.start;
        logs.addProperty("name", this.testName);
        logs.addProperty("suite", this.suiteName);
        logs.addProperty("duration", String.valueOf(duration));
        logs.addProperty("passed", Boolean.valueOf(this.passed));
        logs.addProperty("actions", (Number)this.actions);
        String logsContent = logs.toString();
        ts.getLogger().sendScriptInfo("Script terminated -> " + logsContent);
        Path output = Paths.get(runner.getOutputDirectory(), "../ats-scripts.json");
        PrintWriter out = null;
        try {
            BufferedWriter bufWriter = Files.newBufferedWriter(output, CharsetUtil.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            out = new PrintWriter((Writer)bufWriter, true);
            out.println(logsContent);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isSuiteExecution() {
        return this.testName != null && this.suiteName != null && this.testName.length() != 0 && this.suiteName.length() != 0;
    }

    public void addErrorStack(String value) {
        this.errorStack.add(value);
    }

    public String getCallscriptStack() {
        if (this.errorStack.size() > 0) {
            return this.errorStack.stream().collect(Collectors.joining(" <- "));
        }
        return null;
    }

    public void failedAt(String actionClass, String script, int line, String app, int errorCode, String errorMessage) {
        this.passed = false;
        JsonObject logs = new JsonObject();
        logs.addProperty("app", app);
        logs.addProperty("errorCode", (Number)errorCode);
        logs.addProperty("errorMessage", errorMessage);
        StringBuilder sb = new StringBuilder(actionClass).append(" (").append(script).append(":").append(line).append(")");
        this.errorScript = sb.toString();
        this.errorInfo = logs.toString();
    }
}

