/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor;

import com.ats.data.Dimension;
import com.ats.data.Point;
import com.ats.data.Rectangle;

public class TestBound {
    private Double x = 0.0;
    private Double y = 0.0;
    private Double width = 10.0;
    private Double height = 10.0;

    public TestBound() {
    }

    public TestBound(Double x, Double y) {
        this.setX(x);
        this.setY(y);
    }

    public TestBound(Double x, Double y, Double width, Double height) {
        this.update(x, y, width, height);
    }

    public void update(Double x, Double y, Double width, Double height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public Point getPoint() {
        return new Point(this.x.intValue(), this.y.intValue());
    }

    public Dimension getSize() {
        return new Dimension(this.width.intValue(), this.height.intValue());
    }

    public boolean isCollision(TestBound dimension) {
        return this.getPoint().x == dimension.getPoint().x || this.getPoint().y == dimension.getPoint().y;
    }

    public void updateLocation(Double x, Double y) {
        this.x = this.x + x;
        this.y = this.y + y;
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        if (width > 0.0 || width == -1.0) {
            this.width = width;
        }
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        if (height > 0.0 || height == -1.0) {
            this.height = height;
        }
    }
}

