/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers;

import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.RemoteDriverInfo;
import com.ats.tools.Utils;
import com.ats.tools.logger.ExecutionLogger;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class DriverInfo
implements IDriverInfo {
    public static final String DRIVER_INFO = "driverInfo";
    public static final String SESSION_ID = "sessionId";
    private static final String SHUTDOWN = "/shutdown";
    private static final String STOP = "/stop";
    public static final String ATS_DRIVER_VERSION = "ats-driver-version";
    public static final String ATS_DRIVER_PORT = "ats-driver-port";
    public static final String ATS_AGENT_PORT = "ats-agent-port";
    public static final String ATS_AGENT_OUTPUT = "ats-agent-output";
    public static final String ATS_AGENT_WARNING = "ats-agent-warning";
    public static final String ATS_AGENT_ERROR = "ats-agent-error";
    public static final String ATS_AGENT_INFO = "ats-agent-info";
    protected String name;
    private String driverId;
    private URI driverServerUri;
    private String applicationPath;
    private String screenshotUrl;
    private String sessionId;
    private boolean headless;
    private String uuid;
    protected String driverVersion = null;
    protected int port = -1;
    protected ActionTestScript script;

    public DriverInfo(String name, ActionTestScript script) {
        this.name = name;
        this.script = script;
        this.uuid = UUID.randomUUID().toString();
    }

    public DriverInfo(ActionStatus status, String name, URI driverUri, ActionTestScript script) {
        this(name, script);
        this.driverServerUri = driverUri;
        if (driverUri == null) {
            status.setError(0, "driver url is null !");
        } else if (!this.isAlive()) {
            status.setError(0, "host is not reachable : " + driverUri.getHost() + ":" + driverUri.getPort());
        } else {
            int port = this.getAgentPort();
            if (port > 0) {
                Object hostName = "";
                try {
                    hostName = (String)hostName + InetAddress.getLocalHost().getHostName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                WebSocket ws = HttpClient.newHttpClient().newWebSocketBuilder().buildAsync(URI.create("ws://" + driverUri.getHost() + ":" + port), new WebSocketClient(this)).join();
                StringJoiner sj = new StringJoiner("\t");
                sj.add(System.getProperty("user.name"));
                sj.add((CharSequence)hostName);
                sj.add(this.uuid);
                ws.sendText(sj.toString(), true);
                status.setNoError();
            } else {
                status.setError(0, "systemdriver is not ready : " + driverUri.getHost() + ":" + driverUri.getPort());
            }
        }
    }

    public DriverInfo(String name, RemoteDriverInfo remoteDriver, ActionTestScript script) {
        this(name, script);
        this.driverId = remoteDriver.getId();
        this.driverServerUri = remoteDriver.getDriverUri();
        this.applicationPath = remoteDriver.getApplicationPath();
        this.setDriverVersion(remoteDriver.getDriverVersion());
    }

    public void output(String line) {
        String[] logs = line.split("\\|");
        if (logs.length > 1) {
            String logType = logs[0];
            if (ATS_AGENT_INFO.equals(logType)) {
                this.script.getLogger().sendDriverLog(logs[1]);
            } else if (ATS_AGENT_WARNING.equals(logType)) {
                this.script.getLogger().sendDriverWarning(logs[1]);
            } else if (!ATS_AGENT_PORT.equals(logType)) {
                if (ATS_DRIVER_PORT.equals(logType)) {
                    this.port = Utils.string2Int(logs[1], -1);
                } else if (ATS_AGENT_ERROR.equals(logType)) {
                    this.script.getLogger().sendDriverError(logs[1]);
                } else if (ATS_AGENT_OUTPUT.equals(logType)) {
                    this.script.getLogger().sendDriverOutput(logs[1]);
                } else if (ATS_DRIVER_VERSION.equals(logType)) {
                    this.setDriverVersion(logs[1]);
                } else {
                    this.script.getLogger().sendDriverOutput(logs[1]);
                }
            }
        } else {
            this.script.getLogger().sendDriverOutput(logs[0]);
        }
    }

    @Override
    public void sendLogsInfo(ExecutionLogger logger) {
        this.script.getLogger().sendInfo("ATS-AGENT system driver version", this.driverVersion);
    }

    protected void sendShutdown() {
        this.sendCommand(SHUTDOWN);
    }

    protected void sendStop() {
        this.sendCommand(STOP);
    }

    private void sendCommand(String command) {
        OkHttpClient client = new OkHttpClient.Builder().cache(null).connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(this.getDriverServerUri().resolve(command).toString());
        Request request = requestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF8").get().build();
        try {
            Response resp = client.newCall(request).execute();
            int responseCode = resp.code();
            resp.close();
        }
        catch (JsonSyntaxException | IOException throwable) {
            // empty catch block
        }
    }

    protected void setDriverVersion(String value) {
        if (this.driverVersion == null) {
            String[] version = value.split(".");
            if (version.length > 2) {
                StringJoiner sj = new StringJoiner(".");
                sj.add(version[0]).add(version[1]).add(version[2]);
                this.driverVersion = sj.toString();
            } else {
                this.driverVersion = value;
            }
            this.sendLogsInfo(this.script.getLogger());
        }
    }

    @Override
    public boolean isHeadless() {
        return this.headless;
    }

    @Override
    public void setHeadless(boolean value) {
        this.headless = value;
    }

    @Override
    public StringBuilder getDriverSessionUrl() {
        return this.getDriverHostAndPort().append("/session/").append(this.sessionId).append("/");
    }

    @Override
    public void setSessionId(String id) {
        this.sessionId = id;
        this.screenshotUrl = this.getDriverSessionUrl().append("screenshot").toString();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setUdpInfo(String info) {
        this.screenshotUrl = info;
    }

    @Override
    public String getScreenshotUrl() {
        return this.screenshotUrl;
    }

    @Override
    public boolean isAlive() {
        try {
            HttpURLConnection urlConn = (HttpURLConnection)this.getDriverServerUri().toURL().openConnection();
            urlConn.connect();
            int response = urlConn.getResponseCode();
            urlConn.disconnect();
            return 200 == response || 201 == response;
        }
        catch (IOException e) {
            return false;
        }
    }

    private int getAgentPort() {
        try {
            JsonNode statusValue;
            ObjectMapper mapper;
            JsonNode status;
            HttpURLConnection urlConn = (HttpURLConnection)this.getDriverServerUri().resolve("status").toURL().openConnection();
            urlConn.setRequestMethod("GET");
            urlConn.setRequestProperty("User-Agent", "ATS-EXECUTOR");
            int responseCode = urlConn.getResponseCode();
            if (responseCode == 200 && (status = (mapper = new ObjectMapper()).readTree(urlConn.getInputStream())).has("value") && (statusValue = status.get("value")).get("ready").asBoolean() && statusValue.has("remoteAgent")) {
                JsonNode agent = statusValue.get("remoteAgent");
                return agent.get("port").asInt();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public StringBuilder getDriverHostAndPort() {
        return new StringBuilder("http://").append(this.getDriverServerUri().getHost()).append(":").append(this.getDriverServerUri().getPort());
    }

    @Override
    public JsonNode toJson() {
        ObjectNode data = new ObjectMapper().createObjectNode();
        data.put(SESSION_ID, this.sessionId);
        data.put("screenshotUrl", this.screenshotUrl);
        data.put("headless", this.headless);
        ObjectNode node = new ObjectMapper().createObjectNode();
        node.set(DRIVER_INFO, (JsonNode)data);
        return node;
    }

    @Override
    public String getId() {
        return this.driverId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDriverServerUri(URI value) {
        this.driverServerUri = value;
    }

    @Override
    public URI getDriverServerUri() {
        if (this.driverServerUri == null) {
            try {
                return new URI("http://localhost:80/");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return this.driverServerUri;
    }

    @Override
    public String getApplicationPath() {
        return this.applicationPath;
    }

    @Override
    public URI getDriverLoopback() {
        return null;
    }

    @Override
    public void close() {
        this.sendStop();
    }

    @Override
    public void quit() {
    }

    @Override
    public String getDriverVersion() {
        return this.driverVersion;
    }

    private static class WebSocketClient
    implements WebSocket.Listener {
        private DriverInfo driverInfo;

        public WebSocketClient(DriverInfo driverInfo) {
            this.driverInfo = driverInfo;
        }

        @Override
        public void onOpen(WebSocket webSocket) {
            WebSocket.Listener.super.onOpen(webSocket);
        }

        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            this.driverInfo.output(data.toString());
            return WebSocket.Listener.super.onText(webSocket, data, last);
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            System.out.println("WsAgent error -> " + webSocket.toString());
            WebSocket.Listener.super.onError(webSocket, error);
        }
    }
}

