/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers;

import com.ats.AtsSingleton;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.StreamGobblerError;
import com.ats.executor.StreamGobblerInput;
import com.ats.executor.drivers.DriverInfo;
import com.ats.generator.ATS;
import com.ats.tools.OperatingSystem;
import com.ats.tools.ReadableConsumerByteChannel;
import com.ats.tools.Utils;
import com.ats.tools.logger.ExecutionLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DriverInfoLocal
extends DriverInfo {
    private static final List<String> WEBDRIVER_NOTERROR_LIST = Collections.unmodifiableList(List.of("CreatePlatformSocket() failed:", "bind() failed:", "Error: no DISPLAY environment variable specified", "*** You are running in headless mode.", "WebDriver BiDi listening on ws", "DevTools listening on ws", "JavaScript error:", "Dynamically enable window", "Unable to receive message from renderer"));
    private static final String WINDOWS_DRIVER_FILE_NAME = "windowsdriver.exe";
    private static final String LINUX_DRIVER_FILE_NAME = "linuxdriver";
    private static final String MACOS_DRIVER_FILE_NAME = "macosdriver";
    private Process process;
    private File driverFile;
    private final String atsSystemDriverUrl = ATS.getAtsServer() + "/releases/ats-drivers/" + OperatingSystem.getOSName() + "/system/";
    private static final Pattern DRIVER_VERSION_PATTERN = Pattern.compile(".* (.*)");

    public DriverInfoLocal(ActionStatus status, Path driverFolderPath, String logLevel, ActionTestScript script) {
        super("desktop", script);
        String driverFileName = WINDOWS_DRIVER_FILE_NAME;
        if (OperatingSystem.isUnix()) {
            driverFileName = LINUX_DRIVER_FILE_NAME;
        } else if (OperatingSystem.isMac()) {
            driverFileName = MACOS_DRIVER_FILE_NAME;
        }
        this.driverFile = driverFolderPath.resolve(driverFileName).toFile();
        String projectDriverVersion = DriverInfoLocal.getAtsSystemDriverVersion(this.atsSystemDriverUrl);
        boolean outboundTrafficBlocked = "false".equals(System.getProperty("outbound-traffic"));
        if (!this.driverFile.exists()) {
            if (projectDriverVersion == null) {
                status.setError(-19, "unable to launch driver process, driver file is missing : " + this.driverFile.getAbsolutePath());
                return;
            }
            DriverInfoLocal.donwloadAndInstallSystemDriver(outboundTrafficBlocked, driverFolderPath, this.atsSystemDriverUrl + projectDriverVersion + "." + OperatingSystem.getArchiveExtension());
        }
        if (this.driverFile.exists()) {
            this.loadDriverVersion(this.driverFile);
            if (projectDriverVersion != null && !"LATEST".equals(projectDriverVersion) && !projectDriverVersion.equals(this.getDriverVersion())) {
                DriverInfoLocal.donwloadAndInstallSystemDriver(outboundTrafficBlocked, driverFolderPath, this.atsSystemDriverUrl + projectDriverVersion + "." + OperatingSystem.getArchiveExtension());
            }
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(this.driverFile.getAbsolutePath());
            arguments.add("--local");
            ProcessBuilder builder = new ProcessBuilder(arguments);
            builder.redirectInput(ProcessBuilder.Redirect.PIPE);
            builder.redirectError(ProcessBuilder.Redirect.PIPE);
            try {
                this.process = builder.start();
                StreamGobblerError errorGobbler = new StreamGobblerError(this.process.getErrorStream(), this);
                StreamGobblerInput intputGobbler = new StreamGobblerInput(this.process.getInputStream(), this);
                intputGobbler.start();
                errorGobbler.start();
            }
            catch (IOException e1) {
                status.setError(-19, e1.getMessage());
                return;
            }
        } else {
            status.setError(-19, "unable to launch driver process, driver file is missing : " + this.driverFile.getAbsolutePath());
            return;
        }
        int maxTry = 40;
        while (this.port < 0 && maxTry > 0) {
            --maxTry;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.port < 0) {
            status.setError(-19, "unable to get valid port for this driver (" + this.name + ")");
            return;
        }
        try {
            this.setDriverServerUri(new URI("http://localhost:" + this.port));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Runtime.getRuntime().addShutdownHook(new CloseProcess(this));
        status.setNoError();
    }

    @Override
    public boolean isAlive() {
        return this.process != null && this.process.isAlive();
    }

    @Override
    public StringBuilder getDriverHostAndPort() {
        return new StringBuilder("http://localhost:").append(this.port);
    }

    public void outputError(String line) {
        if (((Stream)WEBDRIVER_NOTERROR_LIST.stream().parallel()).anyMatch(line::contains)) {
            this.script.getLogger().sendDriverWarning(line);
        } else {
            this.script.getLogger().sendDriverError(line);
        }
    }

    @Override
    public void close() {
        super.close();
        this.quit();
    }

    @Override
    public void quit() {
        if (this.process != null && this.process.isAlive()) {
            this.shutdownDriver();
            this.shutdownDriver();
            if (this.process != null && this.process.isAlive()) {
                this.terminateProcess();
            }
        }
    }

    private void terminateProcess() {
        this.process.descendants().forEach(p -> p.destroy());
        this.process.destroy();
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.process = null;
    }

    @Override
    public URI getDriverLoopback() {
        try {
            return new URI("http://127.0.0.1:" + this.port);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private void loadDriverVersion(File file) {
        try {
            Matcher m;
            ProcessBuilder pb = new ProcessBuilder(file.getAbsolutePath(), "--version");
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            if (line != null && (m = DRIVER_VERSION_PATTERN.matcher(line)).find()) {
                this.setDriverVersion(m.group(1));
            }
            reader.close();
            process.destroyForcibly();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void unExpectedExit() {
        AtsSingleton.getInstance().setSystemDriver(null);
    }

    public void shutdownDriver() {
        this.sendShutdown();
    }

    @Override
    public void sendLogsInfo(ExecutionLogger logger) {
        logger.sendInfo("ATS system driver version", this.getDriverVersion());
        logger.sendInfo("ATS drivers folder", this.driverFile.getParent());
    }

    private static String getAtsSystemDriverVersion(String sysDriverUrl) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        String version = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(Paths.get("pom.xml", new String[0]).toFile());
            doc.getDocumentElement().normalize();
            NodeList project = doc.getElementsByTagName("project");
            if (project.getLength() > 0) {
                NodeList projectItems = project.item(0).getChildNodes();
                block2: for (int i = 0; i < projectItems.getLength(); ++i) {
                    if (!"properties".equals(projectItems.item(i).getNodeName())) continue;
                    NodeList properties = projectItems.item(i).getChildNodes();
                    for (int j = 0; j < properties.getLength(); ++j) {
                        if (!"ats.driver.version".equals(properties.item(j).getNodeName())) continue;
                        version = properties.item(j).getTextContent();
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("LATEST".equals(version)) {
            version = Utils.getArtifactLastVersion(sysDriverUrl);
        }
        return version;
    }

    private static void donwloadAndInstallSystemDriver(boolean trafficBlocked, Path driverFolderPath, String systemDriverUrl) {
        try {
            if (!trafficBlocked) {
                Path folder = Files.createTempDirectory("ats_download", new FileAttribute[0]);
                File tmpFile = folder.resolve("system-driver").toAbsolutePath().toFile();
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
                HttpURLConnection connection = (HttpURLConnection)new URI(systemDriverUrl).toURL().openConnection();
                int fileLength = connection.getContentLength();
                ReadableConsumerByteChannel rcbc = new ReadableConsumerByteChannel(Channels.newChannel(connection.getInputStream()), fileLength, p -> {});
                FileOutputStream fosx = new FileOutputStream(tmpFile);
                fosx.getChannel().transferFrom(rcbc, 0L, Long.MAX_VALUE);
                fosx.close();
                if (tmpFile.exists() && tmpFile.length() > 10000L) {
                    if (OperatingSystem.isUnix()) {
                        try {
                            ProcessBuilder pb = new ProcessBuilder("tar", "-xzf", tmpFile.getAbsolutePath(), "-C", driverFolderPath.toFile().getAbsolutePath());
                            pb.start().waitFor();
                        }
                        catch (Exception exception) {}
                    } else if (OperatingSystem.isWindows()) {
                        DriverInfoLocal.unzipArchive(tmpFile, driverFolderPath);
                    }
                }
                folder.toFile().delete();
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
    }

    private static void unzipArchive(File archive, Path destination) {
        try {
            DriverInfoLocal.unzipFolder(archive.toPath(), destination);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        archive.delete();
    }

    private static void unzipFolder(Path source, Path target) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(source.toFile()));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                boolean isDirectory = false;
                if (zipEntry.getName().endsWith(File.separator) || zipEntry.isDirectory()) {
                    isDirectory = true;
                }
                Path newPath = DriverInfoLocal.zipSlipProtect(zipEntry, target);
                if (isDirectory) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    private static Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }

    static class CloseProcess
    extends Thread {
        private DriverInfoLocal driver;

        public CloseProcess(DriverInfoLocal driver) {
            this.driver = driver;
        }

        @Override
        public void run() {
            this.driver.quit();
        }
    }
}

