/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.data.Dimension;
import com.ats.data.Point;
import com.ats.data.Rectangle;
import com.ats.driver.ApplicationProperties;
import com.ats.element.AtsBaseElement;
import com.ats.element.AtsMobileElement;
import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.MobileRootElement;
import com.ats.element.MobileTestElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.channels.MobileChannel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.DriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.SystemDriverEngine;
import com.ats.executor.drivers.engines.mobiles.AndroidRootElement;
import com.ats.executor.drivers.engines.mobiles.IosRootElement;
import com.ats.executor.drivers.engines.mobiles.MobileAlert;
import com.ats.executor.drivers.engines.mobiles.RootElement;
import com.ats.generator.ATS;
import com.ats.generator.objects.BoundData;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.graphic.ImageTemplateMatchingSimple;
import com.ats.script.actions.ActionApi;
import com.ats.tools.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class MobileDriverEngine
extends DriverEngine
implements IDriverEngine {
    public static final String DRIVER = "driver";
    private static final String APP = "app";
    public static final String START = "start";
    public static final String STOP = "stop";
    private static final String SWITCH = "switch";
    private static final String CAPTURE = "capture";
    public static final String INPUT = "input";
    public static final String ELEMENT = "element";
    public static final String ALERT = "alert";
    public static final String TAP = "tap";
    public static final String TAP2 = "tap2";
    public static final String PRESS = "press";
    public static final String SWIPE = "swipe";
    public static final String SELECT = "select";
    public static final String SCRIPTING = "scripting";
    public static final String SET_PROP = "property-set";
    public static final String GET_PROP = "property";
    public static final String SYS_BUTTON = "sysbutton";
    public static final String atsVersion = ATS.getAtsVersion();
    private static final String SCREENSHOT_METHOD = "/screenshot";
    private JsonNode source;
    private MobileTestElement testElement;
    private OkHttpClient client;
    protected RootElement rootElement;
    protected RootElement cachedElement;
    protected long cachedElementTime = 0L;
    private String userAgent;
    private String token;
    private String endPoint;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    public String serialNumber;
    public String chromeDriver;
    public String chromeDriverVersion;
    public String chromeVersion;
    public String statusPage;

    public MobileDriverEngine(MobileChannel channel, ActionStatus status, String app, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props, String token) {
        super(channel, driverInfo, systemDriver, props, 0, 60);
        String[] appData;
        int start;
        this.getSystemDriver().setEngine(new SystemDriverEngine(channel, new DesktopWindow()));
        if (this.applicationPath == null) {
            this.applicationPath = app;
        }
        if ((start = this.applicationPath.indexOf("://")) > -1) {
            this.applicationPath = this.applicationPath.substring(start + 3);
        }
        if ((appData = this.applicationPath.split("/")).length > 0) {
            this.endPoint = appData[0];
            this.applicationPath = "http://" + this.endPoint;
            this.client = new OkHttpClient.Builder().cache(null).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(40L, TimeUnit.SECONDS).build();
            this.userAgent = "AtsMobileDriver/" + ATS.getAtsVersion() + "," + System.getProperty("user.name") + ",";
            this.token = token;
            JsonNode response = this.executeRequest(DRIVER, START);
            if (response == null) {
                status.setError(-19, "unable to connect to [ mobile://" + this.endPoint + " ]");
                return;
            }
            if (response.get("status").asInt() != 0) {
                status.setError(-19, response.get("message").asText());
                return;
            }
            this.token = response.get("token").asText();
            channel.addSystemProperties(response.withArray("systemProperties").elements());
            channel.addSystemButtons(response.withArray("systemButtons").elements());
            String systemName = response.get("systemName").asText();
            String driverVersion = response.get("driverVersion").asText();
            String userName = response.get("mobileUser").asText();
            String deviceName = response.get("deviceName").asText();
            String osBuild = response.get("osBuild").asText();
            String country = response.get("country").asText();
            String os = response.get("os").asText();
            double deviceWidth = 0.0;
            double deviceHeight = 0.0;
            double channelWidth = 0.0;
            double channelHeight = 0.0;
            double scale = 1.0;
            double captureScale = response.get("scale").asDouble();
            if (os.equals("android")) {
                this.serialNumber = response.get("serialNumber").asText();
                this.chromeDriver = response.get("chromeDriver").asText();
                this.chromeDriverVersion = response.get("chromeDriverVersion").asText();
                this.chromeVersion = response.has("chromeVersion") ? response.get("chromeVersion").asText() : "0";
                this.statusPage = response.get("statusPage").asText();
                this.rootElement = new AndroidRootElement(this);
                this.cachedElement = new AndroidRootElement(this);
                deviceWidth = response.get("deviceWidth").asDouble();
                deviceHeight = response.get("deviceHeightWithoutNavBar").asDouble();
                channelWidth = response.get("channelWidth").asDouble();
                channelHeight = response.get("channelHeightWithoutNavBar").asDouble();
                scale = captureScale;
            }
            int screenCapturePort = response.get("screenCapturePort").asInt();
            String application = null;
            if (appData.length > 1) {
                application = appData[1];
                response = this.executeRequest(APP, START, application);
            } else if (os.equals("android")) {
                response = this.executeRequest(APP, START);
            } else {
                status.setError(-19, "unable to connect : missing app");
                return;
            }
            if (response == null) {
                status.setError(-19, "unable to connect to : " + application);
                return;
            }
            if (response.get("status").asInt() != 0) {
                status.setError(-19, response.get("message").asText());
                return;
            }
            String base64 = response.get("icon").asText();
            byte[] icon = new byte[]{};
            if (base64.length() > 0) {
                try {
                    icon = Base64.getDecoder().decode(base64);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (os.equals("ios")) {
                this.rootElement = new IosRootElement(this, captureScale);
                this.cachedElement = new IosRootElement(this, captureScale);
                deviceWidth = response.get("deviceWidth").asDouble();
                deviceHeight = response.get("deviceHeight").asDouble();
                channelWidth = response.get("channelWidth").asDouble();
                channelHeight = response.get("channelHeight").asDouble();
            }
            String[] endPointData = this.endPoint.split(":");
            String version = response.get("version").asText();
            String udpInfo = endPointData[0] + ":" + screenCapturePort;
            channel.setDimensions(new TestBound(0.0, 0.0, deviceWidth, deviceHeight), new TestBound(0.0, 0.0, channelWidth, channelHeight), scale, captureScale);
            channel.setApplicationData("mobile", os, systemName, version, driverVersion, icon, udpInfo, application, userName, deviceName, osBuild, country);
            this.getDriverInfo().setUdpInfo(endPointData[0] + ":" + screenCapturePort);
            this.refreshElementMapLocation();
        }
    }

    @Override
    public WebElement getRootElement(Channel cnl) {
        this.refreshElementMapLocation();
        return new MobileRootElement(this.rootElement.getValue());
    }

    @Override
    public TestElement getTestElementRoot() {
        this.refreshElementMapLocation();
        return new TestElement(new FoundElement(this.rootElement.getValue()), this.channel);
    }

    @Override
    public void refreshElementMapLocation() {
        JsonNode src;
        this.source = src = this.executeRequest(CAPTURE, new String[0]);
        if (src != null) {
            this.rootElement.refresh(src);
        }
    }

    protected void loadCapturedElement() {
        long current = System.currentTimeMillis();
        if (this.cachedElement == null || current - 2500L > this.cachedElementTime) {
            JsonNode src;
            if (this.cachedElement != null && (src = this.executeRequest(CAPTURE, new String[0])) != null) {
                this.cachedElement.refresh(src);
            }
            this.cachedElementTime = System.currentTimeMillis();
        }
    }

    @Override
    public void close() {
        String application = this.channel.getApplication();
        if (application != null) {
            this.executeRequest(APP, STOP, application);
        }
        this.channel = null;
    }

    public void tearDown() {
        JsonNode jsonObject = this.executeRequest(DRIVER, STOP);
        if (jsonObject != null) {
            this.token = null;
        }
    }

    @Override
    public FoundElement getElementFromPoint(Boolean syscomp, Double x, Double y) {
        this.loadCapturedElement();
        ArrayList<AtsMobileElement> listElements = new ArrayList<AtsMobileElement>();
        this.loadList(this.cachedElement.getValue(), listElements, "A");
        double mouseX = this.channel.getSubDimension().getX() + x;
        double mouseY = this.channel.getSubDimension().getY() + y;
        AtsMobileElement element = this.cachedElement.getValue();
        listElements.sort(Comparator.comparing(AtsMobileElement::getPositionInDom));
        for (AtsMobileElement child : listElements) {
            double coordinateX = child.getX();
            double coordinateY = child.getY();
            double coordinateW = child.getWidth();
            double coordinateH = child.getHeight();
            if (!child.getRect().contains(mouseX, mouseY) || !element.getRect().contains(coordinateX, coordinateY) && !element.getRect().contains(coordinateX + coordinateW, coordinateY) && !element.getRect().contains(coordinateX + coordinateW, coordinateY + coordinateH) && !element.getRect().contains(coordinateX, coordinateY + coordinateH)) continue;
            element = child;
        }
        return element.getFoundElement();
    }

    @Override
    public FoundElement getElementFromRect(Boolean syscomp, Double x, Double y, Double w, Double h) {
        this.loadCapturedElement();
        ArrayList<AtsMobileElement> listElements = new ArrayList<AtsMobileElement>();
        this.loadList(this.cachedElement.getValue(), listElements, "A");
        double mouseX = this.channel.getSubDimension().getX() + x;
        double mouseY = this.channel.getSubDimension().getY() + y;
        AtsMobileElement element = this.cachedElement.getValue();
        listElements.sort(Comparator.comparing(AtsMobileElement::getPositionInDom));
        for (AtsMobileElement child : listElements) {
            Rectangle childRect = child.getRect();
            if (!childRect.contains(new Rectangle(mouseX, mouseY, w, h)) || !element.getRect().contains(childRect)) continue;
            element = child;
        }
        return element.getFoundElement();
    }

    public String getToken() {
        return this.token;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    private void loadList(AtsMobileElement element, ArrayList<AtsMobileElement> list, String order) {
        AtsMobileElement[] children = element.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (element.getChildren() == null) continue;
                AtsMobileElement child = element.getChildren()[i];
                String newOrder = order + this.getCharForNumber(i + 1);
                child.setPositionInDom(newOrder);
                list.add(child);
                this.loadList(child, list, newOrder);
            }
        }
    }

    private String getCharForNumber(int i) {
        return i > 0 && i < 27 ? String.valueOf((char)(i + 64)) : "Z";
    }

    @Override
    public void loadParents(FoundElement element) {
        AtsMobileElement parent;
        AtsMobileElement atsElement = this.getCapturedElementById(element.getId(), false);
        if (atsElement != null && (parent = atsElement.getParent()) != null) {
            element.setParent(parent.getFoundElement());
            FoundElement currentParent = element.getParent();
            for (parent = parent.getParent(); parent != null && !parent.isRoot(); parent = parent.getParent()) {
                currentParent.setParent(parent.getFoundElement());
                currentParent = currentParent.getParent();
            }
        }
    }

    @Override
    public String getTextData(FoundElement e) {
        return e.getInnerText();
    }

    @Override
    public CalculatedProperty[] getAttributes(FoundElement element, boolean reload) {
        AtsMobileElement atsElement = this.getCapturedElementById(element.getId(), reload);
        if (atsElement != null) {
            return atsElement.getMobileAttributes();
        }
        return new CalculatedProperty[0];
    }

    private AtsMobileElement getCapturedElementById(String id, boolean reload) {
        if (reload) {
            return this.getElementById(this.rootElement.getValue(), id);
        }
        if (this.cachedElement != null) {
            return this.getElementById(this.cachedElement.getValue(), id);
        }
        return null;
    }

    @Override
    public String getAttribute(ActionStatus status, FoundElement element, String attributeName, int maxTry) {
        AtsMobileElement atsElement = this.getElementById(element.getId());
        if (atsElement != null) {
            return atsElement.getAttribute(attributeName);
        }
        return null;
    }

    @Override
    public List<FoundElement> findElements(boolean sysComp, TestElement testObject, String tagName, String[] attributes, String[] attributesValues, Predicate<AtsBaseElement> searchPredicate, WebElement startElement) {
        ArrayList<AtsMobileElement> list = new ArrayList<AtsMobileElement>();
        TestElement parent = testObject.getParent();
        if (sysComp) {
            if ("SYSCOMP".equalsIgnoreCase(tagName)) {
                list = new ArrayList<AtsMobileElement>(List.of(this.rootElement.getValue()));
            } else {
                this.refreshElementMapLocation();
                this.loadElementsByTag(this.rootElement.getValue(), tagName, list);
            }
        } else if (parent == null) {
            this.refreshElementMapLocation();
            this.loadElementsByTag(this.rootElement.getValue(), tagName, list);
        } else {
            this.loadElementsByTag(this.getElementById(parent.getWebElementId()), tagName, list);
        }
        return list.parallelStream().filter(searchPredicate).map(FoundElement::new).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public List<FoundElement> findElements(TestElement parent, ImageTemplateMatchingSimple template) {
        byte[] screenshot = this.getSystemDriver().getMobileScreenshotByte(this.getScreenshotPath());
        return template.findOccurrences(screenshot).parallelStream().map(r -> new FoundElement(this.channel, parent, (Rectangle)r)).collect(Collectors.toCollection(ArrayList::new));
    }

    public void loadElementsByTag(AtsMobileElement root, String tag, List<AtsMobileElement> list) {
        if (root == null) {
            return;
        }
        if (root.checkTag(tag)) {
            list.add(root);
        }
        for (AtsMobileElement child : root.getChildren()) {
            this.loadElementsByTag(child, tag, list);
        }
    }

    @Override
    public void buttonClick(ActionStatus status, String type) {
        JsonNode result = this.executeRequest(SYS_BUTTON, type);
        int code = result.get("status").asInt();
        String message = result.get("message").asText();
        if (code == 0) {
            status.setNoError(message);
        } else {
            status.setError(-60, message);
        }
    }

    @Override
    public void tap(int count, FoundElement element) {
        this.rootElement.tap(element, count);
    }

    @Override
    public void press(int duration, ArrayList<String> paths, FoundElement element) {
        this.rootElement.press(element, paths, duration);
    }

    @Override
    public void mouseClick(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        this.cachedElementTime = 0L;
        this.rootElement.tap(status, element, position);
    }

    @Override
    public void drag(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        this.testElement = this.rootElement.getCurrentElement(element, position);
    }

    @Override
    public void moveByOffset(int hDirection, int vDirection) {
        this.rootElement.swipe(this.testElement, hDirection, vDirection);
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList, int waitChar) {
        this.rootElement.textInput(element, textActionList);
    }

    @Override
    public List<String[]> loadSelectOptions(TestElement element) {
        return Collections.emptyList();
    }

    @Override
    public List<FoundElement> findSelectOptions(TestBound dimension, TestElement element) {
        return Collections.emptyList();
    }

    @Override
    public void selectOptionsItem(ActionStatus status, TestElement element, CalculatedProperty selectProperty, boolean keepSelect) {
        this.executeRequest(ELEMENT, element.getFoundElement().getId(), SELECT, selectProperty.getName(), selectProperty.getValue().getCalculated());
    }

    @Override
    public void clearText(ActionStatus status, TestElement te, MouseDirection md) {
        this.mouseClick(status, te.getFoundElement(), md, 0, 0);
        this.rootElement.clearInput(te);
    }

    @Override
    public void updateScreenshot(TestBound dimension, boolean isRef) {
        if (this.channel != null) {
            this.getSystemDriver().updateMobileScreenshot(this.channel.getSubDimension(), isRef, this.getScreenshotPath());
        }
    }

    @Override
    public byte[] getScreenshot(Double x, Double y, Double width, Double height) {
        byte[] screen = this.getSystemDriver().getMobileScreenshotByte(this.getScreenshotPath());
        if (screen != null) {
            ImageIO.setUseCache(false);
            ByteArrayInputStream in = new ByteArrayInputStream(screen);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedImage subImage = new BufferedImage(width.intValue(), height.intValue(), 1);
            Graphics g = subImage.getGraphics();
            try {
                g.drawImage(ImageIO.read(in), 0, 0, width.intValue(), height.intValue(), x.intValue(), y.intValue(), x.intValue() + width.intValue(), y.intValue() + height.intValue(), null);
                g.dispose();
                ImageIO.write((RenderedImage)subImage, "png", baos);
                baos.flush();
                byte[] result = baos.toByteArray();
                baos.close();
                return result;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new byte[1];
    }

    @Override
    public void createVisualAction(Channel channel, boolean stop, String actionType, int scriptLine, String scriptName, long timeline, boolean sync) {
        this.getSystemDriver().createMobileRecord(stop, actionType, scriptLine, scriptName, timeline, channel.getName(), channel.getSubDimension(), this.getScreenshotPath(), sync);
    }

    private String getScreenshotPath() {
        return this.getApplicationPath() + SCREENSHOT_METHOD;
    }

    @Override
    public void api(ActionStatus status, ActionApi api) {
    }

    @Override
    public boolean switchWindow(ActionStatus status, int index, int tries, boolean refresh) {
        return true;
    }

    @Override
    public void closeWindow(ActionStatus status) {
    }

    @Override
    public Object executeScript(ActionStatus status, String script, Object ... params) {
        return null;
    }

    @Override
    public void goToUrl(ActionStatus status, String url) {
    }

    @Override
    public void waitAfterAction(ActionStatus status) {
    }

    @Override
    public void scroll(FoundElement element) {
    }

    @Override
    public void scroll(int value) {
    }

    @Override
    public void scroll(FoundElement element, int delta) {
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
    }

    @Override
    public void mouseMoveToElement(FoundElement element) {
    }

    @Override
    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
    }

    @Override
    public String setWindowBound(BoundData x, BoundData y, BoundData width, BoundData height) {
        return "";
    }

    @Override
    public void keyDown(Keys key) {
    }

    @Override
    public void keyUp(Keys key) {
    }

    @Override
    public void drop(MouseDirection md, boolean desktopDriver) {
    }

    @Override
    public void doubleClick() {
    }

    @Override
    public void rightClick() {
    }

    @Override
    public DialogBox switchToAlert() {
        return new MobileAlert(this);
    }

    public List<AtsMobileElement> getDialogBox() {
        this.refreshElementMapLocation();
        ArrayList<AtsMobileElement> list = new ArrayList<AtsMobileElement>();
        this.loadElementsByTag(this.rootElement.getValue(), "Alert", list);
        return list;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public boolean switchToDefaultContent(boolean dialog) {
        return true;
    }

    @Override
    public void setWindowToFront() {
        String application = this.channel.getApplication();
        if (application != null) {
            this.executeRequest(APP, SWITCH, this.channel.getApplication());
        } else {
            this.executeRequest(APP, SWITCH);
        }
    }

    @Override
    public void switchToFrameId(String id) {
    }

    @Override
    public void updateDimensions() {
    }

    private AtsMobileElement getElementById(String id) {
        return this.getElementById(this.rootElement.getValue(), id);
    }

    private AtsMobileElement getElementById(AtsMobileElement root, String id) {
        if (root.getId().equals(id)) {
            return root;
        }
        for (AtsMobileElement elem : root.getChildren()) {
            elem.setParent(root);
            AtsMobileElement found = this.getElementById(elem, id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public JsonNode executeRequest(String type, String ... data) {
        return MobileDriverEngine.executeRequestToMobile(this.applicationPath + "/" + type, this.token, this.userAgent, this.client, this.jsonMapper, data);
    }

    public static JsonNode executeRequestToMobile(String url, String token, String userAgent, OkHttpClient client, ObjectMapper jsonMapper, String ... data) {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        requestBuilder.addHeader("Ats-Version", atsVersion);
        if (token != null) {
            requestBuilder.addHeader("Token", token);
        }
        Request request = requestBuilder.addHeader("User-Agent", userAgent).addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF8").post(RequestBody.Companion.create(Stream.of(data).map(Object::toString).collect(Collectors.joining("\n")), Utils.JSON_MEDIA)).build();
        try {
            Response response = client.newCall(request).execute();
            String responseData = CharStreams.toString((Readable)new InputStreamReader(response.body().byteStream(), Charsets.UTF_8));
            response.close();
            return jsonMapper.readTree(responseData);
        }
        catch (JsonSyntaxException | IOException e) {
            return null;
        }
    }

    @Override
    public String getSource() {
        this.refreshElementMapLocation();
        return this.source.toString();
    }

    @Override
    public void windowState(ActionStatus status, Channel channel, String state) {
    }

    @Override
    public void setSysProperty(String propertyName, String propertyValue) {
        this.executeRequest(SET_PROP, propertyName, propertyValue);
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, TestElement element) {
        JsonObject result = (JsonObject)this.rootElement.scripting(script, element.getFoundElement());
        return this.handleResult(status, result);
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, boolean returnValue) {
        JsonObject result = (JsonObject)this.rootElement.scripting(script);
        return this.handleResult(status, result);
    }

    private Object handleResult(ActionStatus status, JsonObject result) {
        int code = result.get("status").getAsInt();
        String message = result.get("message").getAsString();
        if (code == 0) {
            status.setNoError(message);
        } else {
            status.setError(-13, message);
        }
        return result;
    }

    @Override
    public String getSelectedText(TestElement e) {
        return "";
    }

    @Override
    protected void setPosition(Point pt) {
    }

    @Override
    protected void setSize(Dimension dim) {
    }

    @Override
    public int getNumWindows() {
        return 1;
    }

    @Override
    public String getUrl() {
        return this.applicationPath;
    }

    @Override
    public Rectangle getBoundRect(TestElement testElement) {
        return null;
    }

    public double getOffsetX(Rectangle rect, double scale, MouseDirection position) {
        return this.getCartesianOffset((int)(rect.getWidth() / scale), position.getHorizontalPos(), Cartesian.LEFT, Cartesian.CENTER, Cartesian.RIGHT);
    }

    public double getOffsetY(Rectangle rect, double scale, MouseDirection position) {
        return this.getCartesianOffset((int)(rect.getHeight() / scale), position.getVerticalPos(), Cartesian.TOP, Cartesian.MIDDLE, Cartesian.BOTTOM);
    }

    @Override
    public String getCookies() {
        return "";
    }

    @Override
    public String getHeaders(ActionStatus status) {
        return "";
    }

    @Override
    public void quit() {
    }
}

