/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers;

import com.ats.driver.ApplicationProperties;
import com.ats.element.FoundElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.generator.objects.MouseDirection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.testng.collections.Sets;

public class IEDriverEngine
extends WebDriverEngine {
    private final Set<String> windows = Sets.newLinkedHashSet();

    public IEDriverEngine(Channel channel, ActionStatus status, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props) {
        super(channel, driverInfo, systemDriver, props);
        this.JS_SCROLL_IF_NEEDED = "var e=arguments[0], bo=arguments[1], result=[];var r=e.getBoundingClientRect();if(r.top < 0 || r.left < 0 || r.bottom > (window.innerHeight || document.documentElement.clientHeight) || r.right > (window.innerWidth || document.documentElement.clientWidth)) {e.scrollIntoView(true);r=e.getBoundingClientRect();result=[r.left+0.0001, r.top+0.0001];}";
        InternetExplorerOptions ieOptions = new InternetExplorerOptions();
        if (props.getOptions() != null && props.getOptions().length > 0) {
            this.addOptions(props.getOptions(), ieOptions);
        } else {
            ieOptions.introduceFlakinessByIgnoringSecurityDomains();
            ieOptions.ignoreZoomSettings();
        }
        this.launchDriver(status, (MutableCapabilities)ieOptions);
        if (status.isPassed() && !"11".equals(channel.getApplicationVersion())) {
            status.setError(-19, "cannot start channel with IE" + channel.getApplicationVersion() + " (Only IE11 is supported by ATS)");
        }
        this.executeToFront();
    }

    @Override
    public void setWindowToFront() {
        super.setWindowToFront();
        this.executeToFront();
    }

    private void executeToFront() {
        try {
            this.driver.executeAsyncScript("var callback=arguments[arguments.length-1];var result=setTimeout(function(){window.focus();},1000);callback(result);", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void scroll(FoundElement element) {
        try {
            super.scroll(element);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void drag(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        this.desktopMoveToElement(element, position, (int)(element.getWidth() / 2.0), (int)(element.getHeight() / 2.0) - 8);
        this.getSystemDriver().mouseDown();
    }

    @Override
    public void drop(MouseDirection md, boolean desktopDriver) {
        this.getSystemDriver().mouseRelease();
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
        this.getSystemDriver().mouseMiddleClick();
    }

    @Override
    public void doubleClick() {
        this.getSystemDriver().doubleClick();
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList, int waitSearch) {
        if (element.isNumeric()) {
            for (SendKeyData sequence : textActionList) {
                element.executeScript(status, "value='" + sequence.getData() + "'", true);
            }
        } else {
            try {
                for (SendKeyData sequence : textActionList) {
                    element.getWebElement().sendKeys(new CharSequence[]{sequence.getSequenceWeb(true)});
                }
            }
            catch (Exception e) {
                status.setError(-4, e.getMessage());
            }
        }
    }

    @Override
    public boolean switchWindow(ActionStatus status, int index, int tries, boolean refresh) {
        super.switchWindow(status, index, tries, refresh);
        if (status.isPassed()) {
            this.executeJavaScript(status, "setTimeout(function(){window.focus();},1000);", true);
            this.channel.setWindowToFront();
            this.executeToFront();
            this.channel.sleep(2000);
            this.getSystemDriver().updateWindowHandle(this.channel);
        }
        return true;
    }

    @Override
    protected Set<String> getDriverWindowsList() {
        Set<String> driverList = super.getDriverWindowsList();
        driverList.parallelStream().forEach(s -> this.windows.add((String)s));
        Iterator<String> iterator = this.windows.iterator();
        while (iterator.hasNext()) {
            if (driverList.contains(iterator.next())) continue;
            iterator.remove();
        }
        return this.windows;
    }

    @Override
    protected Object runJavaScript(ActionStatus status, String javaScript, Object ... params) {
        status.setPassed(true);
        try {
            return this.driver.executeScript(javaScript + ";return result;", params);
        }
        catch (StaleElementReferenceException e0) {
            status.setPassed(false);
            throw e0;
        }
        catch (Exception e1) {
            status.setException(-13, e1);
            return null;
        }
    }

    private void addOptions(String[] options, InternetExplorerOptions ieOptions) {
        ArrayList<String> extra = new ArrayList<String>();
        for (String o : options) {
            if ("useShellWindowsApiToAttachToIe".equalsIgnoreCase(o)) {
                ieOptions.useShellWindowsApiToAttachToIe();
                continue;
            }
            if ("enablePersistentHovering".equalsIgnoreCase(o)) {
                ieOptions.enablePersistentHovering();
                continue;
            }
            if ("destructivelyEnsureCleanSession".equalsIgnoreCase(o)) {
                ieOptions.destructivelyEnsureCleanSession();
                continue;
            }
            if ("disableNativeEvents".equalsIgnoreCase(o)) {
                ieOptions.disableNativeEvents();
                continue;
            }
            if ("ignoreZoomSettings".equalsIgnoreCase(o)) {
                ieOptions.ignoreZoomSettings();
                continue;
            }
            if ("useCreateProcessApiToLaunchIe".equalsIgnoreCase(o)) {
                ieOptions.useCreateProcessApiToLaunchIe();
                continue;
            }
            if ("requireWindowFocus".equalsIgnoreCase(o)) {
                ieOptions.requireWindowFocus();
                continue;
            }
            if ("usePerProcessProxy".equalsIgnoreCase(o)) {
                ieOptions.usePerProcessProxy();
                continue;
            }
            extra.add(o);
        }
        if (extra.size() > 0) {
            ieOptions.addCommandSwitches(extra.toArray(new String[extra.size()]));
        }
    }
}

