/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.parsers;

import com.ats.generator.parsers.Lexer;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.transform.Transformer;
import com.ats.script.ScriptHeader;
import com.ats.script.ScriptLoader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;

public class ScriptParser {
    public static final String ATS_SEPARATOR = "->";
    public static final int ATS_SEPARATOR_SIZE = "->".length();
    public static final String ATS_ASSIGN_SEPARATOR = "=>";
    public static final String ATS_PROPERTIES_FILE = ".atsProjectProperties";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss");
    private Lexer lexer;

    public ScriptParser(Lexer lexer) {
        this.lexer = lexer;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public boolean isGenerator() {
        return this.lexer.isGenerator();
    }

    public void addScript() {
        this.lexer.addScript();
    }

    private String getDataGroup(Matcher m, int index) {
        if (m.groupCount() > index - 1 && m.group(index) != null) {
            return m.group(index).trim();
        }
        return "";
    }

    private String getHeaderData(String data) {
        return data.substring(data.indexOf(ATS_SEPARATOR) + ATS_SEPARATOR_SIZE).trim();
    }

    public void parse(ScriptLoader script, ScriptHeader header, String data) {
        if (data.regionMatches(true, 0, "groups", 0, ScriptHeader.GROUPS_LENGTH)) {
            header.parseGroups(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, "description", 0, ScriptHeader.DESCRIPTION_LENGTH)) {
            header.setDescription(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, "id", 0, ScriptHeader.ID_LENGTH)) {
            header.setId(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, "external", 0, ScriptHeader.EXTERNAL_ID_LENGTH)) {
            header.setExternalId(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, "uuid", 0, ScriptHeader.UUID_LENGTH)) {
            header.setUuid(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, "created", 0, ScriptHeader.DATE_CREATED_LENGTH)) {
            String dateString = this.getHeaderData(data);
            try {
                header.setCreatedAt(dateFormat.parse(dateString));
            }
            catch (Exception exception) {}
        } else if (data.regionMatches(true, 0, "author", 0, ScriptHeader.AUTHOR_LENGTH)) {
            header.setAuthor(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, "prerequisite", 0, ScriptHeader.PREREQUISITE_LENGTH)) {
            header.setPrerequisite(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, "var", 0, Variable.SCRIPT_LABEL_LENGTH)) {
            ArrayList<String> dataArray = new ArrayList<String>(Arrays.asList(this.getHeaderData(data).split(ATS_SEPARATOR)));
            if (dataArray.size() > 0) {
                String name = dataArray.remove(0).trim();
                String value = "";
                Transformer transformer = null;
                if (dataArray.size() > 0) {
                    String nextData = dataArray.remove(0).trim();
                    Matcher m = Transformer.TRANSFORM_PATTERN.matcher(nextData);
                    if (m != null && m.find()) {
                        transformer = Transformer.createTransformer(this.getDataGroup(m, 1), this.getDataGroup(m, 2));
                        if (dataArray.size() > 0) {
                            value = dataArray.remove(0).trim();
                        }
                    } else {
                        value = nextData;
                    }
                }
                script.addVariable(name, new CalculatedValue(script, value), transformer);
            }
        } else if (data.regionMatches(true, 0, "return", 0, ScriptHeader.RETURN_LENGTH)) {
            String[] returnsData = this.getHeaderData(data).split(ATS_SEPARATOR);
            CalculatedValue[] returns = new CalculatedValue[returnsData.length];
            for (int i = 0; i < returnsData.length; ++i) {
                returns[i] = new CalculatedValue(script, returnsData[i].trim());
            }
            script.setReturns(returns);
        } else {
            boolean actionDisabled = false;
            if (data.startsWith("//")) {
                data = data.substring(2);
                actionDisabled = true;
            }
            this.lexer.createAction(script, data, actionDisabled);
        }
    }
}

