/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.transform;

import com.ats.generator.variables.transform.Transformer;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateTransformer
extends Transformer {
    private static final DateTimeFormatter STANDARD_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final Pattern PATTERN_DAY_TRANSFORM = Pattern.compile("(-?\\d+)([ymd])");
    private int year = 0;
    private int month = 0;
    private int day = 0;
    private String formatter = "";
    private String dateOrder = "";

    public DateTransformer() {
    }

    public DateTransformer(String ... data) {
        for (String item : data) {
            Matcher dataMatcher = PATTERN_DAY_TRANSFORM.matcher(item);
            if (dataMatcher.find()) {
                if ("y".equals(dataMatcher.group(2))) {
                    this.setYear(this.getInt(dataMatcher.group(1)));
                    continue;
                }
                if ("m".equals(dataMatcher.group(2))) {
                    this.setMonth(this.getInt(dataMatcher.group(1)));
                    continue;
                }
                if (!"d".equals(dataMatcher.group(2))) continue;
                this.setDay(this.getInt(dataMatcher.group(1)));
                continue;
            }
            if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{item})) continue;
            this.setFormatter(item);
        }
    }

    public void setDateOrder(String value) {
        this.dateOrder = value;
    }

    public static String getTodayValue() {
        return LocalDate.now().format(STANDARD_FORMATTER);
    }

    @Override
    public String getJavaCode() {
        StringJoiner joiner = new StringJoiner(", ");
        if (StringUtils.isNotEmpty((CharSequence)this.formatter)) {
            joiner.add("\"" + this.formatter + "\"");
        }
        if (this.year != 0) {
            joiner.add("\"" + this.year + "y\"");
        }
        if (this.month != 0) {
            joiner.add("\"" + this.month + "m\"");
        }
        if (this.day != 0) {
            joiner.add("\"" + this.day + "d\"");
        }
        return "dt(" + joiner.toString() + ")";
    }

    @Override
    public String format(String data) {
        if (data.length() > 0) {
            String[] dateArray = data.replace("-", "/").replace(".", "/").replace("\\", "/").split("/");
            if (dateArray.length == 3) {
                LocalDate localDate = null;
                try {
                    if (this.dateOrder.length() == 3) {
                        HashMap<String, Integer> parser = new HashMap<String, Integer>();
                        for (int i = 0; i < 3; ++i) {
                            parser.put(this.dateOrder.substring(i, i + 1), Integer.parseInt(dateArray[i]));
                        }
                        localDate = LocalDate.of((int)((Integer)parser.get("Y")), (Integer)parser.get("M"), (int)((Integer)parser.get("D")));
                    } else {
                        localDate = LocalDate.of(Integer.parseInt(dateArray[0]), Integer.parseInt(dateArray[1]), Integer.parseInt(dateArray[2]));
                    }
                    localDate = localDate.plusYears(this.year).plusMonths(this.month).plusDays(this.day);
                    if (StringUtils.isNotEmpty((CharSequence)this.formatter)) {
                        return localDate.format(DateTimeFormatter.ofPattern(this.formatter));
                    }
                    return localDate.format(STANDARD_FORMATTER);
                }
                catch (IllegalArgumentException | DateTimeException e) {
                    return "#DateParseError# -> " + e.getMessage();
                }
            }
            return "#DateParseError# -> cannot split date : " + data;
        }
        return "#DateParseError# -> date is empty";
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public void setFormatter(String format) {
        this.formatter = format;
    }
}

