/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.transform;

import com.ats.generator.variables.transform.Transformer;
import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.parser.ParseException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumericTransformer
extends Transformer {
    private int decimal = -1;
    private boolean comma = false;
    private static final String NUMERIC_FUNCTION = "0123456789.,()abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWYYZ-*/+^!><=$;";
    private static final Pattern IF_THEN_ELSE_REGEXP = Pattern.compile("if\\(([^\\)]*);([^\\)]*);([^\\)]*)\\)");

    public NumericTransformer() {
    }

    public NumericTransformer(Object dp, Object useComma) {
        this((Integer)dp, (Boolean)useComma);
    }

    public NumericTransformer(int dp) {
        this.setDecimal(dp);
        this.setComma(false);
    }

    public NumericTransformer(int dp, boolean useComma) {
        this.setDecimal(dp);
        this.setComma(useComma);
    }

    public NumericTransformer(String data) {
        if (data.contains(",")) {
            this.setComma(true);
            data = data.replace(",", "");
        }
        this.setDecimal(this.getInt(data.replace("dp", "").trim()));
    }

    @Override
    public String getJavaCode() {
        return "nm(" + this.decimal + ", " + this.comma + ")";
    }

    @Override
    public String format(String data) {
        StringBuilder numericData = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            String s = data.substring(i, i + 1);
            if (NUMERIC_FUNCTION.indexOf(s) == -1) continue;
            numericData.append(s);
        }
        data = numericData.toString();
        if (data.length() > 0) {
            DecimalFormat df;
            if (this.comma) {
                df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.FRENCH));
                data = data.replace(",", ".");
            } else {
                df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                data = data.replace(",", "");
            }
            df.setMaximumFractionDigits(340);
            double calc = 0.0;
            Matcher verif = IF_THEN_ELSE_REGEXP.matcher(data);
            if (verif.find()) {
                try {
                    double check = new Expression(verif.group(1)).evaluate().getNumberValue().doubleValue();
                    if (check > 0.0) {
                        calc = new Expression(verif.group(2)).evaluate().getNumberValue().doubleValue();
                    }
                    calc = new Expression(verif.group(3)).evaluate().getNumberValue().doubleValue();
                }
                catch (EvaluationException | ParseException e) {
                    return "NaN";
                }
            } else {
                try {
                    calc = new Expression(data).evaluate().getNumberValue().doubleValue();
                }
                catch (Exception e) {
                    return "NaN";
                }
            }
            String result = null;
            BigDecimal bd = BigDecimal.valueOf(calc);
            result = this.decimal > -1 ? bd.setScale(this.decimal, RoundingMode.HALF_UP).toPlainString() : bd.toPlainString().replaceFirst("\\.0$", "");
            if (this.comma) {
                return result.replace(".", ",");
            }
            return result.replace(",", ".");
        }
        return "0";
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public boolean getComma() {
        return this.comma;
    }

    public void setComma(boolean value) {
        this.comma = value;
    }
}

