/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.transform;

import com.ats.generator.variables.transform.Transformer;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.text.StringEscapeUtils;

public class RegexpTransformer
extends Transformer {
    private List<Integer> groups = new ArrayList<Integer>(Arrays.asList(1));
    private String pattern = "(.*)";

    public RegexpTransformer() {
    }

    public RegexpTransformer(String pattern, int[] groups) {
        this.setPattern(pattern);
        this.groups = new ArrayList<Integer>();
        for (int i : groups) {
            this.groups.add(i);
        }
    }

    public RegexpTransformer(String pattern, String groups) {
        this.setPattern(pattern);
        this.groups = new ArrayList<Integer>();
        for (String s : groups.split("+")) {
            this.groups.add(this.getInt(s));
        }
    }

    public RegexpTransformer(String data) {
        int lastComa = data.lastIndexOf(",");
        try {
            String[] groups = data.substring(lastComa + 1).split("\\+");
            ArrayList<Integer> groupsNum = new ArrayList<Integer>();
            for (String s : groups) {
                groupsNum.add(this.getInt(s));
            }
            if (groupsNum.size() > 0) {
                this.setGroups(groupsNum);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.setGroups(new ArrayList<Integer>(Arrays.asList(1)));
        }
        try {
            this.setPattern(data.substring(0, lastComa).trim());
        }
        catch (IndexOutOfBoundsException e) {
            this.setPattern("(.*)");
        }
    }

    @Override
    public String getJavaCode() {
        return "rx(\"" + StringEscapeUtils.escapeJava((String)this.pattern) + "\", new int[]{" + Joiner.on((String)", ").join(this.groups) + "})";
    }

    @Override
    public String format(String data) {
        if (data.length() > 0) {
            try {
                Pattern patternComp = Pattern.compile(this.pattern);
                Matcher m = patternComp.matcher(data);
                if (m.find()) {
                    StringBuilder builder = new StringBuilder();
                    for (int g : this.groups) {
                        try {
                            builder.append(m.group(g));
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    }
                    return builder.toString();
                }
            }
            catch (PatternSyntaxException e) {
                return "#REGEXP_ERROR# (Pattern syntax error) " + this.pattern;
            }
        }
        return "";
    }

    public List<Integer> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Integer> value) {
        this.groups = value;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

