/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script;

import com.ats.generator.GeneratorReport;
import com.ats.generator.parsers.Lexer;
import com.ats.generator.parsers.ScriptParser;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.script.Project;
import com.ats.script.Script;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionCallscript;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.ahocorasick.trie.Trie;

public class ScriptLoader
extends Script {
    public static final String SCRIPT_EXTENSION_ERROR = "ERR #198 - wrong file extension";
    public static final String SCRIPT_LOADING_ERROR = "ERR #199 - the script cannot be loaded";
    private ScriptParser parser;
    private ScriptHeader header;
    private String javaCode = null;
    private Charset charset;
    private ArrayList<Action> actions = new ArrayList();
    private String projectGav = "";
    private boolean update = false;

    public ScriptLoader() {
    }

    public ScriptLoader(Lexer lexer) {
        this.parser = new ScriptParser(lexer);
        this.parser.addScript();
    }

    public ScriptLoader(String type, Lexer lexer, File file, Project projectData) {
        this(type, lexer, file, projectData, DEFAULT_CHARSET);
    }

    public ScriptLoader(String type, Lexer lexer, File file, Project prj, Charset charset) {
        ScriptHeader header = new ScriptHeader(prj, file);
        this.setHeader(header);
        this.setCharset(charset);
        this.projectGav = prj.getGav();
        if ("ats".equals(type)) {
            if (file.getName().endsWith(".ats")) {
                this.setParameterList(new ParameterList(1));
                this.setVariables(new ArrayList<Variable>());
                this.parser = new ScriptParser(lexer);
                this.parser.addScript();
                try {
                    Stream<String> lines = Files.lines(file.toPath(), this.charset);
                    lines.map(String::trim).filter(a -> !a.isEmpty()).filter(a -> !a.startsWith("[")).forEach(a -> this.parser.parse(this, header, (String)a));
                    lines.close();
                }
                catch (Exception e) {
                    System.err.println("ATS load project error (ERR #199 - the script cannot be loaded) :\n" + file.getAbsolutePath());
                    header.setName(file.getName());
                    header.setPackageName("...");
                    header.setError(SCRIPT_LOADING_ERROR);
                }
            } else {
                header.setName(file.getName());
                header.setPackageName("...");
                header.setError(SCRIPT_EXTENSION_ERROR);
            }
        } else if ("java".equals(type)) {
            try {
                this.javaCode = new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ScriptLoader(Lexer lexer, String content, Project prj) {
        ScriptHeader header = new ScriptHeader(prj);
        this.setHeader(header);
        this.setCharset(DEFAULT_CHARSET);
        this.projectGav = prj.getGav();
        this.setParameterList(new ParameterList(1));
        this.setVariables(new ArrayList<Variable>());
        this.parser = new ScriptParser(lexer);
        this.parser.addScript();
        try {
            this.parser.parse(this, header, content);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setCharset(Charset value) {
        this.charset = value;
    }

    public void addAction(Action data, boolean disabled) {
        data.setDisabled(disabled);
        data.setLine(this.actions.size());
        this.actions.add(data);
    }

    public void addAction(Action data, boolean disabled, String atsCode) {
        this.addAction(data, disabled);
        data.setCode(atsCode);
    }

    public boolean isSubscriptCalled(String scriptName) {
        for (Action action : this.actions) {
            if (!(action instanceof ActionCallscript) || !((ActionCallscript)action).isSubscriptCalled(scriptName)) continue;
            return true;
        }
        return false;
    }

    public boolean getActionsKeywords(Trie trie) {
        for (Action action : this.actions) {
            ArrayList<String> actionKeywords = action.getKeywords();
            for (String keywords : actionKeywords) {
                if (!trie.containsMatch((CharSequence)keywords)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateSubscript(ArrayList<String> result, String oldName, String newName) {
        ArrayList<String[]> replacements = new ArrayList<String[]>();
        for (Action a : this.actions) {
            ActionCallscript action;
            if (!(a instanceof ActionCallscript) || !oldName.equals((action = (ActionCallscript)a).getName().getData())) continue;
            int start = a.getAtsCode().indexOf(oldName);
            int end = start + oldName.length();
            replacements.add(new String[]{a.getAtsCode(), a.getAtsCode().substring(0, start) + newName + a.getAtsCode().substring(end)});
        }
        this.saveUpdates(result, replacements);
    }

    public void updateDataFile(ArrayList<String> result, String oldPath, String newPath) {
        ArrayList<String[]> replacements = new ArrayList<String[]>();
        for (Action a : this.actions) {
            ActionCallscript action;
            if (!(a instanceof ActionCallscript) || (action = (ActionCallscript)a).getParameterFilePath() == null || !oldPath.equals(action.getParameterFilePath().getData())) continue;
            replacements.add(new String[]{a.getAtsCode(), a.getAtsCode().replace(oldPath, newPath)});
        }
        this.saveUpdates(result, replacements);
    }

    private void saveUpdates(ArrayList<String> result, ArrayList<String[]> replacements) {
        if (replacements.size() > 0) {
            ArrayList<String> lines = new ArrayList<String>();
            Path path = Paths.get(this.getHeader().getPath(), new String[0]);
            try {
                Files.lines(path).forEach(l -> lines.add((String)l));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int i = 0;
            String[] replace = replacements.remove(0);
            for (String line : lines) {
                if (line.equals(replace[0])) {
                    lines.set(i, replace[1]);
                    if (replacements.size() > 0) {
                        replace = replacements.remove(0);
                    }
                }
                ++i;
            }
            try {
                Files.write(path, lines, Charset.defaultCharset(), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result.add(this.getHeader().getQualifiedName());
        }
    }

    public String getJavaCode(Project project) {
        if (this.javaCode != null) {
            return this.javaCode;
        }
        StringBuilder code = new StringBuilder(this.header.getJavaCode(project));
        code.append("\r\n\r\n\t\t//   ---< Variables >---   //\r\n");
        List<Variable> variables = this.getVariables();
        Collections.sort(variables);
        for (Variable variable : variables) {
            code.append("\r\n\t\t").append(variable.getJavaCode()).append(";");
        }
        code.append("\r\n\r\n\t\t//   ---< Actions >---   //\r\n");
        for (Action action : this.actions) {
            if (action.isDisabled() || action.isScriptComment()) continue;
            code.append("\r\n\t\t").append((CharSequence)action.getJavaCode()).append(");");
        }
        CalculatedValue[] returnValues = this.getReturns();
        if (returnValues != null) {
            code.append("\r\n\r\n\t\t//   ---< Return >---   //\r\n\r\n\t\t").append("rtn").append("(");
            ArrayList<String> returnValuesCode = new ArrayList<String>();
            for (CalculatedValue ret : returnValues) {
                returnValuesCode.add(ret.getJavaCode());
            }
            code.append(String.join((CharSequence)", ", returnValuesCode)).append(");");
        }
        code.append("\r\n\t}\r\n}");
        return code.toString();
    }

    public void generateJavaFile(Project project) {
        if (this.header.getJavaDestinationFolder() != null) {
            File javaFile = this.header.getJavaFile();
            try {
                javaFile.getParentFile().mkdirs();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(javaFile, false), this.charset));
                writer.write(this.getJavaCode(project));
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean getUpdate() {
        return this.update;
    }

    public void setUpdate(boolean value) {
        this.update = value;
    }

    public ScriptHeader getHeader() {
        return this.header;
    }

    public void setHeader(ScriptHeader header) {
        this.header = header;
    }

    public ArrayList<Action> getActions() {
        return this.actions;
    }

    public void setActions(ArrayList<Action> value) {
        this.actions = value;
    }

    public String getProjectGav() {
        return this.projectGav;
    }

    public void setProjectGav(String value) {
    }

    public Lexer getLexer() {
        return this.parser.getLexer();
    }

    public static void main(String[] args) {
        File scriptFile;
        if (args.length == 1 && (scriptFile = new File(args[0])).exists() && scriptFile.isFile() && scriptFile.getName().toLowerCase().endsWith("ats")) {
            GeneratorReport report = new GeneratorReport();
            Lexer lexer = new Lexer(report);
            lexer.loadScript(scriptFile);
        }
    }
}

