/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionExecuteElement;
import com.ats.tools.Operators;
import com.ats.tools.Utils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ActionAssertCount
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL = "check-count";
    private final Pattern COUNT_PATTERN = Pattern.compile("(\\d+) ?(\\-?\\+?=?!?)");
    private int value = 1;
    private String operator = "=";

    public ActionAssertCount() {
    }

    public ActionAssertCount(ScriptLoader script, int stopPolicy, ArrayList<String> options, String data, ArrayList<String> objectArray) {
        super((Script)script, stopPolicy, options, objectArray);
        Matcher m = this.COUNT_PATTERN.matcher(data);
        if (m.matches()) {
            this.setValue(Utils.string2Int(m.group(1).trim(), 1));
            if (m.groupCount() > 1) {
                switch (m.group(2).trim()) {
                    case "+": {
                        this.setOperator(">=");
                        break;
                    }
                    case "-": {
                        this.setOperator("<=");
                        break;
                    }
                    case "!": {
                        this.setOperator("<>");
                    }
                }
            }
        }
    }

    public ActionAssertCount(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, String operator, int value) {
        super(script, stopPolicy, maxTry, delay, element);
        this.setOperator(operator);
        this.setValue(value);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(", ").append(Operators.getJavaCode(this.operator)).append(", ").append(this.value).append(")");
        return codeBuilder;
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, this.operator, this.value, tryNum);
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        this.getTestElement().checkOccurrences(ts, this.status, this.operator, this.value);
        this.status.getElement().setFoundElements(null);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("operator", this.operator);
        data.addProperty("occurrences", (Number)this.value);
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }
}

