/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.recorder.VisualAction;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionExecute;
import com.ats.tools.Operators;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class ActionAssertValue
extends ActionExecute {
    public static final String SCRIPT_LABEL = "check-value";
    private CalculatedValue value1;
    private CalculatedValue value2;
    private Operators operatorExec = new Operators();

    public ActionAssertValue() {
    }

    public ActionAssertValue(ScriptLoader script, int stopPolicy, String compairData) {
        super(script, stopPolicy);
        String[] operatorData = this.operatorExec.initData(compairData);
        this.setValue1(new CalculatedValue(script, operatorData[0]));
        this.setValue2(new CalculatedValue(script, operatorData[1]));
    }

    public ActionAssertValue(Script script, int stopPolicy, String operator, CalculatedValue value1, CalculatedValue value2) {
        super(script, stopPolicy);
        this.setOperator(operator);
        this.setValue1(value1);
        this.setValue2(value2);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("value1", this.value1.getCalculated());
        data.addProperty("value2", this.value2.getCalculated());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(this.operatorExec.getJavaCode()).append(", ").append(this.value1.getJavaCode()).append(", ").append(this.value2.getJavaCode()).append(")");
        return codeBuilder;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.value1.getKeywords());
        keywords.add(this.value2.getKeywords());
        return keywords;
    }

    public void execute(ActionTestScript ts, String testName, int testLine) {
        this.execute(ts, testName, testLine, 0);
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        String calculated1 = this.value1.getCalculated();
        String calculated2 = this.value2.getCalculated();
        String errorDescription = this.operatorExec.check(calculated1, calculated2);
        if (errorDescription == null) {
            this.status.setNoError(calculated1);
            this.getCurrentChannel().addShadowAction(this, testLine);
        } else {
            StringBuilder builder = new StringBuilder("Value1 '");
            builder.append(calculated1).append("' ").append(errorDescription).append(" value2 '").append(calculated2).append("'");
            this.status.setError(-7, builder.toString(), new String[]{calculated1, calculated2});
        }
        this.status.endDuration();
        ts.getRecorder().update(this.status.getCode(), this.status.getDuration(), calculated1, this.operatorExec.getType() + " " + calculated2);
    }

    @Override
    public VisualAction getVisualAction() {
        return new VisualAction(this, this.timeLine);
    }

    public CalculatedValue getValue1() {
        return this.value1;
    }

    public void setValue1(CalculatedValue value1) {
        this.value1 = value1;
    }

    public CalculatedValue getValue2() {
        return this.value2;
    }

    public void setValue2(CalculatedValue value2) {
        this.value2 = value2;
        this.operatorExec.updatePattern(value2.getCalculated());
    }

    public String getOperator() {
        return this.operatorExec.getType();
    }

    public void setOperator(String operator) {
        this.operatorExec.setType(operator);
    }
}

