/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.AtsSingleton;
import com.ats.element.SearchedElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.ConditionalValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.parameter.Parameter;
import com.ats.generator.variables.parameter.ParameterDataFile;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.recorder.VisualAction;
import com.ats.script.Script;
import com.ats.script.ScriptHeader;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionReturnVariableArray;
import com.ats.script.actions.IActionStoppable;
import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsFailError;
import com.google.gson.JsonObject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.ITestNGListener;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ActionCallscript
extends ActionReturnVariableArray
implements IActionStoppable {
    public static final String SCRIPT_LABEL = "subscript";
    public static final String CALLSCRIPT_LABEL = "callscript";
    public static final String RANDOM_LABEL = "rnd";
    public static final String SUITE_LABEL = "suite";
    public static final String RANGE_LABEL = "range";
    public static final String IF_LABEL = "if(";
    private static final String LOOP_LABEL = "loop";
    public static final Pattern LOOP_REGEXP = Pattern.compile("loop ?\\((\\d+)\\)", 2);
    public static final String ASSETS_PROTOCOLE = "assets:///";
    public static final String FILE_PROTOCOLE = "file://";
    public static final String HTTP_PROTOCOLE = "http://";
    public static final String HTTPS_PROTOCOLE = "https://";
    private CalculatedValue name;
    private int type = -1;
    private SearchedElement searchElement;
    private ArrayList<Variable> scriptVariables;
    private ParameterList parameters;
    private int loop = 1;
    private CalculatedValue parameterFilePath;
    private boolean suite = false;
    private String range = null;
    private boolean random = false;
    private JsonObject paramsData;
    private ConditionalValue condition;
    private String calledScript = "";

    public ActionCallscript() {
    }

    public ActionCallscript(ScriptLoader script, ArrayList<String> options, String name, String[] parameters, String[] returnValue, String csvFilePath, ArrayList<String> dataArray) {
        super(script);
        String firstParam;
        this.setName(new CalculatedValue(script, name));
        if (csvFilePath != null) {
            this.setParameterFilePath(new CalculatedValue(script, csvFilePath));
            if (dataArray != null && dataArray.size() > 0) {
                String l = dataArray.remove(0);
                if (l.contains(RANDOM_LABEL) || l.contains("random")) {
                    this.random = true;
                } else {
                    this.range = l;
                }
            }
        } else if (dataArray != null && dataArray.size() > 0) {
            this.searchElement = new SearchedElement(script, dataArray);
        } else if (parameters.length > 0 && !this.setParameterFilePathData(firstParam = parameters[0].trim())) {
            String[] paramsValues = new ArrayList();
            String[] stringArray = parameters;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String param = stringArray[i];
                Matcher match = LOOP_REGEXP.matcher(param = param.replaceAll("\n", ","));
                if (match.find()) {
                    this.loop = Utils.string2Int(match.group(1), 1);
                    continue;
                }
                paramsValues.add(new CalculatedValue(script, param.trim()));
            }
            this.setParameters((ArrayList<CalculatedValue>)paramsValues);
        }
        if (returnValue.length > 0 && this.loop == 1) {
            ArrayList<Variable> variableValues = new ArrayList<Variable>();
            for (String varName : returnValue) {
                variableValues.add(script.getVariable(varName.trim(), true));
            }
            this.setVariables(variableValues);
        }
        if (options.size() > 0) {
            String option = options.get(0);
            int operatorIndex = option.indexOf("=");
            if (operatorIndex > 1) {
                this.condition = new ConditionalValue(script, option.substring(0, operatorIndex).trim(), option.substring(operatorIndex + 1).trim(), "==");
            } else {
                operatorIndex = option.indexOf("<>");
                if (operatorIndex > 1) {
                    this.condition = new ConditionalValue(script, option.substring(0, operatorIndex).trim(), option.substring(operatorIndex + 2).trim(), "!=");
                }
            }
        }
    }

    public ActionCallscript(ScriptLoader script, String name, ArrayList<String> options, String[] parameters, String[] returnValue, String csvFilePath, ArrayList<String> dataArray) {
        super(script);
        String firstParam;
        this.setName(new CalculatedValue(script, name));
        if (csvFilePath != null) {
            this.setParameterFilePath(new CalculatedValue(script, csvFilePath));
        } else if (dataArray != null && dataArray.size() > 0) {
            this.searchElement = new SearchedElement(script, dataArray);
        } else if (parameters.length > 0 && !this.setParameterFilePathData(firstParam = parameters[0].trim())) {
            ArrayList<CalculatedValue> paramsValues = new ArrayList<CalculatedValue>();
            String[] stringArray = parameters;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String param = stringArray[i];
                param = param.replaceAll("\n", ",");
                paramsValues.add(new CalculatedValue(script, param.trim()));
            }
            this.setParameters(paramsValues);
        }
        options.forEach(o -> this.parseOptions(script, o.trim()));
        if (returnValue.length > 0 && this.loop == 1) {
            ArrayList<Variable> variableValues = new ArrayList<Variable>();
            for (String varName : returnValue) {
                variableValues.add(script.getVariable(varName.trim(), true));
            }
            this.setVariables(variableValues);
        }
    }

    public ActionCallscript(Script script, CalculatedValue name) {
        super(script);
        this.setName(name);
    }

    public ActionCallscript(Script script, CalculatedValue name, SearchedElement element) {
        this(script, name);
        this.setSearchElement(element);
    }

    public ActionCallscript(Script script, CalculatedValue name, CalculatedValue[] parameters) {
        this(script, name);
        this.setParameters(new ArrayList<CalculatedValue>(Arrays.asList(parameters)));
    }

    public ActionCallscript(Script script, CalculatedValue name, Variable ... variables) {
        this(script, name);
        this.setVariables(new ArrayList<Variable>(Arrays.asList(variables)));
    }

    public ActionCallscript(Script script, CalculatedValue name, CalculatedValue[] parameters, Variable ... variables) {
        this(script, name);
        this.setParameters(new ArrayList<CalculatedValue>(Arrays.asList(parameters)));
        this.setVariables(new ArrayList<Variable>(Arrays.asList(variables)));
    }

    public ActionCallscript(Script script, CalculatedValue name, boolean random, boolean suite, CalculatedValue csvFilePath, String range) {
        this(script, name);
        this.setRandom(random);
        this.setSuite(suite);
        this.setParameterFilePath(csvFilePath);
        this.setRange(range);
    }

    public ActionCallscript(Script script, CalculatedValue name, boolean random, boolean suite, CalculatedValue csvFilePath, String range, Variable ... variables) {
        this(script, name);
        this.setRandom(random);
        this.setSuite(suite);
        this.setParameterFilePath(csvFilePath);
        this.setRange(range);
        this.setVariables(new ArrayList<Variable>(Arrays.asList(variables)));
    }

    public ActionCallscript(Script script, CalculatedValue name, CalculatedValue[] parameters, int loop) {
        this(script, name, parameters);
        this.setLoop(loop);
    }

    public ActionCallscript(Script script, CalculatedValue name, int loop) {
        this(script, name);
        this.setLoop(loop);
    }

    @Override
    public boolean isStop() {
        return true;
    }

    private void parseOptions(Script script, String value) {
        if (RANDOM_LABEL.equals(value)) {
            this.random = true;
        } else if (SUITE_LABEL.equals(value)) {
            this.suite = true;
        } else if (value.startsWith(IF_LABEL) && value.endsWith(")")) {
            String conditionCode = value.substring(3, value.length() - 1);
            int operatorIndex = conditionCode.indexOf("==");
            if (operatorIndex > 1) {
                this.condition = new ConditionalValue(script, conditionCode.substring(0, operatorIndex).trim(), conditionCode.substring(operatorIndex + 2).trim(), "==");
            } else {
                operatorIndex = conditionCode.indexOf("!=");
                if (operatorIndex > 1) {
                    this.condition = new ConditionalValue(script, conditionCode.substring(0, operatorIndex).trim(), conditionCode.substring(operatorIndex + 2).trim(), "!=");
                }
            }
        } else {
            String[] optionData = value.split("=");
            if (optionData.length == 2) {
                String optionType = optionData[0].trim();
                String optionValue = optionData[1].trim();
                if (RANGE_LABEL.equals(optionType)) {
                    if (this.parameterFilePath != null) {
                        this.range = optionValue;
                    }
                } else if (LOOP_LABEL.equals(optionType)) {
                    this.loop = Utils.string2Int(optionValue, 1);
                }
            }
        }
    }

    public static String getScriptLog(String testName, int line, JsonObject log) {
        StringBuilder sb = new StringBuilder("Subscript init (").append(testName).append(":").append(line).append(") -> ").append(log.toString());
        return sb.toString();
    }

    public boolean isSubscriptCalled(String scriptName) {
        return this.name.getCalculated().equals(scriptName);
    }

    private boolean setParameterFilePathData(String value) {
        if (value != null && (value.startsWith(ASSETS_PROTOCOLE) || value.startsWith(FILE_PROTOCOLE) || value.startsWith(HTTP_PROTOCOLE) || value.startsWith(HTTPS_PROTOCOLE))) {
            this.setParameterFilePath(new CalculatedValue(this.script, value));
            return true;
        }
        return false;
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(this.name.getJavaCode());
        if (this.parameterFilePath != null) {
            codeBuilder.append(", ").append(this.random).append(", ").append(this.suite).append(", ").append(this.parameterFilePath.getJavaCode()).append(", ");
            if (this.range == null || this.range.isEmpty()) {
                codeBuilder.append("null");
            } else {
                codeBuilder.append("\"").append(this.range).append("\"");
            }
        } else if (this.searchElement != null) {
            codeBuilder.append(", ").append(this.searchElement.getJavaCode());
        } else {
            if (this.parameters != null) {
                this.parameters.getJavaCode(codeBuilder);
            }
            if (this.loop > 1) {
                codeBuilder.append(", ").append(this.loop);
            }
        }
        if (this.getVariables() != null) {
            StringJoiner joiner = new StringJoiner(", ");
            for (Variable variable : this.getVariables()) {
                joiner.add(variable.getName());
            }
            codeBuilder.append(", ").append(joiner.toString());
        }
        codeBuilder.append(")");
        if (this.condition != null) {
            return this.condition.getJavaCode(codeBuilder, this.getLine());
        }
        return codeBuilder;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.name.getData());
        if (this.parameterFilePath != null) {
            keywords.add(this.parameterFilePath.getKeywords());
        }
        if (this.searchElement != null) {
            keywords.addAll(this.searchElement.getKeywords());
        }
        return keywords;
    }

    @Override
    public Element getXmlElement(Document document, ScriptHeader header, int index, String errorText) {
        Element e = super.getXmlElement(document, header, index, errorText);
        e.appendChild(document.createElement("value")).setTextContent(this.calledScript);
        Element dataJson = document.createElement("dataJson");
        e.appendChild(dataJson);
        Element param = document.createElement("parameter");
        param.setAttribute("type", "asset");
        if (this.parameterFilePath != null) {
            param.setAttribute("value", this.parameterFilePath.getCalculated());
        }
        dataJson.appendChild(param);
        return e;
    }

    @Override
    public VisualAction getVisualAction() {
        return new VisualAction(this, this.timeLine, this.calledScript, this.parameterFilePath);
    }

    private URL loopAssetsFiles(File[] files, String path) {
        if (files != null) {
            for (File f : files) {
                if (f == null || !f.canRead()) continue;
                if (f.isDirectory()) {
                    return this.loopAssetsFiles(f.listFiles(), path);
                }
                if (!f.isFile() || !f.getPath().toLowerCase().endsWith(path)) continue;
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private URL getAssetDataFile(String path) {
        return this.loopAssetsFiles(new File(this.getClass().getClassLoader().getResource("assets").getPath()).listFiles(), path.replace("\\", File.separator).replace("/", File.separator).toLowerCase());
    }

    private ActionTestScript getNewAtsInstance(Class<ActionTestScript> clazz, ActionTestScript topScript, String scriptName) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ActionTestScript ats = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ats.setTopScript(topScript, scriptName);
        return ats;
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int line, int tryNum) {
        block41: {
            super.execute(ts, testName, line, 0);
            this.status.setNoError();
            this.calledScript = this.name.getCalculated().replace("\n", "");
            Class<ActionTestScript> clazz = AtsSingleton.getInstance().loadTestScriptClass(this.calledScript);
            this.getCurrentChannel().updateVisualCallScript(this.calledScript, ts.getRecorder(), this, testName, line);
            this.addParamsToData(ts);
            if (clazz == null) {
                String errorMessage = "ATS script not found (letter case issue ?) -> " + this.calledScript;
                this.status.setError(422, errorMessage + "\n");
                ts.callScriptFailed(testName, line, 422, errorMessage);
            } else {
                ActionTestScript topScript = ts.getTopScript();
                try {
                    if (this.parameterFilePath != null) {
                        String errorMessage;
                        String csvPath = this.parameterFilePath.getCalculated().replace("\\", "/");
                        URL csvUrl = null;
                        if (csvPath.startsWith(ASSETS_PROTOCOLE)) {
                            Object csvFilePath = csvPath.replace(ASSETS_PROTOCOLE, "");
                            csvUrl = this.getAssetDataFile((String)csvFilePath);
                            if (csvUrl == null) {
                                csvFilePath = "assets" + File.separator + (String)csvFilePath;
                                csvUrl = this.getClass().getClassLoader().getResource((String)csvFilePath);
                                if (csvUrl == null && (csvUrl = this.getClass().getClassLoader().getResource((String)csvFilePath + ".csv")) == null) {
                                    csvUrl = this.getClass().getClassLoader().getResource((String)csvFilePath + ".json");
                                }
                            }
                        } else {
                            try {
                                csvUrl = new URI(csvPath).toURL();
                            }
                            catch (MalformedURLException | URISyntaxException csvFilePath) {
                                // empty catch block
                            }
                        }
                        this.getCurrentChannel().updateRecorderFilePathData(ts, this.calledScript, this.paramsData, csvPath);
                        if (csvUrl == null) {
                            this.condition = null;
                            String errorMessage2 = "Parameter data file not found -> " + csvPath;
                            this.status.setError(-20, errorMessage2);
                            this.status.endDuration();
                            ts.callScriptFailed(testName, line, -20, errorMessage2);
                            return;
                        }
                        if (csvPath.startsWith(FILE_PROTOCOLE)) {
                            try {
                                File f = new File(csvUrl.toURI());
                                if (!f.isFile()) {
                                    errorMessage = "URL path is not a file -> " + csvPath;
                                    this.status.setError(-20, (String)errorMessage + "\n");
                                    ts.callScriptFailed(testName, line, -20, errorMessage);
                                }
                            }
                            catch (IllegalArgumentException | URISyntaxException e1) {
                                errorMessage = "URL path is not valid -> " + String.valueOf(e1);
                                this.status.setError(-20, errorMessage + "\n");
                                ts.callScriptFailed(testName, line, -20, errorMessage);
                            }
                        }
                        ParameterDataFile data = Utils.loadData(this.status, csvUrl);
                        if (this.status.isPassed()) {
                            String csvAbsoluteFilePath = null;
                            try {
                                csvAbsoluteFilePath = csvPath.startsWith(HTTP_PROTOCOLE) || csvPath.startsWith(HTTPS_PROTOCOLE) ? csvUrl.toString() : new File(csvUrl.toURI()).getAbsolutePath();
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                // empty catch block
                            }
                            this.getCurrentChannel().updateRecorderFilePathData(ts, this.calledScript, this.paramsData, csvPath);
                            ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
                            if (this.range != null) {
                                String[] rangeData;
                                for (String singleRange : rangeData = this.range.split(";")) {
                                    int mainIndex;
                                    String[] singleRangeData = singleRange.split("-");
                                    if (singleRangeData.length > 1) {
                                        int firstIndex = Utils.string2Int(singleRangeData[0], 0);
                                        int lastIndex = Utils.string2Int(singleRangeData[1], 0);
                                        if (firstIndex <= 0 || lastIndex <= 0) continue;
                                        if (firstIndex == lastIndex) {
                                            selectedIndexes.add(firstIndex);
                                            continue;
                                        }
                                        if (firstIndex >= lastIndex) continue;
                                        for (int i = firstIndex; i <= lastIndex; ++i) {
                                            selectedIndexes.add(i);
                                        }
                                        continue;
                                    }
                                    if (singleRangeData.length != 1 || (mainIndex = Utils.string2Int(singleRangeData[0], 0)) <= 0) continue;
                                    selectedIndexes.add(mainIndex);
                                }
                            }
                            ArrayList<ParameterList> selectedParameters = new ArrayList<ParameterList>();
                            if (selectedIndexes.size() > 0) {
                                int loop = 1;
                                for (ParameterList params : data.getData()) {
                                    if (selectedIndexes.indexOf(loop) > -1) {
                                        selectedParameters.add(params);
                                    }
                                    ++loop;
                                }
                            } else {
                                for (ParameterList params : data.getData()) {
                                    selectedParameters.add(params);
                                }
                            }
                            if (this.random) {
                                ParameterList randomParam = (ParameterList)selectedParameters.get((int)(Math.random() * (double)selectedParameters.size()));
                                selectedParameters.clear();
                                selectedParameters.add(randomParam);
                            }
                            int iterationsCount = selectedParameters.size();
                            int iteration = 1;
                            if (this.suite) {
                                Path outputDirectory = topScript.getSuiteOutputPath().getParent();
                                String suiteName = ActionCallscript.getSuiteName(1, outputDirectory, this.calledScript);
                                topScript.stopRecorder();
                                Map<String, String> suiteParameters = topScript.getTestExecutionVariables();
                                suiteParameters.put("ats-callscript-iteration", testName + ":" + line);
                                suiteParameters.put("ats-callscript-parameters", csvPath);
                                suiteParameters.putAll(AtsSingleton.getInstance().getGlobalVariables());
                                XmlSuite suite = new XmlSuite();
                                suite.setName(suiteName);
                                suite.setParameters(suiteParameters);
                                for (ParameterList params : selectedParameters) {
                                    XmlTest xmlTest = new XmlTest(suite);
                                    xmlTest.setName("iter" + iteration);
                                    xmlTest.addParameter("ats-iteration", String.valueOf(iteration));
                                    int loop = 0;
                                    for (Parameter param : params.getList()) {
                                        param.updateCalculated(ts);
                                        xmlTest.addParameter("#" + loop, param.getCalculated());
                                        xmlTest.addParameter(param.getName(), param.getCalculated());
                                        ++loop;
                                    }
                                    xmlTest.setXmlClasses(new ArrayList<XmlClass>(Arrays.asList(new XmlClass(this.calledScript))));
                                    ++iteration;
                                }
                                suite.setVerbose(Integer.valueOf(topScript.getVerbosity()));
                                TestNG tng = new TestNG();
                                tng.setUseDefaultListeners(false);
                                tng.addListener((ITestNGListener)new TestListenerAdapter());
                                tng.setOutputDirectory(outputDirectory.toAbsolutePath().toString());
                                tng.setXmlSuites(new ArrayList<XmlSuite>(Arrays.asList(suite)));
                                tng.setDefaultSuiteName("Callscript as a suite -> " + suiteName);
                                tng.run();
                                topScript.setTestList(tng.getTestListeners());
                            } else {
                                Method tc = clazz.getDeclaredMethod("testMain", new Class[0]);
                                ActionTestScript ats = this.getNewAtsInstance(clazz, topScript, this.calledScript);
                                String[] returns = null;
                                for (ParameterList row : selectedParameters) {
                                    this.callScriptWithParametersFile(tc, ats, ts, testName, line, row, this.getVariables(), iteration, iterationsCount, this.calledScript, csvAbsoluteFilePath);
                                    ++iteration;
                                    returns = ats.getReturnValues();
                                }
                                this.status.setData(returns);
                            }
                            break block41;
                        }
                        errorMessage = "URL path is not valid -> " + csvPath;
                        this.status.setError(-20, errorMessage + "\n");
                        ts.callScriptFailed(testName, line, -20, errorMessage);
                        break block41;
                    }
                    ActionTestScript ats = this.getNewAtsInstance(clazz, topScript, this.calledScript);
                    Method mainFunc = clazz.getDeclaredMethod("testMain", new Class[0]);
                    if (this.searchElement != null) {
                        List<ParameterList> data = ActionCallscript.getElementTextData(AtsSingleton.getInstance().getCurrentChannel(), this.searchElement);
                        int iterationMax = data.size();
                        for (int iteration = 1; iteration <= iterationMax; ++iteration) {
                            ats.initCalledScript(ts, testName, line, data.get(iteration - 1), this.getVariables(), iteration, iterationMax, this.calledScript, LOOP_LABEL, null);
                            mainFunc.invoke((Object)ats, new Object[0]);
                        }
                    } else {
                        for (int iteration = 1; iteration <= this.loop; ++iteration) {
                            ats.initCalledScript(ts, testName, line, this.parameters, this.getVariables(), iteration, this.loop, this.calledScript, LOOP_LABEL, null);
                            mainFunc.invoke((Object)ats, new Object[0]);
                        }
                    }
                    this.status.setData(ats.getReturnValues());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
                    String errorMessage = e.getMessage();
                    ts.callScriptFailed(testName, line, -99, errorMessage);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof AtsFailError) {
                        AtsFailError target = (AtsFailError)((Object)e.getTargetException());
                        ts.callScriptFailed(testName, line, -99, target.getInfo());
                        this.status.setError(-25, target.getFullMessage(ts.getLogger()));
                    }
                    String errorMessage = Utils.getCauseStackTraceString(e, "");
                    this.status.setError(-18, errorMessage + "\n");
                    ts.callScriptFailed(testName, line, -18, errorMessage);
                }
            }
        }
        this.condition = null;
        this.status.endDuration();
    }

    private static String getSuiteName(int i, Path folder, String name) {
        String suiteName = name + "-suite" + i;
        if (folder.resolve(suiteName).toFile().exists()) {
            return ActionCallscript.getSuiteName(i + 1, folder, name);
        }
        return suiteName;
    }

    public static List<ParameterList> getElementTextData(Channel channel, SearchedElement element) {
        TestElement foundElement = new TestElement(channel, 10, p -> p > 0, element);
        for (int max = 10; max > 0 && foundElement.getCount() == 0; --max) {
            channel.sleep(500);
            foundElement = new TestElement(channel, 10, p -> p > 0, element);
        }
        if (foundElement.getCount() > 0) {
            return foundElement.getTextData(false);
        }
        return Collections.emptyList();
    }

    private void callScriptWithParametersFile(Method mainFunc, ActionTestScript ats, ActionTestScript atsCaller, String testName, int line, ParameterList row, List<Variable> variables, int iteration, int iterationsCount, String scriptName, String csvAbsoluteFilePath) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        row.updateCalculated(atsCaller);
        ats.initCalledScript(atsCaller, testName, line, row, variables, iteration, iterationsCount, scriptName, "dataFile", csvAbsoluteFilePath);
        mainFunc.invoke((Object)ats, new Object[0]);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("status", "terminated");
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public void addParamsToData(ActionTestScript ts) {
        ParameterList paramsList;
        if (this.paramsData == null) {
            this.paramsData = new JsonObject();
        }
        if ((paramsList = this.getParameters()) != null && paramsList.getParametersSize() > 0) {
            String[] paramsArray = paramsList.getParameters();
            for (int ind = 0; ind < paramsList.getParametersSize(); ++ind) {
                this.paramsData.addProperty(Integer.toString(ind), paramsArray[ind]);
            }
            this.getCurrentChannel().updateRecorderData(ts, this.calledScript, this.paramsData);
        }
    }

    public CalculatedValue getName() {
        return this.name;
    }

    public void setName(CalculatedValue name) {
        this.name = name;
    }

    @Override
    public void setVariables(ArrayList<Variable> value) {
        if (value != null && value.size() > 0) {
            super.setVariables(value);
        }
    }

    public ParameterList getParameters() {
        return this.parameters;
    }

    public void setParameters(ParameterList value) {
        if (value != null && value.getParametersSize() > 0) {
            this.parameters = value;
            this.parameterFilePath = null;
        }
    }

    public void setParameters(ArrayList<CalculatedValue> calcs) {
        this.parameters = new ParameterList(1);
        int i = 0;
        for (CalculatedValue calc : calcs) {
            this.parameters.addParameter(new Parameter(i, calc));
            ++i;
        }
    }

    public int getLoop() {
        return this.loop;
    }

    public void setLoop(int loop) {
        if (loop <= 0) {
            loop = 1;
        }
        if (loop > 1) {
            this.parameterFilePath = null;
        }
        this.loop = loop;
    }

    public SearchedElement getSearchElement() {
        return this.searchElement;
    }

    public void setSearchElement(SearchedElement value) {
        this.searchElement = value;
    }

    public boolean isSuite() {
        return this.suite;
    }

    public void setSuite(boolean suite) {
        this.suite = suite;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String value) {
        this.range = value;
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }

    public CalculatedValue getParameterFilePath() {
        return this.parameterFilePath;
    }

    public void setParameterFilePath(CalculatedValue value) {
        this.parameterFilePath = value;
        if (value != null) {
            this.parameters = null;
        }
    }

    public ConditionalValue getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionalValue condition) {
        this.condition = condition;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public ArrayList<Variable> getScriptVariables() {
        return this.scriptVariables;
    }

    public void setScriptVariables(ArrayList<Variable> scriptVariable) {
        this.scriptVariables = scriptVariable;
    }
}

