/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.generator.variables.CalculatedValue;
import com.ats.recorder.IVisualRecorder;
import com.ats.recorder.VisualAction;
import com.ats.script.Script;
import com.ats.script.ScriptHeader;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.Action;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ActionComment
extends Action {
    public static final String SCRIPT_LABEL = "comment";
    private static final String STEP_TYPE = "step";
    private static final String LOG_TYPE = "log";
    private static final String SCRIPT_TYPE = "script";
    private static final String SUMMARY_TYPE = "summary";
    private CalculatedValue comment;
    private String type = "script";

    public ActionComment() {
    }

    public ActionComment(ScriptLoader script, String type, ArrayList<String> dataArray) {
        super(script);
        if (!SCRIPT_LABEL.equals(type)) {
            int minusPos = type.indexOf("-");
            if (minusPos > -1) {
                this.setType(type.substring(minusPos + 1));
            } else if (dataArray.size() > 0) {
                this.setType(dataArray.remove(0).trim());
            }
        }
        if (dataArray.size() > 0) {
            if (dataArray.size() > 1) {
                this.setType(dataArray.remove(0).trim());
            }
            this.setComment(new CalculatedValue(script, dataArray.remove(0).trim()));
        } else {
            this.setComment(new CalculatedValue(script));
        }
    }

    public ActionComment(ScriptLoader script, String data) {
        super(script);
        this.setType(SCRIPT_TYPE);
        this.setComment(new CalculatedValue(script, data));
    }

    public ActionComment(Script script, String type, CalculatedValue value) {
        super(script);
        this.setType(type);
        this.setComment(value);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("type", this.type);
        data.addProperty("value", this.comment.getCalculated());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append("\"").append(this.getType()).append("\", ").append(this.comment.getJavaCode()).append(")");
        return codeBuilder;
    }

    @Override
    public boolean isScriptComment() {
        return SCRIPT_TYPE.equals(this.type);
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.comment.getKeywords());
        return keywords;
    }

    @Override
    public Element getXmlElement(Document document, ScriptHeader header, int index, String errorText) {
        Element e = super.getXmlElement(document, header, index, errorText);
        e.appendChild(document.createElement("value")).setTextContent(this.getType());
        e.appendChild(document.createElement("data")).setTextContent(this.comment.getCalculated());
        return e;
    }

    @Override
    public VisualAction getVisualAction() {
        VisualAction va = super.getVisualAction();
        va.setValue(this.getType());
        va.setData(this.comment.getCalculated());
        return va;
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        this.status.setNoError();
        this.status.endDuration();
        if (STEP_TYPE.equals(this.type)) {
            this.getCurrentChannel().addStepComment(this, ts.getRecorder(), this.type, this.comment.getCalculated());
        } else if (LOG_TYPE.equals(this.type)) {
            ts.getTopScript().getLogger().sendComment(this.comment.getCalculated().replaceAll("<br>", "\n"));
        } else if (SUMMARY_TYPE.equals(this.type)) {
            ts.addSummary(this);
        }
    }

    @Override
    public void initAction(Channel channel, String testNameAndLine, IVisualRecorder recorder, String testName, int testLine) {
        if (STEP_TYPE.equals(this.type)) {
            super.initAction(channel, testNameAndLine, recorder, testName, testLine);
        }
    }

    public CalculatedValue getComment() {
        return this.comment;
    }

    public void setComment(CalculatedValue comment) {
        this.comment = comment;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = LOG_TYPE.equals(value) || STEP_TYPE.equals(value) || SUMMARY_TYPE.equals(value) ? value : SCRIPT_TYPE;
    }
}

