/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionExecuteElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class ActionSelect
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL_SELECT = "select";
    public static final String SELECT_TEXT = "text";
    public static final String SELECT_VALUE = "value";
    public static final String SELECT_INDEX = "index";
    private static final String KEEP_SELECT = "keep-select";
    private CalculatedProperty selectValue;
    private boolean keepSelect = false;

    public ActionSelect() {
    }

    public ActionSelect(ScriptLoader script, String data, int stopPolicy, ArrayList<String> options, ArrayList<String> objectArray) {
        super((Script)script, stopPolicy, options, objectArray);
        this.setSelectValue(new CalculatedProperty(script, data));
        this.setKeepSelect(options.stream().filter(str -> str.trim().contains(KEEP_SELECT)).findFirst().isPresent());
    }

    public ActionSelect(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedProperty selectValue) {
        super(script, stopPolicy, maxTry, delay, element);
        this.setSelectValue(selectValue);
    }

    public ActionSelect(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedProperty selectValue, boolean keepSelect) {
        super(script, stopPolicy, maxTry, delay, element);
        this.setSelectValue(selectValue);
        this.setKeepSelect(keepSelect);
    }

    public ActionSelect(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, boolean keepSelect) {
        super(script, stopPolicy, maxTry, delay, element);
        this.setKeepSelect(keepSelect);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode().append(", ").append(this.selectValue.getJavaCode());
        if (this.keepSelect) {
            codeBuilder.append(", true");
        }
        codeBuilder.append(")");
        return codeBuilder;
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            this.getTestElement().over(this.status, new MouseDirection(), false, 0, 0);
            ts.getRecorder().updateScreen(true);
            ts.getRecorder().updateScreen(this.status);
            this.getTestElement().select(this.status, this.selectValue, this.keepSelect);
        }
        this.status.endAction();
        ts.getRecorder().update(this.selectValue.getValue().getCalculated(), this.selectValue.getValue().getCalculated());
        this.getCurrentChannel().sleep(50);
        ts.getRecorder().updateScreen(false);
        ts.getRecorder().updateScreen(this.status);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty(SCRIPT_LABEL_SELECT, this.selectValue.getValue().getCalculated());
        data.addProperty("regexp", Boolean.valueOf(this.selectValue.isRegexp()));
        data.addProperty("name", this.selectValue.getName());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.addAll(this.selectValue.getKeywords());
        return keywords;
    }

    public CalculatedProperty getSelectValue() {
        return this.selectValue;
    }

    public void setSelectValue(CalculatedProperty value) {
        this.selectValue = value;
    }

    public boolean isKeepSelect() {
        return this.keepSelect;
    }

    public void setKeepSelect(boolean value) {
        this.keepSelect = value;
    }
}

