/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.generator.objects.TryAndDelay;
import com.ats.script.Script;
import com.ats.script.actions.ActionWindow;
import com.ats.script.actions.IActionStoppable;
import com.ats.tools.logger.ExecutionLogger;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class ActionWindowSwitch
extends ActionWindow
implements IActionStoppable {
    public static final String SCRIPT_SWITCH_LABEL = "window-switch";
    public static final String REFRESH_AFTER_SWITCH = "refresh";
    private int num = 0;
    private int tries = 0;
    private int delay = 0;
    private boolean refresh = false;

    public ActionWindowSwitch() {
    }

    public ActionWindowSwitch(Script script, int num, ArrayList<String> options) {
        super(script);
        int[] data = TryAndDelay.getTryAndDelay(options);
        this.setNum(num);
        this.setTries(data[0]);
        this.setDelay(data[1]);
        this.setRefresh(options.stream().filter(str -> str.trim().contains(REFRESH_AFTER_SWITCH)).findFirst().isPresent());
    }

    public ActionWindowSwitch(Script script, int tries, int num, int delay, boolean refresh) {
        super(script);
        this.setNum(num);
        this.setTries(tries);
        this.setDelay(delay);
        this.setRefresh(refresh);
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append(this.tries).append(", ").append(this.num).append(", ").append(this.delay).append(", ").append(this.refresh).append(")");
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
    }

    @Override
    public String exec(Channel channel, ExecutionLogger logger) {
        channel.switchWindow(this.status, this.num, this.tries, this.delay, this.refresh);
        return String.valueOf(this.num);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("index", (Number)this.num);
        data.addProperty("tries", (Number)this.tries);
        data.addProperty(REFRESH_AFTER_SWITCH, Boolean.valueOf(this.refresh));
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    @Override
    public boolean isStop() {
        return true;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public int getTries() {
        return this.tries;
    }

    public void setTries(int tries) {
        this.tries = tries;
    }
}

