/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools;

public class OperatingSystem {
    private static String OS = System.getProperty("os.name").toLowerCase();

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static String getOS() {
        if (OperatingSystem.isWindows()) {
            return "win";
        }
        if (OperatingSystem.isMac()) {
            return "osx";
        }
        if (OperatingSystem.isUnix()) {
            return "uni";
        }
        if (OperatingSystem.isSolaris()) {
            return "sol";
        }
        return "err";
    }

    public static String getOSName() {
        if (OperatingSystem.isWindows()) {
            return "windows";
        }
        if (OperatingSystem.isMac()) {
            return "macos";
        }
        if (OperatingSystem.isUnix()) {
            return "linux";
        }
        if (OperatingSystem.isSolaris()) {
            return "solaris";
        }
        return "err";
    }

    public static String getArchiveExtension() {
        if (OperatingSystem.isWindows()) {
            return "zip";
        }
        return "tgz";
    }
}

